/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AthenaIntegration;
import software.amazon.awssdk.services.ec2.model.AthenaIntegrationsSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegrateServices
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegrateServices> {
    private static final SdkField<List<AthenaIntegration>> ATHENA_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AthenaIntegrations").getter(IntegrateServices.getter(IntegrateServices::athenaIntegrations)).setter(IntegrateServices.setter(Builder::athenaIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaIntegration").unmarshallLocationName("AthenaIntegration").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AthenaIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_INTEGRATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegrateServices.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AthenaIntegration> athenaIntegrations;

    private IntegrateServices(BuilderImpl builder) {
        this.athenaIntegrations = builder.athenaIntegrations;
    }

    public final boolean hasAthenaIntegrations() {
        return this.athenaIntegrations != null && !(this.athenaIntegrations instanceof SdkAutoConstructList);
    }

    public final List<AthenaIntegration> athenaIntegrations() {
        return this.athenaIntegrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAthenaIntegrations() ? this.athenaIntegrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrateServices)) {
            return false;
        }
        IntegrateServices other = (IntegrateServices)obj;
        return this.hasAthenaIntegrations() == other.hasAthenaIntegrations() && Objects.equals(this.athenaIntegrations(), other.athenaIntegrations());
    }

    public final String toString() {
        return ToString.builder((String)"IntegrateServices").add("AthenaIntegrations", this.hasAthenaIntegrations() ? this.athenaIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AthenaIntegrations": {
                return Optional.ofNullable(clazz.cast(this.athenaIntegrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AthenaIntegration>>> map = new HashMap<String, SdkField<List<AthenaIntegration>>>();
        map.put("AthenaIntegration", ATHENA_INTEGRATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrateServices, T> g) {
        return obj -> g.apply((IntegrateServices)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AthenaIntegration> athenaIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrateServices model) {
            this.athenaIntegrations(model.athenaIntegrations);
        }

        public final List<AthenaIntegration.Builder> getAthenaIntegrations() {
            List<AthenaIntegration.Builder> result = AthenaIntegrationsSetCopier.copyToBuilder(this.athenaIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAthenaIntegrations(Collection<AthenaIntegration.BuilderImpl> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copyFromBuilder(athenaIntegrations);
        }

        @Override
        public final Builder athenaIntegrations(Collection<AthenaIntegration> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copy(athenaIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(AthenaIntegration ... athenaIntegrations) {
            this.athenaIntegrations(Arrays.asList(athenaIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(Consumer<AthenaIntegration.Builder> ... athenaIntegrations) {
            this.athenaIntegrations(Stream.of(athenaIntegrations).map(c -> (AthenaIntegration)((AthenaIntegration.Builder)AthenaIntegration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IntegrateServices build() {
            return new IntegrateServices(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegrateServices> {
        public Builder athenaIntegrations(Collection<AthenaIntegration> var1);

        public Builder athenaIntegrations(AthenaIntegration ... var1);

        public Builder athenaIntegrations(Consumer<AthenaIntegration.Builder> ... var1);
    }
}

