/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubnetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateSubnetResponse> {
    private static final SdkField<Subnet> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(CreateSubnetResponse.getter(CreateSubnetResponse::subnet)).setter(CreateSubnetResponse.setter(Builder::subnet)).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSubnetResponse.memberNameToFieldInitializer();
    private final Subnet subnet;

    private CreateSubnetResponse(BuilderImpl builder) {
        super(builder);
        this.subnet = builder.subnet;
    }

    public final Subnet subnet() {
        return this.subnet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetResponse)) {
            return false;
        }
        CreateSubnetResponse other = (CreateSubnetResponse)((Object)obj);
        return Objects.equals(this.subnet(), other.subnet());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubnetResponse").add("Subnet", (Object)this.subnet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Subnet>> map = new HashMap<String, SdkField<Subnet>>();
        map.put("Subnet", SUBNET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetResponse, T> g) {
        return obj -> g.apply((CreateSubnetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Subnet subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetResponse model) {
            super(model);
            this.subnet(model.subnet);
        }

        public final Subnet.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        public final void setSubnet(Subnet.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public final Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        @Override
        public CreateSubnetResponse build() {
            return new CreateSubnetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubnetResponse> {
        public Builder subnet(Subnet var1);

        default public Builder subnet(Consumer<Subnet.Builder> subnet) {
            return this.subnet((Subnet)((Subnet.Builder)Subnet.builder().applyMutation(subnet)).build());
        }
    }
}

