"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Partition = void 0;
var __1 = require("../..");
var constants_1 = require("../../../specs/constants");
var spec_factory_1 = require("../../../state/spec_factory");
var config_1 = require("../layout/config");
var group_by_rollup_1 = require("../layout/utils/group_by_rollup");
var defaultProps = {
    chartType: __1.ChartType.Partition,
    specType: constants_1.SpecType.Series,
    config: config_1.config,
    valueAccessor: function (d) { return (typeof d === 'number' ? d : 0); },
    valueGetter: function (n) { return n[group_by_rollup_1.AGGREGATE_KEY]; },
    valueFormatter: function (d) { return String(d); },
    percentFormatter: config_1.percentFormatter,
    topGroove: 20,
    smallMultiples: null,
    layers: [
        {
            groupByRollup: function (d, i) { return i; },
            nodeLabel: function (d) { return String(d); },
            showAccessor: function () { return true; },
            fillLabel: {},
        },
    ],
};
exports.Partition = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(defaultProps));
//# sourceMappingURL=index.js.map