"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescriptionList = exports.TEXT_STYLES = exports.ALIGNMENTS = exports.TYPES = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _description_list_title = require("./description_list_title");
var _description_list_description = require("./description_list_description");
var _common = require("../common");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var typesToClassNameMap = {
  row: 'euiDescriptionList--row',
  inline: 'euiDescriptionList--inline',
  column: 'euiDescriptionList--column',
  responsiveColumn: 'euiDescriptionList--responsiveColumn'
};
var TYPES = (0, _common.keysOf)(typesToClassNameMap);
exports.TYPES = TYPES;
var alignmentsToClassNameMap = {
  center: 'euiDescriptionList--center',
  left: ''
};
var ALIGNMENTS = (0, _common.keysOf)(alignmentsToClassNameMap);
exports.ALIGNMENTS = ALIGNMENTS;
var textStylesToClassNameMap = {
  normal: '',
  reverse: 'euiDescriptionList--reverse'
};
var TEXT_STYLES = (0, _common.keysOf)(textStylesToClassNameMap);
exports.TEXT_STYLES = TEXT_STYLES;
var EuiDescriptionList = function EuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'row' : _ref$type,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["align", "children", "className", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type"]);
  var classes = (0, _classnames.default)('euiDescriptionList', type ? typesToClassNameMap[type] : undefined, align ? alignmentsToClassNameMap[align] : undefined, textStyle ? textStylesToClassNameMap[textStyle] : undefined, {
    'euiDescriptionList--compressed': compressed
  }, className);
  var childrenOrListItems = null;
  if (listItems) {
    childrenOrListItems = listItems.map(function (item, index) {
      return [/*#__PURE__*/_react.default.createElement(_description_list_title.EuiDescriptionListTitle, (0, _extends2.default)({
        key: "title-".concat(index)
      }, titleProps), item.title), /*#__PURE__*/_react.default.createElement(_description_list_description.EuiDescriptionListDescription, (0, _extends2.default)({
        key: "description-".concat(index)
      }, descriptionProps), item.description)];
    });
  } else {
    childrenOrListItems = children;
  }
  return /*#__PURE__*/_react.default.createElement("dl", (0, _extends2.default)({
    className: classes
  }, rest), childrenOrListItems);
};
exports.EuiDescriptionList = EuiDescriptionList;
EuiDescriptionList.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  listItems: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.any.isRequired,
    description: _propTypes.default.any.isRequired
  }).isRequired),
  /**
     * Text alignment
     */
  align: _propTypes.default.oneOf(["center", "left"]),
  /**
     * Smaller text and condensed spacing
     */
  compressed: _propTypes.default.bool,
  /**
     * How should the content be styled, by default
     * this will emphasize the title
     */
  textStyle: _propTypes.default.oneOf(["normal", "reverse"]),
  /**
     * How each item should be laid out
     */
  type: _propTypes.default.oneOf(["row", "inline", "column", "responsiveColumn"]),
  /**
     * Props object to be passed to `EuiDescriptionListTitle`
     */
  titleProps: _propTypes.default.any,
  /**
     * Props object to be passed to `EuiDescriptionListDescription`
     */
  descriptionProps: _propTypes.default.any
};