/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.transport.ThresholdResultAction;
import org.opensearch.ad.transport.ThresholdResultRequest;
import org.opensearch.ad.transport.ThresholdResultResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ThresholdResultTransportAction
extends HandledTransportAction<ThresholdResultRequest, ThresholdResultResponse> {
    private static final Logger LOG = LogManager.getLogger(ThresholdResultTransportAction.class);
    private ADModelManager manager;

    @Inject
    public ThresholdResultTransportAction(ActionFilters actionFilters, TransportService transportService, ADModelManager manager) {
        super(ThresholdResultAction.NAME, transportService, actionFilters, ThresholdResultRequest::new);
        this.manager = manager;
    }

    protected void doExecute(Task task, ThresholdResultRequest request, ActionListener<ThresholdResultResponse> listener) {
        try {
            LOG.info("Serve threshold request for {}", (Object)request.getModelID());
            this.manager.getThresholdingResult(request.getAdID(), request.getModelID(), request.getRCFScore(), (ActionListener<ThresholdingResult>)ActionListener.wrap(result -> listener.onResponse((Object)new ThresholdResultResponse(result.getGrade(), result.getConfidence())), exception -> listener.onFailure(exception)));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }
}

