/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.config.CorrectionMode;
import com.amazon.randomcutforest.parkservices.config.ScoringStrategy;
import com.amazon.randomcutforest.parkservices.returntypes.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.state.returntypes.ComputeDescriptorState;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.returntypes.DiVectorMapper;

public class ComputeDescriptorMapper
implements IStateMapper<RCFComputeDescriptor, ComputeDescriptorState> {
    public RCFComputeDescriptor toModel(ComputeDescriptorState state, long seed) {
        RCFComputeDescriptor descriptor = new RCFComputeDescriptor(state.getCurrentInput(), state.getInputTimeStamp());
        descriptor.setRCFScore(state.getScore());
        descriptor.setInternalTimeStamp(state.getInternalTimeStamp());
        descriptor.setAttribution((DiVector)new DiVectorMapper().toModel((Object)state.getAttribution()));
        descriptor.setRCFPoint(CommonUtils.toFloatArrayNullable((double[])state.getPoint()));
        descriptor.setExpectedRCFPoint(CommonUtils.toFloatArrayNullable((double[])state.getExpectedPoint()));
        descriptor.setRelativeIndex(state.getRelativeIndex());
        descriptor.setScoringStrategy(ScoringStrategy.valueOf(state.getStrategy()));
        descriptor.setShift(state.getShift());
        descriptor.setPostShift(state.getPostShift());
        descriptor.setTransformDecay(state.getTransformDecay());
        descriptor.setPostDeviations(state.getPostDeviations());
        descriptor.setScale(state.getScale());
        descriptor.setAnomalyGrade(state.getAnomalyGrade());
        descriptor.setThreshold(state.getThreshold());
        descriptor.setCorrectionMode(CorrectionMode.valueOf(state.getCorrectionMode()));
        return descriptor;
    }

    public ComputeDescriptorState toState(RCFComputeDescriptor descriptor) {
        ComputeDescriptorState state = new ComputeDescriptorState();
        state.setInternalTimeStamp(descriptor.getInternalTimeStamp());
        state.setScore(descriptor.getRCFScore());
        state.setAttribution(new DiVectorMapper().toState(descriptor.getAttribution()));
        state.setPoint(CommonUtils.toDoubleArrayNullable((float[])descriptor.getRCFPoint()));
        state.setExpectedPoint(CommonUtils.toDoubleArrayNullable((float[])descriptor.getExpectedRCFPoint()));
        state.setRelativeIndex(descriptor.getRelativeIndex());
        state.setStrategy(descriptor.getScoringStrategy().name());
        state.setShift(descriptor.getShift());
        state.setPostShift(descriptor.getPostShift());
        state.setTransformDecay(descriptor.getTransformDecay());
        state.setPostDeviations(descriptor.getPostDeviations());
        state.setScale(descriptor.getScale());
        state.setAnomalyGrade(descriptor.getAnomalyGrade());
        state.setThreshold(descriptor.getThreshold());
        state.setCorrectionMode(descriptor.getCorrectionMode().name());
        state.setInputTimeStamp(descriptor.getInputTimestamp());
        state.setCurrentInput(descriptor.getCurrentInput());
        return state;
    }
}

