/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DirectoryBlockCachedObject
extends CachedObjectBase {
    static final int fileSizeFactor = 12;
    int[] tableId;
    int[] bitmapAddress;
    char[] freeSpace;
    char[] freeSpaceBlock;

    public DirectoryBlockCachedObject(int n) {
        this.tableId = new int[n];
        this.bitmapAddress = new int[n];
        this.freeSpace = new char[n];
        this.freeSpaceBlock = new char[n];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        int n;
        this.position = rowInputInterface.getFilePosition();
        int n2 = this.tableId.length;
        for (n = 0; n < n2; ++n) {
            this.tableId[n] = rowInputInterface.readInt();
        }
        for (n = 0; n < n2; ++n) {
            this.bitmapAddress[n] = rowInputInterface.readInt();
        }
        for (n = 0; n < n2; ++n) {
            this.freeSpace[n] = rowInputInterface.readChar();
        }
        for (n = 0; n < n2; ++n) {
            this.freeSpaceBlock[n] = rowInputInterface.readChar();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.tableId.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.tableId.length * 12;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n;
        int n2 = this.tableId.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.tableId[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.bitmapAddress[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpace[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpaceBlock[n]);
        }
        rowOutputInterface.writeEnd();
    }

    public void setTableId(int n, int n2) {
        this.tableId[n] = n2;
        this.hasChanged = true;
    }

    public void setBitmapAddress(int n, int n2) {
        this.bitmapAddress[n] = n2;
        this.hasChanged = true;
    }

    public void setFreeSpace(int n, char c) {
        this.freeSpace[n] = c;
        this.hasChanged = true;
    }

    public void setFreeBlock(int n, char c) {
        this.freeSpaceBlock[n] = c;
        this.hasChanged = true;
    }

    public void setLastUsed(int n, byte by) {
    }

    public int getTableId(int n) {
        return this.tableId[n];
    }

    public int getBitmapAddress(int n) {
        return this.bitmapAddress[n];
    }

    public char getFreeSpace(int n) {
        return this.freeSpace[n];
    }

    public char getFreeBlock(int n) {
        return this.freeSpaceBlock[n];
    }

    public int[] getTableIdArray() {
        return this.tableId;
    }

    public int[] getBitmapAddressArray() {
        return this.bitmapAddress;
    }

    public char[] getFreeSpaceArray() {
        return this.freeSpace;
    }

    public char[] getFreeBlockArray() {
        return this.freeSpaceBlock;
    }
}

