/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.diff.DiffProcessor;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class JsonDiff {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonPatch asJsonPatch(JsonNode source, JsonNode target) {
        BUNDLE.checkNotNull(source, "common.nullArgument");
        BUNDLE.checkNotNull(target, "common.nullArgument");
        Map<JsonPointer, JsonNode> unchanged = JsonDiff.getUnchangedValues(source, target);
        DiffProcessor processor = new DiffProcessor(unchanged);
        JsonDiff.generateDiffs(processor, JsonPointer.empty(), source, target);
        return processor.getPatch();
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) {
        try {
            String s2 = MAPPER.writeValueAsString(JsonDiff.asJsonPatch(source, target));
            return MAPPER.readTree(s2);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot generate JSON diff", e);
        }
    }

    private static void generateDiffs(DiffProcessor processor, JsonPointer pointer, JsonNode source, JsonNode target) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(source, target)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType(source);
        if (firstType != (secondType = NodeType.getNodeType(target))) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (!source.isContainerNode()) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(processor, pointer, (ObjectNode)source, (ObjectNode)target);
        } else {
            JsonDiff.generateArrayDiffs(processor, pointer, (ArrayNode)source, (ArrayNode)target);
        }
    }

    private static void generateObjectDiffs(DiffProcessor processor, JsonPointer pointer, ObjectNode source, ObjectNode target) {
        Set<String> firstFields = JsonDiff.collect(source.fieldNames(), new TreeSet());
        Set<String> secondFields = JsonDiff.collect(target.fieldNames(), new TreeSet());
        HashSet<String> copy1 = new HashSet<String>(firstFields);
        copy1.removeAll(secondFields);
        for (String string : Collections.unmodifiableSet(copy1)) {
            processor.valueRemoved(pointer.append(string), source.get(string));
        }
        HashSet<String> copy2 = new HashSet<String>(secondFields);
        copy2.removeAll(firstFields);
        for (String field : Collections.unmodifiableSet(copy2)) {
            processor.valueAdded(pointer.append(field), target.get(field));
        }
        HashSet<String> hashSet = new HashSet<String>(firstFields);
        hashSet.retainAll(secondFields);
        for (String field : hashSet) {
            JsonDiff.generateDiffs(processor, pointer.append(field), source.get(field), target.get(field));
        }
    }

    private static <T> Set<T> collect(Iterator<T> from, Set<T> to) {
        if (from == null) {
            throw new NullPointerException();
        }
        if (to == null) {
            throw new NullPointerException();
        }
        while (from.hasNext()) {
            to.add(from.next());
        }
        return Collections.unmodifiableSet(to);
    }

    private static void generateArrayDiffs(DiffProcessor processor, JsonPointer pointer, ArrayNode source, ArrayNode target) {
        int size;
        int index;
        int firstSize = source.size();
        int secondSize = target.size();
        for (index = size = Math.min(firstSize, secondSize); index < firstSize; ++index) {
            processor.valueRemoved(pointer.append(size), source.get(index));
        }
        for (index = 0; index < size; ++index) {
            JsonDiff.generateDiffs(processor, pointer.append(index), source.get(index), target.get(index));
        }
        for (index = size; index < secondSize; ++index) {
            processor.valueAdded(pointer.append("-"), target.get(index));
        }
    }

    static Map<JsonPointer, JsonNode> getUnchangedValues(JsonNode source, JsonNode target) {
        HashMap<JsonPointer, JsonNode> ret = new HashMap<JsonPointer, JsonNode>();
        JsonDiff.computeUnchanged(ret, JsonPointer.empty(), source, target);
        return ret;
    }

    private static void computeUnchanged(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode first, JsonNode second) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(first, second)) {
            ret.put(pointer, second);
            return;
        }
        NodeType firstType = NodeType.getNodeType(first);
        if (firstType != (secondType = NodeType.getNodeType(second))) {
            return;
        }
        switch (firstType) {
            case OBJECT: {
                JsonDiff.computeObject(ret, pointer, first, second);
                break;
            }
            case ARRAY: {
                JsonDiff.computeArray(ret, pointer, first, second);
                break;
            }
        }
    }

    private static void computeObject(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        Iterator<String> firstFields = source.fieldNames();
        while (firstFields.hasNext()) {
            String name = firstFields.next();
            if (!target.has(name)) continue;
            JsonDiff.computeUnchanged(ret, pointer.append(name), source.get(name), target.get(name));
        }
    }

    private static void computeArray(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        int size = Math.min(source.size(), target.size());
        for (int i = 0; i < size; ++i) {
            JsonDiff.computeUnchanged(ret, pointer.append(i), source.get(i), target.get(i));
        }
    }
}

