/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.EventQueue;
import java.awt.Image;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class JFXProjectIconAnnotator
implements ProjectIconAnnotator {
    private static final String JFX_BADGE_PATH = "org/netbeans/modules/javafx2/project/ui/resources/jfx_overlay.png";
    private final AtomicReference<Image> badgeCache = new AtomicReference();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final Map<Project, Boolean> projectType = Collections.synchronizedMap(new WeakHashMap());

    @NonNull
    public Image annotateIcon(@NonNull Project p, @NonNull Image original, boolean openedNode) {
        Boolean type = this.projectType.get(p);
        if (type != null) {
            Image badge;
            if (type.booleanValue() && (badge = this.getJFXBadge()) != null) {
                original = ImageUtilities.mergeImages((Image)original, (Image)badge, (int)8, (int)8);
            }
        } else {
            this.evaluateProjectType(p);
        }
        return original;
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
        assert (this.cs.hasListeners());
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public void fireChange(@NonNull Project p, boolean type) {
        this.projectType.put(p, type);
        this.cs.fireChange();
    }

    @NullUnknown
    private Image getJFXBadge() {
        Image img = this.badgeCache.get();
        if (img == null) {
            if (!EventQueue.isDispatchThread()) {
                img = ImageUtilities.loadImage((String)JFX_BADGE_PATH);
                this.badgeCache.set(img);
            } else {
                Runnable runLoadIcon = new Runnable(){

                    @Override
                    public void run() {
                        JFXProjectIconAnnotator.this.badgeCache.set(ImageUtilities.loadImage((String)JFXProjectIconAnnotator.JFX_BADGE_PATH));
                        JFXProjectIconAnnotator.this.cs.fireChange();
                    }
                };
                RequestProcessor RP = new RequestProcessor(JFXProjectIconAnnotator.class.getName());
                RP.post(runLoadIcon);
            }
        }
        return img;
    }

    private void evaluateProjectType(final @NonNull Project prj) {
        Runnable runEvaluateProject = new Runnable(){
            final /* synthetic */ JFXProjectIconAnnotator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean type = JFXProjectIconAnnotator.isFXProject(prj);
                this.this$0.projectType.put(prj, type);
                if (type) {
                    this.this$0.cs.fireChange();
                }
            }
        };
        if (!EventQueue.isDispatchThread()) {
            runEvaluateProject.run();
        } else {
            RequestProcessor RP = new RequestProcessor(JFXProjectIconAnnotator.class.getName());
            RP.post(runEvaluateProject);
        }
    }

    private static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator eval = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (eval == null) {
            return false;
        }
        return JFXProjectIconAnnotator.isTrue(eval.evaluator().getProperty("javafx.enabled"));
    }

    private static boolean isTrue(@NullAllowed String value) {
        return value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }
}

