/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.IOException;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Element;

public final class UpdateHelper {
    private final UpdateImplementation updateProject;
    private final AntProjectHelper helper;

    public UpdateHelper(UpdateImplementation update, AntProjectHelper helper) {
        assert (update != null);
        assert (helper != null);
        this.updateProject = update;
        this.helper = helper;
    }

    public EditableProperties getProperties(final String path) {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){
            final /* synthetic */ UpdateHelper this$0;
            {
                this.this$0 = this$0;
            }

            public EditableProperties run() {
                if (!this.this$0.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return this.this$0.updateProject.getUpdatedProjectProperties();
                }
                return this.this$0.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){
            final /* synthetic */ UpdateHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    this.this$0.helper.putProperties(path, props);
                } else if (this.this$0.updateProject.canUpdate()) {
                    try {
                        this.this$0.updateProject.saveUpdate(props);
                        this.this$0.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){
            final /* synthetic */ UpdateHelper this$0;
            {
                this.this$0 = this$0;
            }

            public Element run() {
                if (!shared || this.this$0.isCurrent()) {
                    return this.this$0.helper.getPrimaryConfigurationData(shared);
                }
                return this.this$0.updateProject.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){
            final /* synthetic */ UpdateHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!shared || this.this$0.isCurrent()) {
                    this.this$0.helper.putPrimaryConfigurationData(element, shared);
                } else if (this.this$0.updateProject.canUpdate()) {
                    try {
                        this.this$0.updateProject.saveUpdate(null);
                        this.this$0.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        });
    }

    public boolean requestUpdate() throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    if (UpdateHelper.this.isCurrent()) {
                        return true;
                    }
                    if (!UpdateHelper.this.updateProject.canUpdate()) {
                        return false;
                    }
                    UpdateHelper.this.updateProject.saveUpdate(null);
                    return true;
                }
            });
        }
        catch (MutexException ex) {
            Exception inner = ex.getException();
            if (inner instanceof IOException) {
                throw (IOException)inner;
            }
            throw (RuntimeException)inner;
        }
    }

    public boolean isCurrent() {
        return this.updateProject.isCurrent();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }
}

