/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ProgressProvider;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;

public abstract class AbstractApplyHintsRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
ProgressHandleWrapper.ProgressHandleAbstraction {
    private static final Logger LOG = Logger.getLogger(AbstractApplyHintsRefactoringPlugin.class.getName());
    private final AbstractRefactoring refactoring;
    private Comparator<FileObject> FILE_COMPARATOR = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    protected final AtomicBoolean cancel = new AtomicBoolean();
    private int lastWorkDone;

    protected AbstractApplyHintsRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }

    protected final Problem messagesToProblem(Collection<MessageImpl> problems) throws IllegalStateException {
        Problem current = null;
        for (MessageImpl problem : problems) {
            Problem p = new Problem(problem.kind == HintContext.MessageKind.ERROR, problem.text);
            if (current != null) {
                p.setNext(current);
            }
            current = p;
        }
        return current;
    }

    protected Collection<MessageImpl> performApplyPattern(Iterable<? extends HintDescription> pattern, BatchSearch.Scope scope, RefactoringElementsBag refactoringElements) {
        ProgressHandleWrapper w = new ProgressHandleWrapper((ProgressHandleWrapper.ProgressHandleAbstraction)this, new int[]{30, 70});
        BatchSearch.BatchResult candidates = BatchSearch.findOccurrences(pattern, (BatchSearch.Scope)scope, (ProgressHandleWrapper)w, (HintsSettings)HintsSettings.getGlobalSettings());
        ArrayList fileChanges = new ArrayList();
        LinkedList<MessageImpl> problems = new LinkedList<MessageImpl>(candidates.problems);
        IdentityHashMap changesPerFix = new IdentityHashMap();
        Collection res = BatchUtilities.applyFixes((BatchSearch.BatchResult)candidates, (ProgressHandleWrapper)w, (AtomicBoolean)this.cancel, fileChanges, changesPerFix, problems);
        Set<ModificationResult> enabled = Collections.newSetFromMap(new IdentityHashMap());
        HashMap<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes = new HashMap<FileObject, Map<JavaFix, ModificationResult>>();
        HashMap<FileObject, Set<FileObject>> affectedFiles = new HashMap<FileObject, Set<FileObject>>();
        TreeMap<FileObject, ArrayList<ModificationResultElement>> file2Changes = new TreeMap<FileObject, ArrayList<ModificationResultElement>>(this.FILE_COMPARATOR);
        for (Map.Entry changesPerFixEntry : changesPerFix.entrySet()) {
            enabled.add((ModificationResult)changesPerFixEntry.getValue());
            for (FileObject file : ((ModificationResult)changesPerFixEntry.getValue()).getModifiedFileObjects()) {
                ArrayList<ModificationResultElement> currentFileChanges = (ArrayList<ModificationResultElement>)file2Changes.get(file);
                if (currentFileChanges == null) {
                    currentFileChanges = new ArrayList<ModificationResultElement>();
                    file2Changes.put(file, currentFileChanges);
                }
                currentFileChanges.add(new ModificationResultElement(file, (JavaFix)changesPerFixEntry.getKey(), (ModificationResult)changesPerFixEntry.getValue(), enabled));
                IdentityHashMap<JavaFix, ModificationResult> perFile = (IdentityHashMap<JavaFix, ModificationResult>)file2Fixes2Changes.get(file);
                if (perFile == null) {
                    perFile = new IdentityHashMap<JavaFix, ModificationResult>();
                    file2Fixes2Changes.put(file, perFile);
                }
                perFile.put((JavaFix)changesPerFixEntry.getKey(), (ModificationResult)changesPerFixEntry.getValue());
                HashSet aff = (HashSet)affectedFiles.get(file);
                if (aff == null) {
                    aff = new HashSet();
                    affectedFiles.put(file, aff);
                }
                aff.addAll(((ModificationResult)changesPerFixEntry.getValue()).getModifiedFileObjects());
            }
        }
        for (List changes : file2Changes.values()) {
            changes.sort(new Comparator<RefactoringElementImplementation>(){

                @Override
                public int compare(RefactoringElementImplementation o1, RefactoringElementImplementation o2) {
                    return o1.getPosition().getBegin().getOffset() - o2.getPosition().getBegin().getOffset();
                }
            });
            refactoringElements.addAll(this.refactoring, (Collection)changes);
        }
        refactoringElements.registerTransaction((Transaction)new DelegatingTransaction(enabled, file2Fixes2Changes, affectedFiles, res));
        for (RefactoringElementImplementation fileChange : fileChanges) {
            refactoringElements.addFileChange(this.refactoring, fileChange);
        }
        w.finish();
        return problems;
    }

    protected final void prepareElements(BatchSearch.BatchResult candidates, ProgressHandleWrapper w, RefactoringElementsBag refactoringElements, final boolean verify, List<MessageImpl> problems) {
        final TreeMap<FileObject, Collection<RefactoringElementImplementation>> file2Changes = new TreeMap<FileObject, Collection<RefactoringElementImplementation>>(this.FILE_COMPARATOR);
        if (verify) {
            BatchSearch.getVerifiedSpans((BatchSearch.BatchResult)candidates, (ProgressHandleWrapper)w, (BatchSearch.VerifiedSpansCallBack)new BatchSearch.VerifiedSpansCallBack(){
                final /* synthetic */ AbstractApplyHintsRefactoringPlugin this$0;
                {
                    this.this$0 = this$0;
                }

                public void groupStarted() {
                }

                public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                    LinkedList<PositionBounds> spans = new LinkedList<PositionBounds>();
                    for (ErrorDescription errorDescription : hints) {
                        spans.add(errorDescription.getRange());
                    }
                    file2Changes.put(r.getResolvedFile(), Utilities.createRefactoringElementImplementation(r.getResolvedFile(), spans, verify));
                    return true;
                }

                public void groupFinished() {
                }

                public void cannotVerifySpan(BatchSearch.Resource r) {
                    file2Changes.put(r.getResolvedFile(), Utilities.createRefactoringElementImplementation(r.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(r), verify));
                }
            }, problems, (AtomicBoolean)this.cancel);
        } else {
            int[] parts = new int[candidates.getResources().size()];
            int index = 0;
            for (Collection resources : candidates.getResources()) {
                parts[index++] = resources.size();
            }
            ProgressHandleWrapper inner = w.startNextPartWithEmbedding(parts);
            for (Collection it : candidates.getResources()) {
                inner.startNextPart(it.size());
                for (BatchSearch.Resource r : it) {
                    file2Changes.put(r.getResolvedFile(), Utilities.createRefactoringElementImplementation(r.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(r), verify));
                    inner.tick();
                }
            }
        }
        for (Collection res : file2Changes.values()) {
            refactoringElements.addAll(this.refactoring, res);
        }
    }

    private static List<PositionBounds> prepareSpansFor(BatchSearch.Resource r) {
        return Utilities.prepareSpansFor(r.getResolvedFile(), r.getCandidateSpans());
    }

    public void start(int totalWork) {
        this.fireProgressListenerStart(-1, totalWork);
        this.lastWorkDone = 0;
    }

    public void progress(int currentWorkDone) {
        while (this.lastWorkDone < currentWorkDone) {
            this.fireProgressListenerStep(currentWorkDone);
            ++this.lastWorkDone;
        }
    }

    public void progress(String message) {
    }

    public void finish() {
        this.fireProgressListenerStop();
    }

    private static final class ModificationResultElement
    extends SimpleRefactoringElementImplementation {
        private PositionBounds bounds;
        private String displayText;
        private FileObject parentFile;
        private ModificationResult modification;
        private WeakReference<String> newFileContent;
        private final Set<ModificationResult> enabledResults;

        private ModificationResultElement(FileObject parentFile, JavaFix jf, ModificationResult modification, Set<ModificationResult> enabledResults) {
            PositionRef s = (PositionRef)((ModificationResult.Difference)modification.getDifferences(parentFile).iterator().next()).getStartPosition();
            this.bounds = new PositionBounds(s, s);
            this.displayText = jf.toEditorFix().getText();
            this.parentFile = parentFile;
            this.modification = modification;
            this.enabledResults = enabledResults;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.enabledResults.add(this.modification);
            } else {
                this.enabledResults.remove(this.modification);
            }
            super.setEnabled(enabled);
        }

        public boolean isEnabled() {
            return this.enabledResults.contains(this.modification);
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }

        public String getText() {
            return this.displayText;
        }

        public void performChange() {
        }

        public FileObject getParentFile() {
            return this.parentFile;
        }

        protected String getNewFileContent() {
            String result;
            if (!this.isEnabled()) {
                try {
                    return this.parentFile.asText();
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                    return null;
                }
            }
            String string = result = this.newFileContent != null ? (String)this.newFileContent.get() : null;
            if (result != null) {
                return result;
            }
            try {
                result = this.modification.getResultingSource(this.parentFile);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
                return null;
            }
            this.newFileContent = new WeakReference<String>(result);
            return result;
        }
    }

    private static final class DelegatingTransaction
    implements Transaction,
    ProgressProvider {
        private final Set<ModificationResult> enabled;
        private final Map<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes;
        private final Map<FileObject, Set<FileObject>> affectedFiles;
        private final Collection<? extends ModificationResult> completeModificationResult;
        private Transaction delegate;
        private ProgressSupport progressSupport;
        private final ProgressListener listener;

        public DelegatingTransaction(Set<ModificationResult> enabled, Map<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes, Map<FileObject, Set<FileObject>> affectedFiles, Collection<? extends ModificationResult> completeModificationResult) {
            this.enabled = enabled;
            this.file2Fixes2Changes = file2Fixes2Changes;
            this.affectedFiles = affectedFiles;
            this.completeModificationResult = completeModificationResult;
            this.listener = new ProgressListener(){

                public void start(ProgressEvent event) {
                    this.fireProgressListenerStart(event.getOperationType(), event.getCount());
                }

                public void step(ProgressEvent event) {
                    this.fireProgressListenerStep(event.getCount());
                }

                public void stop(ProgressEvent event) {
                    this.fireProgressListenerStop();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void commit() {
            ProgressProvider progressProvider;
            if (this.delegate == null) {
                HashSet<FileObject> toRecompute = new HashSet<FileObject>();
                for (ModificationResult modificationResult : this.completeModificationResult) {
                    for (FileObject modified : modificationResult.getModifiedFileObjects()) {
                        if (!this.affectedFiles.containsKey(modified)) {
                            assert (modificationResult.getDifferences(modified).isEmpty());
                            continue;
                        }
                        block5: for (FileObject affected : this.affectedFiles.get(modified)) {
                            for (Map.Entry entry : this.file2Fixes2Changes.get(affected).entrySet()) {
                                if (this.enabled.contains(entry.getValue())) continue;
                                toRecompute.add(affected);
                                continue block5;
                            }
                        }
                    }
                }
                HashMap<FileObject, ArrayList<JavaFix>> toRun = new HashMap<FileObject, ArrayList<JavaFix>>();
                for (FileObject r : toRecompute) {
                    for (ModificationResult modificationResult : this.completeModificationResult) {
                        List diffs = modificationResult.getDifferences(r);
                        if (diffs == null) continue;
                        for (ModificationResult.Difference difference : diffs) {
                            difference.exclude(true);
                        }
                    }
                    for (Map.Entry entry : this.file2Fixes2Changes.get(r).entrySet()) {
                        if (!this.enabled.contains(entry.getValue())) continue;
                        ArrayList<JavaFix> fixes2Run = (ArrayList<JavaFix>)toRun.get(r);
                        if (fixes2Run == null) {
                            fixes2Run = new ArrayList<JavaFix>();
                            toRun.put(r, fixes2Run);
                        }
                        fixes2Run.add((JavaFix)entry.getKey());
                    }
                }
                ArrayList<? extends ModificationResult> arrayList = new ArrayList<ModificationResult>(this.completeModificationResult);
                arrayList.addAll(BatchUtilities.applyFixes(toRun));
                this.delegate = JavaRefactoringPlugin.createTransaction(new LinkedList<ModificationResult>(arrayList));
            }
            if (this.delegate instanceof ProgressProvider) {
                progressProvider = (ProgressProvider)this.delegate;
                progressProvider.addProgressListener(this.listener);
            }
            try {
                this.delegate.commit();
            }
            finally {
                if (this.delegate instanceof ProgressProvider) {
                    progressProvider = (ProgressProvider)this.delegate;
                    progressProvider.removeProgressListener(this.listener);
                }
            }
        }

        public synchronized void rollback() {
            this.delegate.rollback();
        }

        public synchronized void addProgressListener(ProgressListener listener) {
            if (this.progressSupport == null) {
                this.progressSupport = new ProgressSupport();
            }
            this.progressSupport.addProgressListener(listener);
        }

        public synchronized void removeProgressListener(ProgressListener listener) {
            if (this.progressSupport != null) {
                this.progressSupport.removeProgressListener(listener);
            }
        }

        private void fireProgressListenerStart(int type, int count) {
            if (this.progressSupport != null) {
                this.progressSupport.fireProgressListenerStart(this, type, count);
            }
        }

        private void fireProgressListenerStep(int count) {
            if (this.progressSupport != null) {
                this.progressSupport.fireProgressListenerStep(this, count);
            }
        }

        private void fireProgressListenerStop() {
            if (this.progressSupport != null) {
                this.progressSupport.fireProgressListenerStop(this);
            }
        }

        public final class ProgressSupport {
            private final List<ProgressListener> progressListenerList = new ArrayList<ProgressListener>();
            private int counter;
            private boolean deterministic;

            public boolean isEmpty() {
                return this.progressListenerList.isEmpty();
            }

            public synchronized void addProgressListener(ProgressListener listener) {
                this.progressListenerList.add(listener);
            }

            public synchronized void removeProgressListener(ProgressListener listener) {
                this.progressListenerList.remove(listener);
            }

            public void fireProgressListenerStart(Object source, int type, int count) {
                ProgressListener[] listeners;
                this.counter = -1;
                this.deterministic = count > 0;
                ProgressEvent event = new ProgressEvent(source, 1, type, count);
                for (ProgressListener listener : listeners = this.getListenersCopy()) {
                    try {
                        listener.start(event);
                    }
                    catch (RuntimeException e) {
                        this.log(e);
                    }
                }
            }

            public void fireProgressListenerStart(int type, int count) {
                this.fireProgressListenerStart(this, type, count);
            }

            public void fireProgressListenerStep(Object source, int count) {
                ProgressListener[] listeners;
                if (this.deterministic) {
                    if (count < 0) {
                        this.deterministic = false;
                    }
                    this.counter = count;
                } else if (count > 0) {
                    this.deterministic = true;
                    this.counter = -1;
                } else {
                    this.counter = count;
                }
                ProgressEvent event = new ProgressEvent(source, 2, 0, count);
                for (ProgressListener listener : listeners = this.getListenersCopy()) {
                    try {
                        listener.step(event);
                    }
                    catch (RuntimeException e) {
                        this.log(e);
                    }
                }
            }

            public void fireProgressListenerStep(Object source) {
                if (this.deterministic) {
                    ++this.counter;
                }
                this.fireProgressListenerStep(source, this.counter);
            }

            public void fireProgressListenerStop(Object source) {
                ProgressListener[] listeners;
                ProgressEvent event = new ProgressEvent(source, 4);
                for (ProgressListener listener : listeners = this.getListenersCopy()) {
                    try {
                        listener.stop(event);
                    }
                    catch (RuntimeException e) {
                        this.log(e);
                    }
                }
            }

            public void fireProgressListenerStop() {
                this.fireProgressListenerStop(this);
            }

            private synchronized ProgressListener[] getListenersCopy() {
                return this.progressListenerList.toArray(new ProgressListener[0]);
            }

            private void log(Exception e) {
                Logger.getLogger(ProgressSupport.class.getName()).log(Level.INFO, e.getMessage(), e);
            }
        }
    }
}

