/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateVolumeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVolumeRequest
extends BmcRequest<UpdateVolumeDetails> {
    private String volumeId;
    private UpdateVolumeDetails updateVolumeDetails;
    private String ifMatch;

    public String getVolumeId() {
        return this.volumeId;
    }

    public UpdateVolumeDetails getUpdateVolumeDetails() {
        return this.updateVolumeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateVolumeDetails getBody$() {
        return this.updateVolumeDetails;
    }

    public Builder toBuilder() {
        return new Builder().volumeId(this.volumeId).updateVolumeDetails(this.updateVolumeDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeId=").append(String.valueOf(this.volumeId));
        sb.append(",updateVolumeDetails=").append(String.valueOf((Object)this.updateVolumeDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVolumeRequest)) {
            return false;
        }
        UpdateVolumeRequest other = (UpdateVolumeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeId, other.volumeId) && Objects.equals((Object)this.updateVolumeDetails, (Object)other.updateVolumeDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeId == null ? 43 : this.volumeId.hashCode());
        result = result * 59 + (this.updateVolumeDetails == null ? 43 : this.updateVolumeDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVolumeRequest, UpdateVolumeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeId = null;
        private UpdateVolumeDetails updateVolumeDetails = null;
        private String ifMatch = null;

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder updateVolumeDetails(UpdateVolumeDetails updateVolumeDetails) {
            this.updateVolumeDetails = updateVolumeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVolumeRequest o) {
            this.volumeId(o.getVolumeId());
            this.updateVolumeDetails(o.getUpdateVolumeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVolumeRequest build() {
            UpdateVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVolumeDetails body) {
            this.updateVolumeDetails(body);
            return this;
        }

        public UpdateVolumeRequest buildWithoutInvocationCallback() {
            UpdateVolumeRequest request = new UpdateVolumeRequest();
            request.volumeId = this.volumeId;
            request.updateVolumeDetails = this.updateVolumeDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

