/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.DpdConfig;
import com.oracle.bmc.core.model.PhaseOneConfigDetails;
import com.oracle.bmc.core.model.PhaseTwoConfigDetails;
import com.oracle.bmc.core.model.UpdateIPSecTunnelBgpSessionDetails;
import com.oracle.bmc.core.model.UpdateIPSecTunnelEncryptionDomainDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateIPSecConnectionTunnelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="routing")
    private final Routing routing;
    @JsonProperty(value="ikeVersion")
    private final IkeVersion ikeVersion;
    @JsonProperty(value="bgpSessionConfig")
    private final UpdateIPSecTunnelBgpSessionDetails bgpSessionConfig;
    @JsonProperty(value="oracleInitiation")
    private final OracleInitiation oracleInitiation;
    @JsonProperty(value="natTranslationEnabled")
    private final NatTranslationEnabled natTranslationEnabled;
    @JsonProperty(value="phaseOneConfig")
    private final PhaseOneConfigDetails phaseOneConfig;
    @JsonProperty(value="phaseTwoConfig")
    private final PhaseTwoConfigDetails phaseTwoConfig;
    @JsonProperty(value="dpdConfig")
    private final DpdConfig dpdConfig;
    @JsonProperty(value="encryptionDomainConfig")
    private final UpdateIPSecTunnelEncryptionDomainDetails encryptionDomainConfig;

    @Deprecated
    @ConstructorProperties(value={"displayName", "routing", "ikeVersion", "bgpSessionConfig", "oracleInitiation", "natTranslationEnabled", "phaseOneConfig", "phaseTwoConfig", "dpdConfig", "encryptionDomainConfig"})
    public UpdateIPSecConnectionTunnelDetails(String displayName, Routing routing, IkeVersion ikeVersion, UpdateIPSecTunnelBgpSessionDetails bgpSessionConfig, OracleInitiation oracleInitiation, NatTranslationEnabled natTranslationEnabled, PhaseOneConfigDetails phaseOneConfig, PhaseTwoConfigDetails phaseTwoConfig, DpdConfig dpdConfig, UpdateIPSecTunnelEncryptionDomainDetails encryptionDomainConfig) {
        this.displayName = displayName;
        this.routing = routing;
        this.ikeVersion = ikeVersion;
        this.bgpSessionConfig = bgpSessionConfig;
        this.oracleInitiation = oracleInitiation;
        this.natTranslationEnabled = natTranslationEnabled;
        this.phaseOneConfig = phaseOneConfig;
        this.phaseTwoConfig = phaseTwoConfig;
        this.dpdConfig = dpdConfig;
        this.encryptionDomainConfig = encryptionDomainConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Routing getRouting() {
        return this.routing;
    }

    public IkeVersion getIkeVersion() {
        return this.ikeVersion;
    }

    public UpdateIPSecTunnelBgpSessionDetails getBgpSessionConfig() {
        return this.bgpSessionConfig;
    }

    public OracleInitiation getOracleInitiation() {
        return this.oracleInitiation;
    }

    public NatTranslationEnabled getNatTranslationEnabled() {
        return this.natTranslationEnabled;
    }

    public PhaseOneConfigDetails getPhaseOneConfig() {
        return this.phaseOneConfig;
    }

    public PhaseTwoConfigDetails getPhaseTwoConfig() {
        return this.phaseTwoConfig;
    }

    public DpdConfig getDpdConfig() {
        return this.dpdConfig;
    }

    public UpdateIPSecTunnelEncryptionDomainDetails getEncryptionDomainConfig() {
        return this.encryptionDomainConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateIPSecConnectionTunnelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", routing=").append(String.valueOf((Object)this.routing));
        sb.append(", ikeVersion=").append(String.valueOf((Object)this.ikeVersion));
        sb.append(", bgpSessionConfig=").append(String.valueOf((Object)this.bgpSessionConfig));
        sb.append(", oracleInitiation=").append(String.valueOf((Object)this.oracleInitiation));
        sb.append(", natTranslationEnabled=").append(String.valueOf((Object)this.natTranslationEnabled));
        sb.append(", phaseOneConfig=").append(String.valueOf((Object)this.phaseOneConfig));
        sb.append(", phaseTwoConfig=").append(String.valueOf((Object)this.phaseTwoConfig));
        sb.append(", dpdConfig=").append(String.valueOf((Object)this.dpdConfig));
        sb.append(", encryptionDomainConfig=").append(String.valueOf((Object)this.encryptionDomainConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIPSecConnectionTunnelDetails)) {
            return false;
        }
        UpdateIPSecConnectionTunnelDetails other = (UpdateIPSecConnectionTunnelDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.routing, (Object)other.routing) && Objects.equals((Object)this.ikeVersion, (Object)other.ikeVersion) && Objects.equals((Object)this.bgpSessionConfig, (Object)other.bgpSessionConfig) && Objects.equals((Object)this.oracleInitiation, (Object)other.oracleInitiation) && Objects.equals((Object)this.natTranslationEnabled, (Object)other.natTranslationEnabled) && Objects.equals((Object)this.phaseOneConfig, (Object)other.phaseOneConfig) && Objects.equals((Object)this.phaseTwoConfig, (Object)other.phaseTwoConfig) && Objects.equals((Object)this.dpdConfig, (Object)other.dpdConfig) && Objects.equals((Object)this.encryptionDomainConfig, (Object)other.encryptionDomainConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.routing == null ? 43 : this.routing.hashCode());
        result = result * 59 + (this.ikeVersion == null ? 43 : this.ikeVersion.hashCode());
        result = result * 59 + (this.bgpSessionConfig == null ? 43 : this.bgpSessionConfig.hashCode());
        result = result * 59 + (this.oracleInitiation == null ? 43 : this.oracleInitiation.hashCode());
        result = result * 59 + (this.natTranslationEnabled == null ? 43 : this.natTranslationEnabled.hashCode());
        result = result * 59 + (this.phaseOneConfig == null ? 43 : this.phaseOneConfig.hashCode());
        result = result * 59 + (this.phaseTwoConfig == null ? 43 : this.phaseTwoConfig.hashCode());
        result = result * 59 + (this.dpdConfig == null ? 43 : this.dpdConfig.hashCode());
        result = result * 59 + (this.encryptionDomainConfig == null ? 43 : this.encryptionDomainConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NatTranslationEnabled implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        Auto("AUTO");

        private final String value;
        private static Map<String, NatTranslationEnabled> map;

        private NatTranslationEnabled(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NatTranslationEnabled create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NatTranslationEnabled: " + key);
        }

        static {
            map = new HashMap<String, NatTranslationEnabled>();
            for (NatTranslationEnabled v : NatTranslationEnabled.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OracleInitiation implements BmcEnum
    {
        InitiatorOrResponder("INITIATOR_OR_RESPONDER"),
        ResponderOnly("RESPONDER_ONLY");

        private final String value;
        private static Map<String, OracleInitiation> map;

        private OracleInitiation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OracleInitiation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OracleInitiation: " + key);
        }

        static {
            map = new HashMap<String, OracleInitiation>();
            for (OracleInitiation v : OracleInitiation.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IkeVersion implements BmcEnum
    {
        V1("V1"),
        V2("V2");

        private final String value;
        private static Map<String, IkeVersion> map;

        private IkeVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IkeVersion create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IkeVersion: " + key);
        }

        static {
            map = new HashMap<String, IkeVersion>();
            for (IkeVersion v : IkeVersion.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Routing implements BmcEnum
    {
        Bgp("BGP"),
        Static("STATIC"),
        Policy("POLICY");

        private final String value;
        private static Map<String, Routing> map;

        private Routing(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Routing create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Routing: " + key);
        }

        static {
            map = new HashMap<String, Routing>();
            for (Routing v : Routing.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="routing")
        private Routing routing;
        @JsonProperty(value="ikeVersion")
        private IkeVersion ikeVersion;
        @JsonProperty(value="bgpSessionConfig")
        private UpdateIPSecTunnelBgpSessionDetails bgpSessionConfig;
        @JsonProperty(value="oracleInitiation")
        private OracleInitiation oracleInitiation;
        @JsonProperty(value="natTranslationEnabled")
        private NatTranslationEnabled natTranslationEnabled;
        @JsonProperty(value="phaseOneConfig")
        private PhaseOneConfigDetails phaseOneConfig;
        @JsonProperty(value="phaseTwoConfig")
        private PhaseTwoConfigDetails phaseTwoConfig;
        @JsonProperty(value="dpdConfig")
        private DpdConfig dpdConfig;
        @JsonProperty(value="encryptionDomainConfig")
        private UpdateIPSecTunnelEncryptionDomainDetails encryptionDomainConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder routing(Routing routing) {
            this.routing = routing;
            this.__explicitlySet__.add("routing");
            return this;
        }

        public Builder ikeVersion(IkeVersion ikeVersion) {
            this.ikeVersion = ikeVersion;
            this.__explicitlySet__.add("ikeVersion");
            return this;
        }

        public Builder bgpSessionConfig(UpdateIPSecTunnelBgpSessionDetails bgpSessionConfig) {
            this.bgpSessionConfig = bgpSessionConfig;
            this.__explicitlySet__.add("bgpSessionConfig");
            return this;
        }

        public Builder oracleInitiation(OracleInitiation oracleInitiation) {
            this.oracleInitiation = oracleInitiation;
            this.__explicitlySet__.add("oracleInitiation");
            return this;
        }

        public Builder natTranslationEnabled(NatTranslationEnabled natTranslationEnabled) {
            this.natTranslationEnabled = natTranslationEnabled;
            this.__explicitlySet__.add("natTranslationEnabled");
            return this;
        }

        public Builder phaseOneConfig(PhaseOneConfigDetails phaseOneConfig) {
            this.phaseOneConfig = phaseOneConfig;
            this.__explicitlySet__.add("phaseOneConfig");
            return this;
        }

        public Builder phaseTwoConfig(PhaseTwoConfigDetails phaseTwoConfig) {
            this.phaseTwoConfig = phaseTwoConfig;
            this.__explicitlySet__.add("phaseTwoConfig");
            return this;
        }

        public Builder dpdConfig(DpdConfig dpdConfig) {
            this.dpdConfig = dpdConfig;
            this.__explicitlySet__.add("dpdConfig");
            return this;
        }

        public Builder encryptionDomainConfig(UpdateIPSecTunnelEncryptionDomainDetails encryptionDomainConfig) {
            this.encryptionDomainConfig = encryptionDomainConfig;
            this.__explicitlySet__.add("encryptionDomainConfig");
            return this;
        }

        public UpdateIPSecConnectionTunnelDetails build() {
            UpdateIPSecConnectionTunnelDetails model = new UpdateIPSecConnectionTunnelDetails(this.displayName, this.routing, this.ikeVersion, this.bgpSessionConfig, this.oracleInitiation, this.natTranslationEnabled, this.phaseOneConfig, this.phaseTwoConfig, this.dpdConfig, this.encryptionDomainConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateIPSecConnectionTunnelDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("routing")) {
                this.routing(model.getRouting());
            }
            if (model.wasPropertyExplicitlySet("ikeVersion")) {
                this.ikeVersion(model.getIkeVersion());
            }
            if (model.wasPropertyExplicitlySet("bgpSessionConfig")) {
                this.bgpSessionConfig(model.getBgpSessionConfig());
            }
            if (model.wasPropertyExplicitlySet("oracleInitiation")) {
                this.oracleInitiation(model.getOracleInitiation());
            }
            if (model.wasPropertyExplicitlySet("natTranslationEnabled")) {
                this.natTranslationEnabled(model.getNatTranslationEnabled());
            }
            if (model.wasPropertyExplicitlySet("phaseOneConfig")) {
                this.phaseOneConfig(model.getPhaseOneConfig());
            }
            if (model.wasPropertyExplicitlySet("phaseTwoConfig")) {
                this.phaseTwoConfig(model.getPhaseTwoConfig());
            }
            if (model.wasPropertyExplicitlySet("dpdConfig")) {
                this.dpdConfig(model.getDpdConfig());
            }
            if (model.wasPropertyExplicitlySet("encryptionDomainConfig")) {
                this.encryptionDomainConfig(model.getEncryptionDomainConfig());
            }
            return this;
        }
    }
}

