/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.ui.actions.Bundle;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class NpmRunScriptAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private static final String PRE_PREFIX = "pre";
    private static final String POST_PREFIX = "post";
    private static final String INSTALL_COMMAND = "install";
    static final RequestProcessor RP = new RequestProcessor(NpmRunScriptAction.class);
    final Project project;
    final List<String> scripts = new CopyOnWriteArrayList<String>();

    public NpmRunScriptAction() {
        this((Project)null, (Collection<String>)null);
    }

    public NpmRunScriptAction(Project project, Collection<String> scripts) {
        this.project = project;
        if (scripts != null) {
            this.scripts.addAll(scripts);
        }
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        Pair<Project, PackageJson> data = NodeJsUtils.getProjectAndPackageJson(context);
        Project contextProject = (Project)data.first();
        if (contextProject == null) {
            return this;
        }
        PackageJson packageJson = (PackageJson)data.second();
        if (packageJson == null) {
            return this;
        }
        Map allScripts = packageJson.getContentValue(Map.class, "scripts");
        if (allScripts == null || allScripts.isEmpty()) {
            return this;
        }
        List<String> allScriptsList = this.sanitizeScripts(allScripts.keySet());
        if (allScriptsList.isEmpty()) {
            return this;
        }
        return new NpmRunScriptAction(contextProject, allScriptsList);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return this.createScriptsMenu();
    }

    private List<String> sanitizeScripts(Collection<String> allScripts) {
        HashSet<String> allCommands = new HashSet<String>();
        for (String script : allScripts) {
            String command = script.startsWith(PRE_PREFIX) ? script.substring(PRE_PREFIX.length()) : (script.startsWith(POST_PREFIX) ? script.substring(POST_PREFIX.length()) : script);
            if (INSTALL_COMMAND.equals(command) || !StringUtilities.hasText((String)command)) continue;
            allCommands.add(command);
        }
        ArrayList<String> commands = new ArrayList<String>(allCommands);
        Collections.sort(commands);
        return commands;
    }

    private JMenuItem createScriptsMenu() {
        assert (this.project != null);
        assert (!this.scripts.isEmpty());
        JMenu menu = new JMenu(Bundle.NpmRunScriptAction_name());
        for (final String command : this.scripts) {
            JMenuItem menuItem = new JMenuItem(command);
            menuItem.addActionListener(new ActionListener(){
                final /* synthetic */ NpmRunScriptAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    final NpmExecutable npm = NpmExecutable.getDefault(this.this$0.project, true);
                    if (npm == null) {
                        return;
                    }
                    RP.post(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            NodeJsUtils.logUsageNpmRunScript(command);
                            npm.runScript(command);
                        }
                    });
                }
            });
            menu.add(menuItem);
        }
        return menu;
    }
}

