/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.classfile.ClassFileCache;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;

public class LazyDynamicClassInfo
extends DynamicClassInfo {
    private boolean isInitilaized;
    private boolean isInterface;

    public LazyDynamicClassInfo(String className, int loaderId, String classFileLocation, String superClassName, String[] interfaceNames) throws IOException {
        super(className, loaderId, classFileLocation, false);
        this.superName = superClassName;
        this.interfaces = interfaceNames;
    }

    @Override
    public int getMethodIndex(String name, String sig) {
        if (this.initializeClassFile()) {
            return super.getMethodIndex(name, sig);
        }
        return -1;
    }

    @Override
    public String[] getMethodNames() {
        if (this.initializeClassFile()) {
            return super.getMethodNames();
        }
        return new String[0];
    }

    @Override
    public void preloadBytecode() {
        super.preloadBytecode();
        if (!this.isInitilaized) {
            ClassFileCache.getDefault().preloadBytecode(this.getName(), this.getClassFileLocation());
        }
    }

    @Override
    public boolean isInterface() {
        if (!this.isInitilaized) {
            return this.isInterface;
        }
        return super.isInterface();
    }

    @Override
    public void setInterface() {
        this.isInterface = true;
    }

    private boolean initializeClassFile() {
        if (!this.isInitilaized) {
            this.isInitilaized = true;
            try {
                this.parseClassFile(this.getName());
                return true;
            }
            catch (ClassFormatError ex) {
                Logger.getLogger(LazyDynamicClassInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(LazyDynamicClassInfo.class.getName()).log(Level.INFO, null, ex);
            }
            return false;
        }
        return true;
    }
}

