/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionGenerateFromImplVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionGenerateFromIntfVisitor;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.util.Exceptions;

public final class SessionMethodController
extends AbstractMethodController {
    private final MetadataModel<EjbJarMetadata> model;
    private final String sessionType;
    private final boolean allowsNoInterface;

    public SessionMethodController(String ejbClass, MetadataModel<EjbJarMetadata> model) {
        this(ejbClass, model, false);
    }

    public SessionMethodController(final String ejbClass, MetadataModel<EjbJarMetadata> model, boolean allowsNoInterface) {
        super(ejbClass, model);
        this.model = model;
        this.allowsNoInterface = allowsNoInterface;
        String resultSessionType = null;
        try {
            resultSessionType = (String)model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){
                final /* synthetic */ SessionMethodController this$0;
                {
                    this.this$0 = this$0;
                }

                public String run(EjbJarMetadata metadata) throws Exception {
                    Session session = (Session)metadata.findByEjbClass(ejbClass);
                    if (session != null) {
                        return session.getSessionType();
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.sessionType = resultSessionType;
    }

    @Override
    public boolean hasJavaImplementation(MethodModel intfView) {
        return true;
    }

    @Override
    public boolean hasJavaImplementation(MethodType methodType) {
        return true;
    }

    @Override
    public MethodType getMethodTypeFromImpl(MethodModel implView) {
        MethodType methodType = null;
        if (implView.getName().startsWith("ejbCreate")) {
            methodType = new MethodType.CreateMethodType(implView);
        } else if (!implView.getName().startsWith("ejb")) {
            methodType = new MethodType.BusinessMethodType(implView);
        }
        return methodType;
    }

    @Override
    public MethodType getMethodTypeFromInterface(MethodModel clientView) {
        String localHome = this.getLocalHome();
        String home = this.getHome();
        if (localHome != null && this.findInClass(localHome, clientView) || home != null && this.findInClass(home, clientView)) {
            return new MethodType.CreateMethodType(clientView);
        }
        return new MethodType.BusinessMethodType(clientView);
    }

    @Override
    public AbstractMethodController.GenerateFromImpl createGenerateFromImpl() {
        return new SessionGenerateFromImplVisitor();
    }

    @Override
    public AbstractMethodController.GenerateFromIntf createGenerateFromIntf() {
        return new SessionGenerateFromIntfVisitor();
    }

    @Override
    public boolean supportsMethodType(MethodType.Kind methodType) {
        boolean stateless = "Stateless".equals(this.sessionType);
        return methodType == MethodType.Kind.BUSINESS || !this.isSimplified() && !stateless && methodType == MethodType.Kind.CREATE;
    }

    @Override
    public boolean allowsNoInterface() {
        return this.allowsNoInterface;
    }
}

