/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Dialog;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.xml.catalog.CatalogEntryPanel;
import org.netbeans.modules.xml.catalog.CatalogNode;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddCatalogEntryAction
extends NodeAction {
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_HTTPS = "https://";
    private static final String PROTOCOL_FILE = "file:/";
    private static final String MIME_SCHEMA = "application/x-schema+xml";
    private static final String MIME_SCHEMA2 = "text/xsd+xml";

    protected void performAction(Node[] activatedNodes) {
        AddCatalogEntryAction.perform(activatedNodes);
    }

    public static void perform(Node[] activatedNodes) {
        CatalogNode node = (CatalogNode)activatedNodes[0].getCookie(CatalogNode.class);
        CatalogWriter catalog = (CatalogWriter)node.getCatalogReader();
        CatalogEntryPanel panel = new CatalogEntryPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(AddCatalogEntryAction.class, (String)"TITLE_addCatalogEntry"));
        panel.setEnclosingDesc(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dd.setValid(false);
        dialog.setVisible(true);
        if (dd.getValue().equals(DialogDescriptor.OK_OPTION)) {
            if (panel.isPublic()) {
                catalog.registerCatalogEntry("PUBLIC:" + panel.getPublicId(), panel.getUri());
            } else if (AddCatalogEntryAction.isXmlSchema(panel.getSystemId(), panel.getUri())) {
                catalog.registerCatalogEntry("SCHEMA:" + panel.getSystemId(), panel.getUri());
            } else {
                catalog.registerCatalogEntry("SYSTEM:" + panel.getSystemId(), panel.getUri());
            }
        }
    }

    private static boolean isXmlSchema(String uri, String localURI) {
        FileObject fo;
        if (!uri.startsWith(PROTOCOL_HTTP) && !uri.startsWith(PROTOCOL_HTTPS)) {
            return false;
        }
        if (!localURI.startsWith(PROTOCOL_FILE)) {
            return false;
        }
        try {
            fo = URLMapper.findFileObject((URL)new URL(localURI));
            if (fo == null) {
                return false;
            }
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return MIME_SCHEMA.equals(fo.getMIMEType()) || MIME_SCHEMA2.equals(fo.getMIMEType());
    }

    protected boolean enable(Node[] activatedNodes) {
        Node.Cookie node;
        return activatedNodes.length > 0 && (node = activatedNodes[0].getCookie(CatalogNode.class)) instanceof CatalogNode && ((CatalogNode)node).getCatalogReader() instanceof CatalogWriter;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return NbBundle.getMessage(AddCatalogEntryAction.class, (String)"TXT_AddCatalogEntry");
    }
}

