/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.Completion;
import org.netbeans.modules.javadoc.hints.Bundle;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class GenerateJavadocCollector
implements CompletionCollector {
    public boolean collectCompletions(Document doc, int offset, Completion.Context context, final Consumer<Completion> consumer) {
        if (context != null && context.getTriggerKind() == Completion.TriggerKind.TriggerCharacter && context.getTriggerCharacter().charValue() == '*') {
            AtomicReference ref = new AtomicReference();
            doc.render(() -> ref.set(SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)offset)));
            final TokenSequence ts = (TokenSequence)ref.get();
            if (ts != null) {
                ts.move(offset);
                if (ts.moveNext() && ts.token().id() == JavaTokenId.JAVADOC_COMMENT) {
                    JavaSource js;
                    final int jdBeginOffset = ts.offset();
                    String text = ts.token().text().toString();
                    if (text.substring(3, text.length() - 2).trim().isEmpty() && (js = JavaSource.forDocument((Document)doc)) != null) {
                        FileObject file = (FileObject)js.getFileObjects().iterator().next();
                        SourceVersion sv = JavadocUtilities.resolveSourceVersion(file);
                        final JavadocGenerator gen = new JavadocGenerator(sv);
                        gen.updateSettings(file);
                        try {
                            js.runUserActionTask((Task)new Task<CompilationController>(){
                                final /* synthetic */ GenerateJavadocCollector this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public void run(CompilationController cc) throws Exception {
                                    String javadoc;
                                    Element el;
                                    TreePath tp;
                                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    int offsetBehindJavadoc = ts.offset() + ts.token().length();
                                    while (ts.moveNext()) {
                                        JavaTokenId tid = (JavaTokenId)ts.token().id();
                                        if (tid == JavaTokenId.WHITESPACE || tid == JavaTokenId.LINE_COMMENT || tid == JavaTokenId.BLOCK_COMMENT) continue;
                                        offsetBehindJavadoc = ts.offset() + 1;
                                        break;
                                    }
                                    for (tp = cc.getTreeUtilities().pathFor(offsetBehindJavadoc); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) && tp.getLeaf().getKind() != Tree.Kind.METHOD && tp.getLeaf().getKind() != Tree.Kind.VARIABLE; tp = tp.getParentPath()) {
                                    }
                                    if (tp != null && cc.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tp.getLeaf()) >= (long)jdBeginOffset && (el = cc.getTrees().getElement(tp)) != null && (javadoc = gen.generateComment(el, (CompilationInfo)cc)) != null) {
                                        StringBuilder sb = new StringBuilder("\n * ${0}");
                                        boolean first = true;
                                        for (String s : javadoc.split("\n")) {
                                            if (first && s.isEmpty()) {
                                                sb.append('\n');
                                            } else {
                                                sb.append(" * ").append(s).append('\n');
                                            }
                                            first = false;
                                        }
                                        consumer.accept(CompletionCollector.newBuilder((String)Bundle.DN_JavadocComment()).kind(Completion.Kind.Snippet).insertText(sb.toString()).insertTextFormat(Completion.TextFormat.Snippet).documentation(javadoc).build());
                                    }
                                }
                            }, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
        return true;
    }
}

