/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLResolveOperation
extends HCLExpression {
    public HCLExpression base();

    @Override
    default public List<? extends HCLExpression> elements() {
        return List.of(this.base());
    }

    public record FullSplat(HCLExpression base) implements HCLResolveOperation
    {
        public FullSplat {
            Objects.requireNonNull(base, "base cannot be null");
        }

        @Override
        public String asString() {
            return this.base.asString() + "[*]";
        }
    }

    public record AttrSplat(HCLExpression base) implements HCLResolveOperation
    {
        public AttrSplat {
            Objects.requireNonNull(base, "base cannot be null");
        }

        @Override
        public String asString() {
            return this.base.asString() + ".*";
        }
    }

    public record Index(HCLExpression base, HCLExpression index, boolean legacy) implements HCLResolveOperation
    {
        public Index {
            Objects.requireNonNull(base, "base cannot be null");
            Objects.requireNonNull(index, "index cannot be null");
        }

        @Override
        public String asString() {
            return this.base.asString() + (this.legacy ? "." + this.index.asString() : "[" + this.index.asString() + "]");
        }

        @Override
        public List<? extends HCLExpression> elements() {
            return List.of(this.base, this.index);
        }
    }

    public record Attribute(HCLExpression base, HCLIdentifier attr) implements HCLResolveOperation
    {
        public Attribute {
            Objects.requireNonNull(base, "base cannot be null");
        }

        @Override
        public String asString() {
            return this.base.asString() + "." + HCLExpression.asString(this.attr);
        }
    }
}

