/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalBackupJobRequest
extends BmcRequest<Void> {
    private String backupId;

    public String getBackupId() {
        return this.backupId;
    }

    public Builder toBuilder() {
        return new Builder().backupId(this.backupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",backupId=").append(String.valueOf(this.backupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalBackupJobRequest)) {
            return false;
        }
        GetExternalBackupJobRequest other = (GetExternalBackupJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.backupId, other.backupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.backupId == null ? 43 : this.backupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalBackupJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String backupId = null;

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalBackupJobRequest o) {
            this.backupId(o.getBackupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalBackupJobRequest build() {
            GetExternalBackupJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalBackupJobRequest buildWithoutInvocationCallback() {
            GetExternalBackupJobRequest request = new GetExternalBackupJobRequest();
            request.backupId = this.backupId;
            return request;
        }
    }
}

