/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class HeaderComponent
extends JComponent {
    private boolean isPressed;
    private boolean isSelected;
    private static CellRendererPane PAINTER;
    private static JTable REF_TABLE;

    HeaderComponent(final ActionListener listener) {
        if (listener != null) {
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ HeaderComponent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.this$0.isPressed = true;
                    this.this$0.isSelected = true;
                    this.this$0.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.this$0.isPressed = false;
                    if (this.this$0.isSelected) {
                        this.this$0.repaint();
                        this.fireActionEvent(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (this.this$0.isPressed || !this.isButtonDown(e)) {
                        this.this$0.isSelected = true;
                        this.this$0.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (this.this$0.isSelected) {
                        this.this$0.isSelected = false;
                        this.this$0.repaint();
                    }
                }

                private void fireActionEvent(MouseEvent e) {
                    ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), e.paramString(), e.getWhen(), e.getModifiers());
                    listener.actionPerformed(ae);
                }

                private boolean isButtonDown(MouseEvent e) {
                    return SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e);
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        JTableHeader header = HeaderComponent.getHeader();
        this.setupHeader(header);
        TableCellRenderer renderer = header.getDefaultRenderer();
        JComponent component = (JComponent)renderer.getTableCellRendererComponent(HeaderComponent.getTable(), "", this.isSelected && this.isPressed, this.isFocusOwner(), -1, 0);
        int height = header.getPreferredSize().height;
        component.setBounds(0, 0, this.getWidth(), height);
        component.setOpaque(false);
        HeaderComponent.getPainter().paintComponent(g, component, null, 0, 0, this.getWidth(), height, false);
    }

    private void setupHeader(JTableHeader h) {
        h.setDraggedColumn(this.isSelected && this.isPressed ? HeaderComponent.getColumn() : null);
        MouseEvent e = this.isSelected && !this.isPressed ? new MouseEvent(h, 504, 1L, 0, 1, 1, 0, false) : new MouseEvent(h, 505, 1L, 0, 0, 0, 0, false);
        h.dispatchEvent(e);
    }

    private static CellRendererPane getPainter() {
        if (PAINTER == null) {
            PAINTER = new CellRendererPane();
        }
        return PAINTER;
    }

    private static JTable getTable() {
        if (REF_TABLE == null) {
            REF_TABLE = new JTable(new Object[][]{new Object[0]}, new Object[]{" "}){

                @Override
                protected JTableHeader createDefaultTableHeader() {
                    return new JTableHeader(this.columnModel){

                        @Override
                        public boolean contains(int x, int y) {
                            return x == 1 && y == 1;
                        }
                    };
                }
            };
        }
        return REF_TABLE;
    }

    private static JTableHeader getHeader() {
        return HeaderComponent.getTable().getTableHeader();
    }

    private static TableColumn getColumn() {
        return HeaderComponent.getHeader().getColumnModel().getColumn(0);
    }
}

