/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.grpc.MethodDescriptor;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientImpl;
import io.vertx.grpc.common.ServiceMethod;
import java.util.function.Function;

@VertxGen
public interface GrpcClient {
    public static GrpcClient client(Vertx vertx) {
        return GrpcClient.client(vertx, new GrpcClientOptions());
    }

    public static GrpcClient client(Vertx vertx, GrpcClientOptions options) {
        return new GrpcClientImpl(vertx, options);
    }

    public static GrpcClient client(Vertx vertx, HttpClientOptions options) {
        return GrpcClient.client(vertx, new GrpcClientOptions().setTransportOptions(options));
    }

    public Future<GrpcClientRequest<Buffer, Buffer>> request(SocketAddress var1);

    @Deprecated
    @GenIgnore(value={"permitted-type"})
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(SocketAddress var1, MethodDescriptor<Req, Resp> var2);

    @Deprecated
    @GenIgnore(value={"permitted-type"})
    default public <Req, Resp, T> Future<T> call(SocketAddress server, MethodDescriptor<Req, Resp> service, Handler<GrpcClientRequest<Req, Resp>> requestHandler, Function<GrpcClientResponse<Req, Resp>, Future<T>> resultFn) {
        return this.request(server, service).compose(req -> {
            requestHandler.handle(req);
            return req.response().compose(resultFn);
        });
    }

    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(SocketAddress var1, ServiceMethod<Resp, Req> var2);

    public Future<Void> close();
}

