/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.memory.TraceMemoryState;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.help.UnsupportedOperationException;
import org.apache.commons.lang3.tuple.Pair;

public class DirectBytesTracePcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], byte[], AddressSpace>
implements TracePcodeExecutorStatePiece<byte[], byte[]> {
    protected final PcodeTraceDataAccess data;
    protected final SemisparseByteArray unique;

    protected DirectBytesTracePcodeExecutorStatePiece(PcodeArithmetic<byte[]> arithmetic, PcodeTraceDataAccess data, SemisparseByteArray unique) {
        super(data.getLanguage(), arithmetic, arithmetic);
        this.data = data;
        this.unique = unique;
    }

    public DirectBytesTracePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        this((PcodeArithmetic<byte[]>)BytesPcodeArithmetic.forLanguage((Language)data.getLanguage()), data, new SemisparseByteArray());
    }

    @Override
    public PcodeTraceDataAccess getData() {
        return this.data;
    }

    @Override
    public DirectBytesTracePcodeExecutorStatePiece fork() {
        return new DirectBytesTracePcodeExecutorStatePiece((PcodeArithmetic<byte[]>)this.arithmetic, this.data, this.unique.fork());
    }

    public PcodeExecutorStatePiece<byte[], Pair<byte[], TraceMemoryState>> withMemoryState() {
        return new PairedPcodeExecutorStatePiece((PcodeExecutorStatePiece)this, (PcodeExecutorStatePiece)new TraceMemoryStatePcodeExecutorStatePiece(this.data));
    }

    protected void setUnique(long offset, int size, byte[] val) {
        assert (size == val.length);
        this.unique.putData(offset, val);
    }

    protected byte[] getUnique(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        byte[] data = new byte[size];
        this.unique.getData(offset, data);
        return data;
    }

    protected AddressSpace getForSpace(AddressSpace space, boolean toWrite) {
        return space;
    }

    protected void setInSpace(AddressSpace space, long offset, int size, byte[] val) {
        assert (size == val.length);
        int wrote = this.data.putBytes(space.getAddress(offset), ByteBuffer.wrap(val));
        if (wrote != size) {
            throw new RuntimeException("Could not write full value to trace");
        }
    }

    protected byte[] getFromSpace(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        int read = this.data.getBytes(space.getAddress(offset), buf);
        if (read != size) {
            throw new RuntimeException("Could not read full value from trace");
        }
        return buf.array();
    }

    protected Map<Register, byte[]> getRegisterValuesFromSpace(AddressSpace s, List<Register> registers) {
        return Map.of();
    }

    public Map<Register, byte[]> getRegisterValues() {
        return Map.of();
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDown(PcodeTraceDataAccess into) {
    }

    public void clear() {
        this.unique.clear();
    }
}

