/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.model.ProjectData;
import ghidra.framework.protocol.ghidra.DefaultGhidraProtocolHandler;
import ghidra.framework.protocol.ghidra.DefaultLocalGhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraProtocolHandler;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.framework.protocol.ghidra.TransientProjectData;
import ghidra.framework.protocol.ghidra.TransientProjectManager;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public class GhidraURLConnection
extends URLConnection {
    public static final String GHIDRA_WRAPPED_CONTENT = "GhidraWrappedContent";
    public static final String REPOSITORY_SERVER_CONTENT = "RepositoryServer";
    private StatusCode statusCode = null;
    private GhidraProtocolConnector protocolConnector;
    private DefaultProjectData projectData;
    private Object refObject;
    private boolean readOnly = true;

    public GhidraURLConnection(URL ghidraUrl) throws MalformedURLException {
        this(ghidraUrl, new DefaultGhidraProtocolHandler());
    }

    public GhidraURLConnection(URL url, GhidraProtocolHandler protocolHandler) throws MalformedURLException {
        super(url);
        if (url.getUserInfo() != null) {
            throw new MalformedURLException("User info not supported by Ghidra URLs");
        }
        if (protocolHandler == null) {
            throw new IllegalArgumentException("missing required protocol handler");
        }
        this.protocolConnector = protocolHandler.getConnector(url);
    }

    public boolean isReadOnly() {
        if (!this.connected) {
            return this.readOnly;
        }
        try {
            return this.protocolConnector.isReadOnly();
        }
        catch (NotConnectedException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public void setReadOnly(boolean state) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (GhidraURL.isLocalProjectURL(this.url) && !state) {
            throw new UnsupportedOperationException("write access to local projects not supported");
        }
        this.readOnly = state;
    }

    public String getRepositoryName() {
        return this.protocolConnector.getRepositoryName();
    }

    public String getFolderPath() {
        return this.protocolConnector.getFolderPath();
    }

    public String getFolderItemName() {
        return this.protocolConnector.getFolderItemName();
    }

    public StatusCode getStatusCode() throws IOException {
        if (this.statusCode != null) {
            return this.statusCode;
        }
        this.getContent();
        return this.statusCode;
    }

    @Override
    public String getContentType() {
        if (!this.connected || this.refObject == null) {
            return null;
        }
        if (this.refObject instanceof RepositoryServerAdapter) {
            return REPOSITORY_SERVER_CONTENT;
        }
        if (this.refObject instanceof GhidraURLWrappedContent) {
            return GHIDRA_WRAPPED_CONTENT;
        }
        return "Unknown";
    }

    @Override
    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.refObject;
    }

    public ProjectData getProjectData() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.projectData instanceof TransientProjectData) {
            ((TransientProjectData)this.projectData).incrementInstanceUseCount();
        }
        return this.projectData;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.protocolConnector instanceof DefaultLocalGhidraProtocolConnector) {
            DefaultLocalGhidraProtocolConnector localConnector = (DefaultLocalGhidraProtocolConnector)this.protocolConnector;
            this.projectData = localConnector.getLocalProjectData(this.readOnly);
            this.statusCode = localConnector.getStatusCode();
            this.connected = true;
            if (this.statusCode == StatusCode.OK) {
                this.refObject = new GhidraURLWrappedContent(this);
            }
            return;
        }
        String repoName = this.protocolConnector.getRepositoryName();
        if (repoName == null) {
            this.statusCode = this.protocolConnector.connect(this.readOnly);
            this.connected = true;
            if (this.statusCode == StatusCode.OK) {
                this.refObject = this.protocolConnector.getRepositoryServerAdapter();
                if (this.refObject == null) {
                    throw new AssertException("expected RepositoryServerAdapter content");
                }
            }
            return;
        }
        TransientProjectManager transientProjectManager = TransientProjectManager.getTransientProjectManager();
        TransientProjectData transientProjectData = transientProjectManager.getTransientProject(this.protocolConnector, this.readOnly);
        this.connected = true;
        this.statusCode = this.protocolConnector.getStatusCode();
        if (this.statusCode != StatusCode.OK) {
            return;
        }
        this.projectData = transientProjectData;
        this.refObject = new GhidraURLWrappedContent(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public static enum StatusCode {
        OK(20, "OK"),
        UNAUTHORIZED(401, "Unauthorized"),
        NOT_FOUND(404, "Not Found"),
        LOCKED(423, "Locked Project"),
        UNAVAILABLE(503, "Unavailable");

        private int code;
        private String description;

        private StatusCode(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

