/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.constraint;

import generic.constraint.ConstraintData;
import ghidra.program.model.listing.Program;
import ghidra.util.constraint.ProgramConstraint;
import java.util.Objects;
import java.util.StringTokenizer;

public class LanguageConstraint
extends ProgramConstraint {
    private String languageID;

    public LanguageConstraint() {
        super("language");
    }

    public boolean isSatisfied(Program program) {
        StringTokenizer tokA = new StringTokenizer(this.languageID, ":");
        StringTokenizer tokB = new StringTokenizer(program.getLanguageID().getIdAsString(), ":");
        while (tokA.hasMoreTokens() || tokB.hasMoreTokens()) {
            if (!tokA.hasMoreTokens() || !tokB.hasMoreTokens()) {
                return false;
            }
            String nextTokenA = tokA.nextToken();
            String nextTokenB = tokB.nextToken();
            if (nextTokenA.equals("*") || nextTokenA.equals(nextTokenB)) continue;
            return false;
        }
        return true;
    }

    public void loadConstraintData(ConstraintData data) {
        this.languageID = data.getString("id");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LanguageConstraint)) {
            return false;
        }
        return ((LanguageConstraint)((Object)obj)).languageID.equals(this.languageID);
    }

    public int hashCode() {
        return Objects.hash(this.languageID);
    }

    public String getDescription() {
        return "languageID = " + this.languageID;
    }
}

