/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.ConsumeAs;
import ghidra.program.model.lang.protorules.ConsumeExtra;
import ghidra.program.model.lang.protorules.ConvertToPointer;
import ghidra.program.model.lang.protorules.ExtraStack;
import ghidra.program.model.lang.protorules.GotoStack;
import ghidra.program.model.lang.protorules.HiddenReturnAssign;
import ghidra.program.model.lang.protorules.MultiMemberAssign;
import ghidra.program.model.lang.protorules.MultiSlotAssign;
import ghidra.program.model.lang.protorules.MultiSlotDualAssign;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public abstract class AssignAction {
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int NO_ASSIGNMENT = 2;
    public static final int HIDDENRET_PTRPARAM = 3;
    public static final int HIDDENRET_SPECIALREG = 4;
    public static final int HIDDENRET_SPECIALREG_VOID = 5;
    protected ParamListStandard resource;

    public AssignAction(ParamListStandard res) {
        this.resource = res;
    }

    public abstract AssignAction clone(ParamListStandard var1) throws InvalidInputException;

    public abstract boolean isEquivalent(AssignAction var1);

    public abstract int assignAddress(DataType var1, PrototypePieces var2, int var3, DataTypeManager var4, int[] var5, ParameterPieces var6);

    public abstract void encode(Encoder var1) throws IOException;

    public abstract void restoreXml(XmlPullParser var1) throws XmlParseException;

    public static AssignAction restoreActionXml(XmlPullParser parser, ParamListStandard res) throws XmlParseException {
        AssignAction action;
        XmlElement elemId = parser.peek();
        String nm = elemId.getName();
        if (nm.equals(ElementId.ELEM_GOTO_STACK.name())) {
            action = new GotoStack(res, 0);
        } else if (nm.equals(ElementId.ELEM_JOIN.name())) {
            action = new MultiSlotAssign(res);
        } else if (nm.equals(ElementId.ELEM_CONSUME.name())) {
            action = new ConsumeAs(StorageClass.GENERAL, res);
        } else if (nm.equals(ElementId.ELEM_CONVERT_TO_PTR.name())) {
            action = new ConvertToPointer(res);
        } else if (nm.equals(ElementId.ELEM_HIDDEN_RETURN.name())) {
            action = new HiddenReturnAssign(res, 4);
        } else if (nm.equals(ElementId.ELEM_JOIN_PER_PRIMITIVE.name())) {
            boolean consumeMostSig = res.getEntry(0).isBigEndian();
            action = new MultiMemberAssign(StorageClass.GENERAL, false, consumeMostSig, res);
        } else if (nm.equals(ElementId.ELEM_JOIN_DUAL_CLASS.name())) {
            action = new MultiSlotDualAssign(res);
        } else {
            throw new XmlParseException("Unknown model rule action: " + nm);
        }
        ((AssignAction)action).restoreXml(parser);
        return action;
    }

    public static AssignAction restoreSideeffectXml(XmlPullParser parser, ParamListStandard res) throws XmlParseException {
        AssignAction action;
        XmlElement elemId = parser.peek();
        String nm = elemId.getName();
        if (nm.equals(ElementId.ELEM_CONSUME_EXTRA.name())) {
            action = new ConsumeExtra(res);
        } else if (nm.equals(ElementId.ELEM_EXTRA_STACK.name())) {
            action = new ExtraStack(res, 0);
        } else {
            throw new XmlParseException("Unknown model rule sideeffect: " + nm);
        }
        ((AssignAction)action).restoreXml(parser);
        return action;
    }
}

