/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableStorageManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.Lock;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VariableSymbolDB
extends SymbolDB {
    private VariableStorage variableStorage;
    private VariableStorageManagerDB variableMgr;
    private SymbolType type;

    public VariableSymbolDB(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, SymbolType type, VariableStorageManagerDB variableMgr, Address address, DBRecord record) {
        super(symbolMgr, cache, address, record);
        this.type = type;
        this.variableMgr = variableMgr;
    }

    @Override
    public void setInvalid() {
        super.setInvalid();
        this.variableStorage = null;
    }

    public VariableStorage getVariableStorage() {
        this.lock.acquire();
        try {
            if (!this.checkIsValid() || this.variableStorage != null) {
                VariableStorage variableStorage = this.variableStorage;
                return variableStorage;
            }
            if (this.address instanceof OldGenericNamespaceAddress) {
                try {
                    this.variableStorage = new VariableStorage((ProgramArchitecture)this.symbolMgr.getProgram(), ((OldGenericNamespaceAddress)this.address).getGlobalAddress(), this.getDataType().getLength());
                }
                catch (InvalidInputException e) {
                    this.variableStorage = VariableStorage.BAD_STORAGE;
                }
            } else {
                this.variableStorage = this.variableMgr.getVariableStorage(this.address);
                if (this.variableStorage == null) {
                    this.variableStorage = this.type != SymbolType.PARAMETER ? VariableStorage.BAD_STORAGE : VariableStorage.UNASSIGNED_STORAGE;
                }
            }
        }
        catch (IOException e) {
            this.symbolMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return this.variableStorage;
    }

    @Override
    public SymbolType getSymbolType() {
        return this.type;
    }

    @Override
    protected boolean refresh(DBRecord rec) {
        boolean isValid = super.refresh(rec);
        this.variableStorage = null;
        return isValid;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public boolean delete() {
        this.lock.acquire();
        try {
            if (this.checkIsValid()) {
                FunctionDB fun = this.getFunction();
                if (fun != null) {
                    fun.doDeleteVariable(this);
                }
                super.delete();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object getObject() {
        FunctionDB func = this.getFunction();
        if (func != null) {
            return func.getVariable(this);
        }
        return null;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public boolean isExternal() {
        Symbol parentSymbol = this.getParentSymbol();
        return parentSymbol != null ? parentSymbol.isExternal() : false;
    }

    public FunctionDB getFunction() {
        return (FunctionDB)this.symbolMgr.getFunctionManager().getFunction(this.getParentNamespace().getID());
    }

    @Override
    public ProgramLocation getProgramLocation() {
        Variable var = (Variable)this.getObject();
        if (var != null) {
            return new VariableNameFieldLocation(var.getProgram(), var, 0);
        }
        return null;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return this.getFunction() == parent;
    }

    private String getParamName() {
        return SymbolUtilities.getDefaultParamName(this.getOrdinal());
    }

    @Override
    protected String doGetName() {
        if (!this.checkIsValid()) {
            return "[Invalid VariableSymbol - Deleted!]";
        }
        if (this.type == SymbolType.PARAMETER) {
            if (this.getSource() == SourceType.DEFAULT) {
                return this.getParamName();
            }
            String storedName = super.doGetName();
            if (SymbolUtilities.isDefaultParameterName(storedName)) {
                return this.getParamName();
            }
            return storedName;
        }
        VariableStorage storage = this.getVariableStorage();
        if (storage == null || storage.isBadStorage()) {
            return "local__!BAD!";
        }
        if (this.getSource() == SourceType.DEFAULT) {
            return SymbolUtilities.getDefaultLocalName(this.getProgram(), storage, this.getFirstUseOffset());
        }
        return super.doGetName();
    }

    @Override
    protected SourceType validateNameSource(String newName, SourceType source) {
        SymbolType symType;
        if (SymbolUtilities.isDefaultParameterName(newName)) {
            source = SourceType.DEFAULT;
        }
        if ((symType = this.getSymbolType()) == SymbolType.PARAMETER && SymbolUtilities.isDefaultParameterName(newName)) {
            source = SourceType.DEFAULT;
        } else if (symType == SymbolType.LOCAL_VAR && SymbolUtilities.isDefaultLocalName(this.getProgram(), newName, this.getVariableStorage())) {
            return SourceType.DEFAULT;
        }
        return source;
    }

    public DataType getDataType() {
        DataType dt = this.symbolMgr.getDataType(this.getDataTypeId());
        if (dt == null) {
            VariableStorage storage = this.getVariableStorage();
            dt = storage == null ? DataType.DEFAULT : (storage.isVoidStorage() ? DataType.VOID : Undefined.getUndefinedDataType(storage.size()));
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageAndDataType(VariableStorage newStorage, DataType dt) {
        Lock myLock = this.symbolMgr.getLock();
        myLock.acquire();
        try {
            this.checkDeleted();
            long dataTypeID = this.symbolMgr.getProgram().getDataTypeManager().getResolvedID(dt);
            this.variableStorage = newStorage;
            Address newAddr = this.variableMgr.getVariableStorageAddress(newStorage, true);
            this.setAddress(newAddr);
            if (dataTypeID != this.getDataTypeId()) {
                this.setDataTypeId(dataTypeID);
            } else {
                this.symbolMgr.symbolDataChanged(this);
            }
        }
        catch (IOException e) {
            this.symbolMgr.dbError(e);
        }
        finally {
            myLock.release();
        }
    }

    public int getFirstUseOffset() {
        return this.type == SymbolType.PARAMETER ? 0 : this.getVariableOffset();
    }

    public void setFirstUseOffset(int firstUseOffset) {
        if (this.type == SymbolType.LOCAL_VAR) {
            this.setVariableOffset(firstUseOffset);
        }
    }

    public int getOrdinal() {
        return this.type == SymbolType.PARAMETER ? this.getVariableOffset() : Integer.MIN_VALUE;
    }

    public void setOrdinal(int ordinal) {
        if (this.type == SymbolType.PARAMETER) {
            this.setVariableOffset(ordinal);
        }
    }

    @Override
    public int getReferenceCount() {
        return this.getReferences(null).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferences(TaskMonitor monitor) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            Reference[] referenceArray = rm.getReferencesTo((Variable)this.getObject());
            return referenceArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasMultipleReferences() {
        return this.getReferences(null).length > 1;
    }

    @Override
    public boolean hasReferences() {
        return this.getReferences(null).length != 0;
    }
}

