/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSubOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public enum IntSubOpGen implements BinOpGen<JitIntSubOp>
{
    GEN;


    private void generateMpIntLegSub(JitCodeGenerator gen, int idx, boolean takesBorrow, boolean givesBorrow, MethodVisitor mv) {
        if (takesBorrow) {
            mv.visitLdcInsn((Object)32);
            mv.visitInsn(123);
            mv.visitInsn(93);
            mv.visitInsn(88);
            mv.visitInsn(133);
            mv.visitInsn(97);
        } else {
            TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, mv);
        }
        mv.visitVarInsn(21, idx);
        TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, mv);
        mv.visitInsn(101);
        if (givesBorrow) {
            mv.visitInsn(92);
        }
        TypeConversions.generateLongToInt(JitType.LongJitType.I8, JitType.IntJitType.I4, mv);
        mv.visitVarInsn(54, idx);
    }

    private void generateMpIntSub(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int i;
        int legCount = type.legsAlloc();
        int firstIndex = gen.getAllocationModel().nextFreeLocal();
        Label start = new Label();
        Label end = new Label();
        mv.visitLabel(start);
        for (i = 0; i < legCount; ++i) {
            mv.visitLocalVariable("result" + i, Type.getDescriptor(Integer.TYPE), null, start, end, firstIndex + i);
            mv.visitVarInsn(54, firstIndex + i);
        }
        for (i = 0; i < legCount; ++i) {
            boolean isLast = i == legCount - 1;
            boolean takesCarry = i != 0;
            this.generateMpIntLegSub(gen, firstIndex + i, takesCarry, !isLast, mv);
        }
        for (i = 0; i < legCount; ++i) {
            mv.visitVarInsn(21, firstIndex + legCount - i - 1);
        }
        mv.visitLabel(end);
    }

    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntSubOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniformZExt(lType, rType, rv);
    }

    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntSubOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniformZExt(rType, lType, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(100);
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(101);
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntSub(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    Unfinished.TODO((String)"MpInt of differing sizes", (Object[])new Object[0]);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return lType;
    }
}

