/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.decode;

import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.decode.DecoderForOneStride;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContextAdapter;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;

class DecoderExecutor
extends PcodeExecutor<Object>
implements DisassemblerContextAdapter {
    private final DecoderForOneStride stride;
    final JitPassage.AddrCtx at;
    private PseudoInstruction instruction;
    private JitPassage.NopPcodeOp termNop;
    private RegisterValue flow;
    private final Map<Address, RegisterValue> futCtx = new HashMap<Address, RegisterValue>();
    final List<PcodeOp> opsForThisStep = new ArrayList<PcodeOp>();
    private final List<JitPassage.SBranch> branchesForThisStep = new ArrayList<JitPassage.SBranch>();
    private final Map<PcodeOp, JitPassage.DecodedPcodeOp> rewrites = new HashMap<PcodeOp, JitPassage.DecodedPcodeOp>();

    DecoderExecutor(DecoderForOneStride stride, JitPassage.AddrCtx at, PseudoInstruction instruction) {
        super(stride.decoder.thread.getLanguage(), null, null, null);
        this.stride = stride;
        this.at = at;
        this.setInstruction(instruction);
    }

    DecoderExecutor(DecoderForOneStride stride, JitPassage.AddrCtx at) {
        this(stride, at, null);
    }

    static JitPassage.DecodedPcodeOp rewriteOp(JitPassage.AddrCtx at, PcodeOp op) {
        if (op instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp dec = (JitPassage.DecodedPcodeOp)op;
            assert (dec.getAt().equals(at));
            return dec;
        }
        return new JitPassage.DecodedPcodeOp(at, op);
    }

    JitPassage.DecodedPcodeOp rewrite(PcodeOp op) {
        return this.rewrites.computeIfAbsent(op, o -> DecoderExecutor.rewriteOp(this.at, o));
    }

    void setInstruction(PseudoInstruction instruction) {
        this.instruction = instruction;
        if (this.at.rvCtx == null || instruction == null || instruction instanceof JitPassage.DecodeErrorInstruction) {
            this.flow = this.at.rvCtx;
        } else {
            Register contextreg = this.stride.decoder.contextreg;
            ProgramContext defaultContext = this.stride.decoder.defaultContext;
            this.flow = new RegisterValue(contextreg, BigInteger.ZERO).combineValues(defaultContext.getDefaultValue(contextreg, this.at.address)).combineValues(defaultContext.getFlowValue(this.at.rvCtx));
            this.processContextChanges();
        }
    }

    PseudoInstruction decodeInstruction() {
        PseudoInstruction instruction = this.stride.decoder.decodeInstruction(this.at.address, this.at.rvCtx);
        this.setInstruction(instruction);
        return instruction;
    }

    private void processContextChanges() {
        try {
            SleighParserContext parserCtx = (SleighParserContext)this.instruction.getParserContext();
            parserCtx.applyCommits((ProcessorContext)this);
        }
        catch (MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void execute(PcodeProgram program) {
        this.execute(program, this.stride.passage.library());
    }

    @Override
    public void finish(PcodeFrame frame, PcodeUseropLibrary<Object> library) {
        super.finish(frame, library);
        if (this.termNop != null) {
            this.opsForThisStep.add(this.termNop);
        }
    }

    @Override
    public void stepOp(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<Object> library) {
        op = this.rewrite(op);
        switch (op.getOpcode()) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.opsForThisStep.add(op);
                super.stepOp(op, frame, library);
                break;
            }
            default: {
                this.opsForThisStep.add(op);
            }
        }
    }

    @Override
    public void executeConditionalBranch(PcodeOp op, PcodeFrame frame) {
        this.doExecuteBranch(op, frame);
    }

    @Override
    protected void branchToOffset(PcodeOp op, long offset, PcodeFrame frame) {
    }

    @Override
    protected void branchToOffset(PcodeOp op, Object offset, PcodeFrame frame) {
        throw new AssertionError();
    }

    @Override
    protected void branchToAddress(PcodeOp op, Address target) {
        this.branchesForThisStep.add(new JitPassage.SExtBranch(op, this.takeTargetContext(target)));
    }

    @Override
    protected void branchInternal(PcodeOp op, PcodeFrame frame, int relative) {
        int tgtSeq = op.getSeqnum().getTime() + relative;
        if (tgtSeq == frame.getCode().size()) {
            if (this.termNop == null) {
                this.termNop = new JitPassage.NopPcodeOp(this.at, tgtSeq);
            }
            this.branchesForThisStep.add(new JitPassage.SIntBranch(op, this.termNop, false));
        } else {
            PcodeOp to = frame.getCode().get(op.getSeqnum().getTime() + relative);
            this.branchesForThisStep.add(new JitPassage.SIntBranch(op, this.rewrite(to), false));
        }
    }

    @Override
    protected void doExecuteIndirectBranch(PcodeOp op, PcodeFrame frame) {
        this.branchesForThisStep.add(new JitPassage.SIndBranch(op, this.flow));
    }

    @Override
    protected void badOp(PcodeOp op) {
        Object message;
        PseudoInstruction pseudoInstruction = this.instruction;
        if (pseudoInstruction instanceof JitPassage.DecodeErrorInstruction) {
            JitPassage.DecodeErrorInstruction err = (JitPassage.DecodeErrorInstruction)pseudoInstruction;
            message = err.getMessage();
        } else {
            message = "Encountered an unimplemented instruction at " + String.valueOf(this.at) + " (" + String.valueOf(this.instruction) + ")";
        }
        this.branchesForThisStep.add(new JitPassage.ErrBranch(op, (String)message));
    }

    @Override
    protected void onMissingUseropDef(PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<Object> library) {
        this.branchesForThisStep.add(new JitPassage.ErrBranch(op, "Sleigh userop '%s' is not in the library".formatted(opName)));
    }

    public void setFutureRegisterValue(Address address, RegisterValue value) {
        if (!value.getRegister().isProcessorContext()) {
            return;
        }
        this.futCtx.compute(address, (a, v) -> v == null ? value : v.combineValues(value));
    }

    public JitPassage.AddrCtx takeTargetContext(Address target) {
        if (!this.futCtx.containsKey(target)) {
            return new JitPassage.AddrCtx(this.flow, target);
        }
        return new JitPassage.AddrCtx(this.flow.combineValues(this.futCtx.get(target)), target);
    }

    public JitPassage.Reachability checkFallthroughAndAccumulate(PcodeProgram from) {
        if (this.instruction instanceof JitPassage.DecodeErrorInstruction) {
            this.stride.opsForStride.addAll(this.opsForThisStep);
            block11: for (JitPassage.Branch branch : this.branchesForThisStep) {
                JitPassage.Branch branch2;
                Objects.requireNonNull(branch);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.ErrBranch.class}, (Object)branch2, n)) {
                    case 0: {
                        JitPassage.ErrBranch eb = (JitPassage.ErrBranch)branch2;
                        this.stride.passage.otherBranches.put(eb.from(), eb);
                        continue block11;
                    }
                }
                throw new AssertionError();
            }
            return null;
        }
        if (this.opsForThisStep.isEmpty()) {
            return JitPassage.Reachability.WITHOUT_CTXMOD;
        }
        JitPassage.ExitPcodeOp probeOp = JitPassage.ExitPcodeOp.exit(JitPassage.AddrCtx.NOWHERE);
        this.opsForThisStep.add(probeOp);
        JitPassage.SExtBranch sExtBranch = new JitPassage.SExtBranch(probeOp, JitPassage.AddrCtx.NOWHERE);
        this.branchesForThisStep.add(sExtBranch);
        PcodeProgram program = new PcodeProgram(from, this.opsForThisStep);
        JitControlFlowModel.BlockSplitter splitter = new JitControlFlowModel.BlockSplitter(this, program){

            @Override
            protected JitPassage.IntBranch newFallthroughIntBranch(PcodeOp from, PcodeOp to) {
                return new JitPassage.SIntBranch(from, to, true);
            }
        };
        splitter.addBranches(this.branchesForThisStep);
        SequencedMap<PcodeOp, JitControlFlowModel.JitBlock> blocks = splitter.splitBlocks();
        JitControlFlowModel.JitBlock entry = blocks.firstEntry().getValue();
        JitControlFlowModel.JitBlock exit = blocks.lastEntry().getValue();
        HashMap<JitControlFlowModel.JitBlock, JitPassage.Reachability> reachable = new HashMap<JitControlFlowModel.JitBlock, JitPassage.Reachability>();
        this.collectReachable(reachable, entry, JitPassage.Reachability.WITHOUT_CTXMOD);
        for (JitControlFlowModel.JitBlock block : blocks.values()) {
            JitPassage.Branch branch;
            int n;
            JitPassage.Reachability reach = (JitPassage.Reachability)((Object)reachable.get(block));
            if (reach == null) continue;
            for (PcodeOp pcodeOp : block.getCode()) {
                if (pcodeOp == probeOp) continue;
                this.stride.opsForStride.add(pcodeOp);
            }
            block14: for (JitPassage.IntBranch intBranch : block.branchesFrom()) {
                if (intBranch.isFall()) continue;
                Objects.requireNonNull(intBranch);
                n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.SIntBranch.class}, (Object)branch, n)) {
                    case 0: {
                        JitPassage.SIntBranch ib = (JitPassage.SIntBranch)branch;
                        this.stride.passage.internalBranches.put(ib.from(), ib.withReach(reach));
                        continue block14;
                    }
                }
                throw new AssertionError();
            }
            block15: for (JitPassage.Branch branch2 : block.branchesOut()) {
                if (branch2 == sExtBranch) continue;
                Objects.requireNonNull(branch2);
                n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.SExtBranch.class, JitPassage.SIndBranch.class, JitPassage.PBranch.class}, (Object)branch, n)) {
                    case 0: {
                        JitPassage.SExtBranch eb = (JitPassage.SExtBranch)branch;
                        this.stride.passage.flowTo(eb.withReach(reach));
                        continue block15;
                    }
                    case 1: {
                        JitPassage.SIndBranch ib = (JitPassage.SIndBranch)branch;
                        this.stride.passage.otherBranches.put(ib.from(), ib.withReach(reach));
                        continue block15;
                    }
                    case 2: {
                        JitPassage.PBranch pb = (JitPassage.PBranch)branch;
                        this.stride.passage.otherBranches.put(pb.from(), pb);
                        continue block15;
                    }
                }
                throw new AssertionError();
            }
        }
        return (JitPassage.Reachability)((Object)reachable.get(exit));
    }

    private boolean blockModifiesContext(JitControlFlowModel.JitBlock block) {
        for (PcodeOp op : block.getCode()) {
            PcodeUseropLibrary.PcodeUseropDefinition<Object> userop;
            String name;
            if (op.getOpcode() != 9 || (name = block.getUseropName(this.getCallotherOpNumber(op))) == null || (userop = this.stride.passage.library().getUserops().get(name)) == null || !userop.modifiesContext()) continue;
            return true;
        }
        return false;
    }

    private void collectReachable(Map<JitControlFlowModel.JitBlock, JitPassage.Reachability> into, JitControlFlowModel.JitBlock cur, JitPassage.Reachability how) {
        JitPassage.Reachability curHow = into.get(cur);
        how = this.blockModifiesContext(cur) ? JitPassage.Reachability.WITH_CTXMOD : how.combine(curHow);
        if (how == curHow) {
            return;
        }
        into.put(cur, how);
        for (JitControlFlowModel.BlockFlow flow : cur.flowsFrom().values()) {
            this.collectReachable(into, flow.to(), how);
        }
    }

    Address getAdvancedAddress() {
        if (this.instruction != null) {
            return this.instruction.getMaxAddress().next();
        }
        Msg.warn((Object)this, (Object)"An inject may have forgotten control flow.");
        return this.at.address;
    }

    void addInstruction(PseudoInstruction instruction) {
        this.stride.instructions.add((Instruction)instruction);
    }
}

