/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import ghidra.program.database.ProgramBuilder;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.ArrayList;
import java.util.List;

public class ToyProgramBuilder
extends ProgramBuilder {
    private static final String TOY_LANGUAGE_ID_BE = "Toy:BE:32:builder";
    private static final String TOY_LANGUAGE_ID_LE = "Toy:LE:32:builder";
    private static final String TOY_LANGUAGE_ID_BE_ALIGN2 = "Toy:BE:32:builder.align2";
    private static final String TOY_LANGUAGE_ID_LE_ALIGN2 = "Toy:LE:32:builder.align2";
    private AddressFactory addrFactory;
    private AddressSpace defaultSpace;
    private List<Address> definedInstrAddresses;

    public ToyProgramBuilder(String name, String languageName, Object consumer) throws Exception {
        super(name, ToyProgramBuilder.checkLanguageName(languageName), consumer);
        ProgramDB program = this.getProgram();
        this.addrFactory = program.getAddressFactory();
        this.defaultSpace = this.addrFactory.getDefaultAddressSpace();
        this.definedInstrAddresses = new ArrayList<Address>();
    }

    public ToyProgramBuilder(String name, boolean bigEndian) throws Exception {
        this(name, bigEndian, false, null);
    }

    public ToyProgramBuilder(String name, boolean bigEndian, Object consumer) throws Exception {
        this(name, bigEndian, false, consumer);
    }

    public ToyProgramBuilder(String name, boolean bigEndian, boolean wordAligned, Object consumer) throws Exception {
        super(name, ToyProgramBuilder.getToyLanguageId(bigEndian, wordAligned), consumer);
        ProgramDB program = this.getProgram();
        this.addrFactory = program.getAddressFactory();
        this.defaultSpace = this.addrFactory.getDefaultAddressSpace();
        this.definedInstrAddresses = new ArrayList<Address>();
    }

    private static String getToyLanguageId(boolean bigEndian, boolean wordAligned) {
        if (wordAligned) {
            return bigEndian ? TOY_LANGUAGE_ID_BE_ALIGN2 : TOY_LANGUAGE_ID_LE_ALIGN2;
        }
        return bigEndian ? TOY_LANGUAGE_ID_BE : TOY_LANGUAGE_ID_LE;
    }

    private static String checkLanguageName(String languageName) {
        if (!languageName.startsWith("Toy:")) {
            throw new IllegalArgumentException("Toy language required");
        }
        return languageName;
    }

    public Address getAddress(long offset) {
        return this.defaultSpace.getAddress(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstructionBytes(Address start, byte ... instrBytes) throws MemoryAccessException {
        ProgramDB program = this.getProgram();
        int txId = program.startTransaction("Add Instruction Bytes");
        try {
            for (int i = 0; i < instrBytes.length; ++i) {
                program.getMemory().setByte(start.add((long)i), instrBytes[i]);
            }
            this.definedInstrAddresses.add(start);
        }
        finally {
            program.endTransaction(txId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstructionWords(Address start, short ... instrWords) throws MemoryAccessException {
        ProgramDB program = this.getProgram();
        int txId = program.startTransaction("Add Instruction Bytes");
        try {
            for (int i = 0; i < instrWords.length; ++i) {
                program.getMemory().setShort(start.add((long)(i * 2)), instrWords[i]);
            }
            this.definedInstrAddresses.add(start);
        }
        finally {
            program.endTransaction(txId, true);
        }
    }

    private short getByteRelativeOffset(Address address, Address dest) {
        if (!address.getAddressSpace().equals((Object)dest.getAddressSpace())) {
            throw new IllegalArgumentException("Instruction addr and targetAddr must be in same address space");
        }
        int relDest = (int)dest.subtract(address);
        if (relDest > 127 || relDest < -128) {
            throw new IllegalArgumentException("targetAddr is out of range for instruction: " + relDest);
        }
        return (short)(relDest & 0xFF);
    }

    private short getShortRelativeOffset(Address address, Address dest) {
        if (!address.getAddressSpace().equals((Object)dest.getAddressSpace())) {
            throw new IllegalArgumentException("Instruction addr and targetAddr must be in same address space");
        }
        int relDest = (int)dest.subtract(address);
        if (relDest > 127 || relDest < -128) {
            throw new IllegalArgumentException("targetAddr is out of range for instruction: " + relDest);
        }
        return (short)(relDest & 0xFFFF);
    }

    private String toHex(long value) {
        return Long.toHexString(value);
    }

    public List<Address> getDefinedInstructionAddress() {
        return this.definedInstrAddresses;
    }

    public void resetDefinedInstructionAddresses() {
        this.definedInstrAddresses.clear();
    }

    public void addBytesNOP(long offset, int length) throws MemoryAccessException {
        this.addBytesNOP(this.toHex(offset), length);
    }

    public void addBytesNOP(String addr, int length) throws MemoryAccessException {
        if (length == 1) {
            this.addInstructionBytes(this.addr(addr), -9);
        } else if (length < 18) {
            byte[] bytes = new byte[length];
            bytes[0] = -39;
            bytes[1] = (byte)((length -= 2) | 0x30);
            for (int i = 0; i < length; ++i) {
                bytes[2 + i] = 0;
            }
            this.addInstructionBytes(this.addr(addr), bytes);
        } else {
            throw new IllegalArgumentException("Unsupported NOP length: " + length);
        }
    }

    public void addBytesFallthrough(long offset) throws MemoryAccessException {
        this.addBytesFallthrough(this.toHex(offset));
    }

    public void addBytesFallthrough(String addr) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), -12032);
    }

    public void addBytesStore(long offset, int srcRegIndex, int destRegIndex) throws MemoryAccessException {
        this.addBytesStore(this.toHex(offset), srcRegIndex, destRegIndex);
    }

    public void addBytesStore(String addr, int srcRegIndex, int destRegIndex) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), (short)(0xD700 | srcRegIndex & 0xF | (destRegIndex & 0xF) << 4));
    }

    public void addBytesLoad(long offset, int srcRegIndex, int destRegIndex) throws MemoryAccessException {
        this.addBytesLoad(this.toHex(offset), srcRegIndex, destRegIndex);
    }

    public void addBytesLoad(String addr, int srcRegIndex, int destRegIndex) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), (short)(0xD600 | srcRegIndex & 0xF | (destRegIndex & 0xF) << 4));
    }

    public void addBytesMoveImmediate(long offset, short imm) throws MemoryAccessException {
        this.addBytesMoveImmediate(this.toHex(offset), imm);
    }

    public void addBytesMoveImmediate(String addr, short imm) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), (short)((imm & 0x700) << 4 | imm & 0xFF));
    }

    public void addBytesFallthroughSetNoFlowContext(long offset, int ctxVal) throws MemoryAccessException {
        this.addBytesFallthroughSetNoFlowContext(this.toHex(offset), ctxVal);
    }

    public void addBytesFallthroughSetNoFlowContext(String addr, int ctxVal) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), (short)(0xD900 | ctxVal & 0xF | 0x10));
    }

    public void addBytesFallthroughSetNoFlowContext(long offset, int ctxVal, long target) throws MemoryAccessException {
        this.addBytesFallthroughSetNoFlowContext(this.toHex(offset), ctxVal, this.toHex(target));
    }

    public void addBytesFallthroughSetNoFlowContext(String addr, int ctxVal, String targetAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address target = this.addr(targetAddr);
        short relTarget = this.getByteRelativeOffset(address, target);
        this.addInstructionWords(address, (short)(0xD900 | ctxVal & 0xF | 0x20), relTarget);
    }

    public void addBytesFallthroughSetFlowContext(long offset, int ctxVal) throws MemoryAccessException {
        this.addBytesFallthroughSetFlowContext(this.toHex(offset), ctxVal);
    }

    public void addBytesFallthroughSetFlowContext(String addr, int ctxVal) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), (short)(0xD900 | ctxVal & 0xF));
    }

    public void addBytesCall(long offset, long dest) throws MemoryAccessException {
        this.addBytesCall(this.toHex(offset), this.toHex(dest));
    }

    public void addBytesCall(String offset, long dest) throws MemoryAccessException {
        this.addBytesCall(offset, this.toHex(dest));
    }

    public void addBytesCall(String addr, String destAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address dest = this.addr(destAddr);
        short relDest = this.getShortRelativeOffset(address, dest);
        this.addInstructionWords(address, (short)(0xF800 | relDest & 0x7F));
    }

    public void addBytesCallWithDelaySlot(long offset, long dest) throws MemoryAccessException {
        this.addBytesCallWithDelaySlot(this.toHex(offset), this.toHex(dest));
    }

    public void addBytesCallWithDelaySlot(String addr, String destAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address dest = this.addr(destAddr);
        short relDest = this.getByteRelativeOffset(address, dest);
        this.addInstructionWords(address, (short)(0xF500 | relDest));
        this.addBytesFallthrough(address.getOffset() + 2L);
    }

    public void addBytesReturn(long offset) throws MemoryAccessException {
        this.addBytesReturn(this.toHex(offset));
    }

    public void addBytesReturn(String addr) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), -3072);
    }

    public void addBytesBranch(long offset, long dest) throws MemoryAccessException {
        this.addBytesBranch(this.toHex(offset), this.toHex(dest));
    }

    public void addBytesBranch(String addr, String destAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address dest = this.addr(destAddr);
        short relDest = this.getByteRelativeOffset(address, dest);
        this.addInstructionWords(address, (short)(0xE000 | relDest << 4 | 7));
    }

    public void addBytesBranchConditional(long offset, long dest) throws MemoryAccessException {
        this.addBytesBranchConditional(this.toHex(offset), this.toHex(dest));
    }

    public void addBytesBranchConditional(String addr, String destAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address dest = this.addr(destAddr);
        short relDest = this.getByteRelativeOffset(address, dest);
        this.addInstructionWords(address, (short)(0xE000 | relDest << 4));
    }

    public void addBytesSkipConditional(long offset) throws MemoryAccessException {
        this.addBytesSkipConditional(this.toHex(offset));
    }

    public void addBytesSkipConditional(String addr) throws MemoryAccessException {
        Address address = this.addr(addr);
        this.addInstructionWords(address, Short.MIN_VALUE);
    }

    public void addBytesBranchWithDelaySlot(long offset, long dest) throws MemoryAccessException {
        this.addBytesBranchWithDelaySlot(this.toHex(offset), this.toHex(dest));
    }

    public void addBytesBranchWithDelaySlot(String addr, String destAddr) throws MemoryAccessException {
        Address address = this.addr(addr);
        Address dest = this.addr(destAddr);
        short relDest = this.getByteRelativeOffset(address, dest);
        this.addInstructionWords(address, (short)(0xE000 | relDest << 4 | 0xF));
        this.addBytesFallthrough(address.getOffset() + 2L);
    }

    public void addBytesCopInstruction(long offset) throws MemoryAccessException {
        this.addBytesCopInstruction(this.toHex(offset));
    }

    public void addBytesCopInstruction(String addr) throws MemoryAccessException {
        this.addInstructionWords(this.addr(addr), -9728);
    }

    public void addBytesBadInstruction(long offset) throws MemoryAccessException {
        this.addBytesBadInstruction(this.toHex(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytesBadInstruction(String addr) throws MemoryAccessException {
        ProgramDB program = this.getProgram();
        int txId = program.startTransaction("Add Instruction Bytes");
        try {
            program.getMemory().setShort(this.addr(addr), (short)-4081);
        }
        finally {
            program.endTransaction(txId, true);
        }
    }

    public void createNOPInstruction(String address, int size) throws Exception {
        this.addBytesNOP(address, size);
        this.disassemble(address, 1);
    }

    public void createCallInstruction(String address, String callAddress) throws Exception {
        this.addBytesCall(address, callAddress);
        this.disassemble(address, 1);
    }

    public void createReturnInstruction(String address) throws Exception {
        this.addBytesReturn(address);
        this.disassemble(address, 1);
    }

    public void createJmpInstruction(String address, String destAddress) throws Exception {
        this.addBytesBranch(address, destAddress);
        this.disassemble(address, 1);
    }

    public void createConditionalJmpInstruction(String address, String destAddress) throws Exception {
        this.addBytesBranchConditional(address, destAddress);
        this.disassemble(address, 1);
    }

    public void createJmpWithDelaySlot(String address, String destAddress) throws Exception {
        this.addBytesBranchWithDelaySlot(address, destAddress);
        this.disassemble(address, 1);
    }
}

