/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GColor;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.util.OffsetFieldLocation;
import ghidra.program.util.OffsetFieldType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;

public abstract class AbstractOffsetFieldFactory
extends FieldFactory {
    public static final GColor COLOR = new GColor("color.fg.listing.field.offset");
    private static final String SHOW_NAME = "Show Name";
    private static final String USE_HEX = "Use Hex";
    private static final boolean DEFAULT_SHOW_NAME = false;
    private static final boolean DEFAULT_USE_HEX = true;
    protected boolean showName;
    protected boolean useHex;
    protected String fieldName;
    protected String groupTitle;

    public AbstractOffsetFieldFactory(String offsetDescription) {
        super(offsetDescription + " Offset");
    }

    protected AbstractOffsetFieldFactory(String offsetDescription, String nameDescription, FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(offsetDescription + " Offset", model, hlProvider, displayOptions, fieldOptions);
        this.fieldName = offsetDescription + " Offset";
        this.groupTitle = offsetDescription + " Offset Field";
        this.initOptions(fieldOptions, offsetDescription, nameDescription);
    }

    public abstract String getOffsetValue(CodeUnit var1);

    public abstract OffsetFieldType getOffsetFieldType();

    private void initOptions(Options fieldOptions, String offsetDescription, String nameDescription) {
        HelpLocation helpLoc = new HelpLocation("CodeBrowserPlugin", offsetDescription + "_Offset_Field");
        fieldOptions.getOptions(this.groupTitle).setOptionsHelpLocation(helpLoc);
        fieldOptions.registerOption(this.getFullOptionName(SHOW_NAME), (Object)false, helpLoc, "Prepends the %s name to the %s offset in the offset field.".formatted(nameDescription.toLowerCase(), offsetDescription));
        fieldOptions.registerOption(this.getFullOptionName(USE_HEX), (Object)true, helpLoc, "Toggles displaying offsets in hexadecimal/decimal in the offset field.");
        this.showName = fieldOptions.getBoolean(this.getFullOptionName(SHOW_NAME), false);
        this.useHex = fieldOptions.getBoolean(this.getFullOptionName(USE_HEX), true);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        TextFieldElement fieldElement = new TextFieldElement(new AttributedString(this.getOffsetValue((CodeUnit)obj), (Color)COLOR, this.getMetrics()), 0, 0);
        ListingTextField listingTextField = ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)fieldElement, this.startX + varWidth, this.width, this.hlProvider);
        listingTextField.setPrimary(true);
        return listingTextField;
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionsName, Object oldValue, Object newValue) {
        if (optionsName.equals(this.getFullOptionName(SHOW_NAME))) {
            this.showName = (Boolean)newValue;
            this.model.update();
        } else if (optionsName.equals(this.getFullOptionName(USE_HEX))) {
            this.useHex = (Boolean)newValue;
            this.model.update();
        }
    }

    @Override
    public FieldLocation getFieldLocation(ListingField lf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Object obj;
        OffsetFieldLocation offsetLoc;
        if (loc instanceof OffsetFieldLocation && (offsetLoc = (OffsetFieldLocation)loc).getType().equals((Object)this.getOffsetFieldType()) && (obj = lf.getProxy().getObject()) instanceof CodeUnit && this.hasSamePath(lf, (ProgramLocation)offsetLoc)) {
            return new FieldLocation(index, fieldNum, 0, offsetLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField lf) {
        Object obj = lf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Address addr = cu.getMinAddress();
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new OffsetFieldLocation(cu.getProgram(), addr, cpath, col, this.getOffsetFieldType());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5 || category == 6;
    }

    private String getFullOptionName(String shortName) {
        return this.groupTitle + "." + shortName;
    }
}

