/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.util.cparser.C.Declaration;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;

public class CompositeHandler {
    private Composite parent;

    public CompositeHandler(Composite parent) {
        this.parent = parent;
    }

    public Composite getComposite() {
        return this.parent;
    }

    public void add(Declaration dec) throws IllegalArgumentException {
        if (dec == null || dec.getDataType() == null) {
            return;
        }
        if (!dec.isBitField()) {
            this.parent.add(dec.getDataType(), dec.getName(), dec.getComment());
            return;
        }
        DataType dataType = dec.getDataType();
        try {
            this.parent.addBitField(dataType, dec.getBitFieldSize(), dec.getName(), dec.getComment());
        }
        catch (InvalidDataTypeException e) {
            throw new IllegalArgumentException("Invalid bitfield " + dec.getName() + " : " + dec.getBitFieldSize());
        }
    }
}

