/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jungrapht.visualization.spatial.rtree.HorizontalCenterNodeComparator;
import org.jungrapht.visualization.spatial.rtree.InnerNode;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.NodeMap;
import org.jungrapht.visualization.spatial.rtree.SplitterContext;
import org.jungrapht.visualization.spatial.rtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTree<T> {
    private static final Logger log = LoggerFactory.getLogger(RTree.class);
    private final Optional<Node<T>> root;
    private static final String marginIncrement = "   ";

    public Optional<Node<T>> getRoot() {
        return this.root;
    }

    private RTree() {
        this.root = Optional.empty();
    }

    private RTree(Node<T> node) {
        if (!node.getParent().isEmpty()) {
            throw new RuntimeException("Error creating R-Tree with root that has parent");
        }
        this.root = Optional.of(node);
    }

    public static <T> RTree<T> create() {
        return new RTree<T>();
    }

    public static <T> RTree<T> addAll(RTree<T> rtree, SplitterContext<T> splitterContext, Collection<Map.Entry<T, Rectangle2D>> entries) {
        for (Map.Entry<T, Rectangle2D> entry : entries) {
            rtree = RTree.add(rtree, splitterContext, entry);
        }
        return rtree;
    }

    public static <T> RTree<T> add(RTree<T> rtree, SplitterContext<T> splitterContext, Map.Entry<T, Rectangle2D> entry) {
        return RTree.add(rtree, splitterContext, entry.getKey(), entry.getValue());
    }

    public static <T> RTree<T> add(RTree<T> rtree, SplitterContext<T> splitterContext, T element, Rectangle2D bounds) {
        if (rtree.root.isEmpty()) {
            return new RTree<T>(LeafNode.create(element, bounds));
        }
        Node<T> node = rtree.root.get();
        if (node instanceof LeafNode) {
            LeafNode leafVertex = (LeafNode)node;
            Node<T> got = leafVertex.add(splitterContext, element, bounds);
            if (!got.getParent().isEmpty()) {
                throw new RuntimeException("return from LeafVertex add has a parent");
            }
            return new RTree<T>(got);
        }
        InnerNode innerVertex = (InnerNode)node;
        Node<T> got = innerVertex.add(splitterContext, element, bounds);
        if (got == null) {
            log.error("add did not work");
        }
        if (!got.getParent().isEmpty()) {
            throw new RuntimeException("return from InnerVertex add has a parent");
        }
        return new RTree<T>(got);
    }

    public static <T> RTree<T> bulkAdd(RTree<T> rtree, SplitterContext<T> splitterContext, Collection<Map.Entry<T, Rectangle2D>> items) {
        ArrayList<Map.Entry<T, Rectangle2D>> sortedList = new ArrayList<Map.Entry<T, Rectangle2D>>(items);
        sortedList.sort(new HorizontalCenterNodeComparator());
        for (Map.Entry entry : sortedList) {
            rtree = RTree.add(rtree, splitterContext, entry.getKey(), (Rectangle2D)entry.getValue());
        }
        return rtree;
    }

    public static <T> RTree removeForReinsert(RTree<T> rtree, Collection<Map.Entry<T, Rectangle2D>> removed) {
        if (rtree.root.isEmpty()) {
            return rtree;
        }
        Node<T> root = rtree.root.get();
        log.trace("average leaf count {}", (Object)rtree.averageLeafCount(root, new double[]{0.0}, new int[]{0}));
        List<LeafNode> leafVertices = rtree.collectLeafVertices(root, new ArrayList<LeafNode>());
        ArrayList<Map.Entry> goners = new ArrayList<Map.Entry>();
        int averageSize = (int)rtree.averageLeafCount(root, new double[]{0.0}, new int[]{0});
        for (TreeNode treeNode : leafVertices) {
            if (!(treeNode instanceof LeafNode)) continue;
            LeafNode leafVertex = (LeafNode)treeNode;
            NodeMap nodeMap = leafVertex.map;
            ArrayList entryList = new ArrayList(nodeMap.entrySet());
            entryList.sort(new DistanceComparator(leafVertex.centerOfGravity()));
            int size = entryList.size();
            if (size >= averageSize) {
                size = (int)((double)size * 0.3);
            }
            for (int i = 0; i < size; ++i) {
                Map.Entry entry = (Map.Entry)entryList.get(i);
                goners.add(entry);
            }
        }
        for (Map.Entry entry : goners) {
            rtree = RTree.remove(rtree, entry.getKey());
            log.trace("removed one, tree size now {}", (Object)rtree.count());
        }
        removed.addAll(goners);
        return rtree;
    }

    public static <T> RTree reinsert(RTree<T> rtree, SplitterContext<T> splitterContext) {
        if (rtree.root.isEmpty()) {
            return rtree;
        }
        Node<T> root = rtree.root.get();
        log.trace("average leaf count {}", (Object)rtree.averageLeafCount(root, new double[]{0.0}, new int[]{0}));
        List<LeafNode> leafVertices = rtree.collectLeafVertices(root, new ArrayList<LeafNode>());
        ArrayList<Map.Entry> goners = new ArrayList<Map.Entry>();
        int averageSize = (int)rtree.averageLeafCount(root, new double[]{0.0}, new int[]{0});
        for (TreeNode treeNode : leafVertices) {
            if (!(treeNode instanceof LeafNode)) continue;
            Rectangle2D boundsOfLeafVertex = treeNode.getBounds();
            Point2D.Double centerOfLeafVertex = new Point2D.Double(boundsOfLeafVertex.getCenterX(), boundsOfLeafVertex.getCenterY());
            LeafNode leafVertex = (LeafNode)treeNode;
            NodeMap nodeMap = leafVertex.map;
            ArrayList entryList = new ArrayList(nodeMap.entrySet());
            entryList.sort(new DistanceComparator(centerOfLeafVertex));
            int size = entryList.size();
            if (size >= averageSize) {
                size = (int)((double)size * 0.3);
            }
            for (int i = 0; i < size; ++i) {
                Map.Entry entry = (Map.Entry)entryList.get(i);
                goners.add(entry);
            }
        }
        for (Map.Entry entry : goners) {
            rtree = RTree.remove(rtree, entry.getKey());
            log.trace("removed one, tree size now {}", (Object)rtree.count());
        }
        log.trace("removed {} goners", (Object)goners.size());
        log.trace("removed goners, tree size is {}", (Object)rtree.count());
        for (Map.Entry entry : goners) {
            rtree = RTree.add(rtree, splitterContext, entry.getKey(), (Rectangle2D)entry.getValue());
        }
        log.trace("after adding back {} goners, rtree size is {}", (Object)goners.size(), (Object)rtree.count());
        return rtree;
    }

    private List<LeafNode> collectLeafVertices(TreeNode parent, List<LeafNode> leafVertices) {
        if (parent instanceof Node) {
            Node node = (Node)parent;
            if (node instanceof LeafNode) {
                leafVertices.add((LeafNode)node);
            } else {
                for (TreeNode treeNode : parent.getChildren()) {
                    this.collectLeafVertices(treeNode, leafVertices);
                }
            }
        }
        return leafVertices;
    }

    public static <T> RTree<T> remove(RTree<T> rtree, T element) {
        log.trace("want to remove {} from tree size {}", element, (Object)rtree.count());
        if (rtree.root.isEmpty()) {
            return new RTree<T>();
        }
        Node<T> rootVertex = rtree.root.get();
        Node<T> newRoot = rootVertex.remove(element);
        if (newRoot.count() == 0) {
            return RTree.create();
        }
        return rtree;
    }

    public T getPickedObject(Point2D p) {
        Node<T> root = this.root.get();
        if (root instanceof LeafNode) {
            LeafNode leafVertex = (LeafNode)root;
            return leafVertex.getPickedObject(p);
        }
        if (root instanceof InnerNode) {
            InnerNode innerVertex = (InnerNode)root;
            return innerVertex.getPickedObject(p);
        }
        return null;
    }

    public Set<Shape> getGrid() {
        HashSet<Shape> areas = new HashSet<Shape>();
        if (this.root.isPresent()) {
            Node<T> node = this.root.get();
            node.collectGrids(areas);
        }
        return areas;
    }

    public Collection<TreeNode> getContainingLeafs(Point2D p) {
        if (this.root.isPresent()) {
            Node<T> theRoot = this.root.get();
            if (theRoot instanceof LeafNode) {
                return Collections.singleton(theRoot);
            }
            if (theRoot instanceof InnerNode) {
                return ((InnerNode)theRoot).getContainingLeafs(new HashSet(), p);
            }
        }
        return Collections.emptySet();
    }

    public int count() {
        int count = 0;
        if (this.root.isPresent()) {
            Node<T> node = this.root.get();
            count += node.count();
        }
        return count;
    }

    private String asString() {
        if (this.root.isPresent()) {
            return this.root.get().asString("");
        }
        return "Empty RTree";
    }

    private static String asString(Rectangle2D r) {
        return "[" + (int)r.getX() + "," + (int)r.getY() + "," + (int)r.getWidth() + "," + (int)r.getHeight() + "]";
    }

    private double averageLeafCount(TreeNode parent, double[] average, int[] leafCount) {
        if (parent instanceof LeafNode) {
            int childSum = ((LeafNode)parent).map.size();
            average[0] = (average[0] * (double)leafCount[0] + (double)childSum) / (double)(leafCount[0] + 1);
            leafCount[0] = leafCount[0] + 1;
        } else {
            for (TreeNode treeNode : parent.getChildren()) {
                average[0] = this.averageLeafCount(treeNode, average, leafCount);
            }
        }
        return average[0];
    }

    private static <T> String asString(Collection<RTree<T>> trees) {
        StringBuilder sb = new StringBuilder();
        for (RTree<T> tree : trees) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(tree.asString());
        }
        return sb.toString();
    }

    private static <T> String asString(Map<T, Rectangle2D> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, Rectangle2D> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(RTree.asString(entry));
        }
        return sb.toString();
    }

    private static <T> String asString(Map.Entry<T, Rectangle2D> entry) {
        return entry.getKey() + "->" + RTree.asString(entry.getValue());
    }

    public String toString() {
        return this.asString();
    }

    static class DistanceComparator<T>
    implements Comparator<Map.Entry<T, Rectangle2D>> {
        Point2D center;

        public DistanceComparator(Point2D center) {
            this.center = center;
        }

        @Override
        public int compare(Map.Entry<T, Rectangle2D> o1, Map.Entry<T, Rectangle2D> o2) {
            Point2D.Double centerOfO1 = new Point2D.Double(o1.getValue().getCenterX(), o1.getValue().getCenterY());
            Point2D.Double centerOfO2 = new Point2D.Double(o2.getValue().getCenterX(), o2.getValue().getCenterY());
            return Double.compare(this.center.distanceSq(centerOfO2), this.center.distanceSq(centerOfO1));
        }
    }
}

