/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.util.job;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.util.job.AbstractGroupingFunctionGraphJob;
import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.viewer.layout.LayoutPositions;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupVertexFunctionGraphJob
extends AbstractGroupingFunctionGraphJob {
    private final Point2D groupVertexCurrentLocation;
    private boolean isRegroupOperation = false;
    private FunctionGraph functionGraph;

    public static GroupVertexFunctionGraphJob createNewGroupJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Point2D location, boolean relayoutOverride, boolean useAnimation) {
        return new GroupVertexFunctionGraphJob(controller, groupVertex, location, relayoutOverride, useAnimation, false);
    }

    public static GroupVertexFunctionGraphJob createRegroupJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Point2D location, boolean relayoutOverride, boolean useAnimation) {
        return new GroupVertexFunctionGraphJob(controller, groupVertex, location, relayoutOverride, useAnimation, true);
    }

    public static GroupVertexFunctionGraphJob createUpdateGroupJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Set<FGVertex> verticesToGroup, boolean useAnimation) {
        return new GroupVertexFunctionGraphJob(controller, groupVertex, verticesToGroup, useAnimation);
    }

    private GroupVertexFunctionGraphJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Point2D location, boolean relayoutOverride, boolean useAnimation, boolean isRegroupOperation) {
        super(controller, groupVertex, GroupVertexFunctionGraphJob.asSet(groupVertex), groupVertex.getVertices(), relayoutOverride, useAnimation);
        this.functionGraph = controller.getFunctionGraphData().getFunctionGraph();
        this.groupVertexCurrentLocation = location;
        this.isRegroupOperation = isRegroupOperation;
    }

    private GroupVertexFunctionGraphJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Set<FGVertex> verticesToGroup, boolean useAnimation) {
        super(controller, groupVertex, GroupVertexFunctionGraphJob.asSet(groupVertex), verticesToGroup, false, useAnimation);
        this.functionGraph = controller.getFunctionGraphData().getFunctionGraph();
        this.groupVertexCurrentLocation = (Point2D)this.graphLayout.apply((Object)groupVertex);
    }

    @Override
    protected void notifyGroupChange() {
        if (this.isRegroupOperation) {
            this.functionGraph.groupRestored(this.groupVertex);
        } else {
            this.functionGraph.groupAdded(this.groupVertex);
        }
    }

    @Override
    protected Map<FGVertex, Point2D> getGroupingDestinationLocations(boolean isRelayout, Point2D groupVertexDestinationLocation) {
        if (groupVertexDestinationLocation == null) {
            groupVertexDestinationLocation = this.groupVertexCurrentLocation;
        }
        HashMap<FGVertex, Point2D> locations = new HashMap<FGVertex, Point2D>();
        for (FGVertex vertex : this.verticesToBeRemoved) {
            locations.put(vertex, groupVertexDestinationLocation);
        }
        if (!isRelayout) {
            locations.put(this.groupVertex, groupVertexDestinationLocation);
        }
        return locations;
    }

    protected void initializeVertexLocations() {
        LayoutPositions<FGVertex, FGEdge> positions = this.updateDestinationLocations();
        Map destinationLocations = positions.getVertexLocations();
        this.finalEdgeArticulations = positions.getEdgeArticulations();
        Collection<FGVertex> vertices = this.getVerticesToMove();
        for (FGVertex vertex : vertices) {
            Point2D currentPoint = (Point2D)this.graphLayout.apply((Object)vertex);
            Point2D startPoint = (Point2D)currentPoint.clone();
            Point2D destinationPoint = (Point2D)((Point2D)destinationLocations.get(vertex)).clone();
            AbstractGraphTransitionJob.TransitionPoints transitionPoints = new AbstractGraphTransitionJob.TransitionPoints((AbstractGraphTransitionJob)this, startPoint, destinationPoint);
            this.vertexLocations.put(vertex, transitionPoints);
        }
        Map edgeArticulations = positions.getEdgeArticulations();
        Collection edgesToMove = this.graph.getEdges();
        for (FGEdge edge : edgesToMove) {
            List currentArticulations = edge.getArticulationPoints();
            List<Point2D> newArticulations = (List<Point2D>)edgeArticulations.get(edge);
            if (newArticulations == null) {
                newArticulations = Collections.emptyList();
            }
            List<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = this.getArticulationTransitionPoints(currentArticulations, newArticulations, destinationLocations, edge);
            this.edgeArticulationLocations.put(edge, transitionPoints);
        }
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        if (currentArticulations.size() > newArticulations.size()) {
            return this.getArticulationTransitionPointsWhenStartingWithMorePoints(currentArticulations, newArticulations, destinationLocations, edge);
        }
        return this.getArticulationTransitionPointsWhenStartingWithLessPoints(currentArticulations, newArticulations, destinationLocations, edge);
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithMorePoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        for (int i = 0; i < currentArticulations.size(); ++i) {
            Point2D startPoint = currentArticulations.get(i);
            Point2D endPoint = (Point2D)startPoint.clone();
            if (i < newArticulations.size()) {
                endPoint = newArticulations.get(i);
            } else {
                FGVertex destinationVertex = (FGVertex)edge.getEnd();
                AbstractGraphTransitionJob.TransitionPoints destionationTranstionPoint = this.getTransitionPoint(this.vertexLocations, destinationLocations, destinationVertex);
                endPoint = destionationTranstionPoint.destinationPoint;
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints((AbstractGraphTransitionJob)this, startPoint, endPoint));
        }
        return transitionPoints;
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithLessPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        ArrayList<Point2D> newStartArticulationsPoints = new ArrayList<Point2D>();
        Point2D lastValidStartPoint = (Point2D)this.graphLayout.apply((Object)((FGVertex)edge.getStart()));
        for (int i = 0; i < newArticulations.size(); ++i) {
            Point2D endPoint = newArticulations.get(i);
            Point2D startPoint = (Point2D)lastValidStartPoint.clone();
            if (i < currentArticulations.size()) {
                lastValidStartPoint = startPoint = currentArticulations.get(i);
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints((AbstractGraphTransitionJob)this, startPoint, endPoint));
            newStartArticulationsPoints.add(startPoint);
        }
        edge.setArticulationPoints(newStartArticulationsPoints);
        return transitionPoints;
    }

    private AbstractGraphTransitionJob.TransitionPoints getTransitionPoint(Map<FGVertex, AbstractGraphTransitionJob.TransitionPoints> transitionPoints, Map<FGVertex, Point2D> destinationLocations, FGVertex vertex) {
        AbstractGraphTransitionJob.TransitionPoints transtionPoint = transitionPoints.get(vertex);
        if (transtionPoint != null) {
            return transtionPoint;
        }
        return this.createTransitionPoint(destinationLocations, vertex);
    }

    private AbstractGraphTransitionJob.TransitionPoints createTransitionPoint(Map<FGVertex, Point2D> destinationLocations, FGVertex vertex) {
        Point2D currentPoint = (Point2D)this.graphLayout.apply((Object)vertex);
        Point2D startPoint = (Point2D)currentPoint.clone();
        Point2D destinationPoint = (Point2D)destinationLocations.get(vertex).clone();
        return new AbstractGraphTransitionJob.TransitionPoints((AbstractGraphTransitionJob)this, startPoint, destinationPoint);
    }
}

