/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class OatUtilities {
    public static BinaryReader getBinaryReader(Program program) {
        Symbol symbol;
        if (OatUtilities.isOAT(program) && (symbol = OatUtilities.getOatDataSymbol(program)) != null && symbol.getName().equals("oatdata")) {
            MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), symbol.getAddress());
            return new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        }
        return null;
    }

    public static boolean isOAT(Program program) {
        MemoryBlock roDataBlock;
        String executableFormat;
        if (program != null && "Executable and Linking Format (ELF)".equals(executableFormat = program.getExecutableFormat()) && (roDataBlock = program.getMemory().getBlock(".rodata")) != null) {
            SymbolTable symbolTable = program.getSymbolTable();
            Symbol oatDataSymbol = symbolTable.getPrimarySymbol(roDataBlock.getStart());
            return oatDataSymbol != null && oatDataSymbol.getName().equals("oatdata");
        }
        return false;
    }

    public static boolean isELF(Program program) {
        return "Executable and Linking Format (ELF)".equals(program.getExecutableFormat());
    }

    public static Symbol getOatDataSymbol(Program program) {
        SymbolTable symbolTable;
        Symbol oatDataSymbol;
        MemoryBlock block;
        if (OatUtilities.isELF(program) && (block = program.getMemory().getBlock(".rodata")) != null && (oatDataSymbol = (symbolTable = program.getSymbolTable()).getPrimarySymbol(block.getStart())) != null && oatDataSymbol.getName().equals("oatdata")) {
            return oatDataSymbol;
        }
        return null;
    }

    public static Symbol getOatExecSymbol(Program program) {
        SymbolTable symbolTable;
        Symbol oatExecSymbol;
        MemoryBlock block;
        if (OatUtilities.isELF(program) && (block = program.getMemory().getBlock(".text")) != null && (oatExecSymbol = (symbolTable = program.getSymbolTable()).getPrimarySymbol(block.getStart())) != null && oatExecSymbol.getName().equals("oatexec")) {
            return oatExecSymbol;
        }
        return null;
    }

    public static Symbol getOatLastWordSymbol(Program program) {
        SymbolTable symbolTable;
        List oatLastWordSymbols;
        MemoryBlock block;
        if (OatUtilities.isELF(program) && (block = program.getMemory().getBlock(".text")) != null && (oatLastWordSymbols = (symbolTable = program.getSymbolTable()).getGlobalSymbols("oatlastword")).size() == 1) {
            return (Symbol)oatLastWordSymbols.get(0);
        }
        return null;
    }

    public static List<EncodedMethod> getAllMethods(ClassDataItem classDataItem) {
        ArrayList<EncodedMethod> list = new ArrayList<EncodedMethod>();
        list.addAll(classDataItem.getDirectMethods());
        list.addAll(classDataItem.getVirtualMethods());
        return list;
    }

    public static Address adjustForThumbAsNeeded(OatHeader oatHeader, Program program, Address address, MessageLog log) {
        long displacement = address.getOffset();
        if (oatHeader.getInstructionSet() == OatInstructionSet.kThumb2 && (displacement & 1L) == 1L) {
            address = address.subtract(1L);
            Register register = program.getLanguage().getRegister("TMode");
            RegisterValue value = new RegisterValue(register, BigInteger.valueOf(1L));
            try {
                program.getProgramContext().setRegisterValue(address, address, value);
            }
            catch (ContextChangeException e) {
                log.appendException((Throwable)e);
            }
        }
        return address;
    }
}

