/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.analyzers;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.data.CreateStringCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;

public abstract class FileFormatAnalyzer
implements Analyzer {
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public AnalysisPriority getPriority() {
        return AnalysisPriority.FORMAT_ANALYSIS;
    }

    public final boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            return this.analyze(program, set, monitor, log);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return false;
        }
    }

    public void analysisEnded(Program program) {
    }

    public void registerOptions(Options options, Program program) {
    }

    public void optionsChanged(Options options, Program program) {
    }

    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    public boolean supportsOneTimeAnalysis() {
        return false;
    }

    public abstract boolean analyze(Program var1, AddressSetView var2, TaskMonitor var3, MessageLog var4) throws Exception;

    protected void changeDataSettings(Program program, TaskMonitor monitor) {
        monitor.setMessage("Changing data settings...");
        Address address = program.getMinAddress();
        while (!monitor.isCancelled()) {
            Data data = this.getDataAt(program, address);
            if (data == null) {
                data = this.getDataAfter(program, address);
            }
            if (data == null) break;
            int numComponents = data.getNumComponents();
            for (int i = 0; i < numComponents && !monitor.isCancelled(); ++i) {
                Data component = data.getComponent(i);
                byte[] bytes = new byte[component.getLength()];
                try {
                    program.getMemory().getBytes(component.getAddress(), bytes);
                }
                catch (MemoryAccessException memoryAccessException) {
                    // empty catch block
                }
                boolean isAscii = true;
                for (byte b : bytes) {
                    if (b >= 32 && b <= 126) continue;
                    isAscii = false;
                }
                if (!isAscii || bytes.length <= 1) continue;
                this.changeFormatToString(component);
            }
            address = address.add((long)data.getLength());
        }
    }

    protected void removeEmptyFragments(Program program) throws NotEmptyException {
        Group[] children;
        ProgramModule rootModule = program.getListing().getRootModule("Program Tree");
        for (Group child : children = rootModule.getChildren()) {
            ProgramFragment fragment;
            if (!(child instanceof ProgramFragment) || !(fragment = (ProgramFragment)child).isEmpty()) continue;
            rootModule.removeChild(fragment.getName());
        }
    }

    protected void changeFormatToString(Data data) {
        SettingsDefinition[] settingsDefinitions;
        for (SettingsDefinition settingsDefinition : settingsDefinitions = data.getDataType().getSettingsDefinitions()) {
            if (!(settingsDefinition instanceof FormatSettingsDefinition)) continue;
            FormatSettingsDefinition format = (FormatSettingsDefinition)settingsDefinition;
            format.setChoice((Settings)data, 4);
        }
    }

    protected ProgramFragment createFragment(Program program, String fragmentName, Address start, Address end) throws DuplicateNameException, NotFoundException {
        ProgramModule module = program.getListing().getDefaultRootModule();
        ProgramFragment fragment = this.getFragment(module, fragmentName);
        if (fragment == null) {
            fragment = module.createFragment(fragmentName);
        }
        fragment.move(start, end.subtract(1L));
        return fragment;
    }

    protected ProgramFragment getFragment(ProgramModule module, String fragmentName) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (!group.getName().equals(fragmentName)) continue;
            return (ProgramFragment)group;
        }
        return null;
    }

    protected Data getDataAt(Program program, Address address) {
        return program.getListing().getDefinedDataAt(address);
    }

    protected Data getDataAfter(Program program, Data data) {
        return this.getDataAfter(program, data.getMaxAddress());
    }

    protected Data getDataAfter(Program program, Address address) {
        return program.getListing().getDefinedDataAfter(address);
    }

    protected Address toAddr(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    protected Data createData(Program program, Address address, DataType datatype) throws CodeUnitInsertionException {
        if (datatype instanceof StringDataType) {
            CreateStringCmd cmd = new CreateStringCmd(address);
            if (!cmd.applyTo(program)) {
                throw new CodeUnitInsertionException(cmd.getStatusMsg());
            }
        } else {
            CreateDataCmd cmd = new CreateDataCmd(address, datatype);
            if (!cmd.applyTo(program)) {
                throw new CodeUnitInsertionException(cmd.getStatusMsg());
            }
        }
        return program.getListing().getDefinedDataAt(address);
    }

    protected boolean setPlateComment(Program program, Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, CommentType.PLATE, comment);
        return cmd.applyTo(program);
    }

    protected Function createFunction(Program program, Address entryPoint) {
        CreateFunctionCmd cmd = new CreateFunctionCmd(entryPoint);
        cmd.applyTo((DomainObject)program);
        return program.getListing().getFunctionAt(entryPoint);
    }

    protected Address find(Program program, Address start, byte[] values, TaskMonitor monitor) {
        return program.getMemory().findBytes(start, values, null, true, monitor);
    }
}

