/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import ghidra.util.Conv;
import ghidra.util.xml.XmlUtilities;
import java.math.BigInteger;

public class XmlAttributes {
    private StringBuffer buffer = new StringBuffer();

    public String toString() {
        String s = this.buffer.toString();
        this.buffer.setLength(0);
        return s;
    }

    public void addAttribute(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.buffer.append(" " + name + "=\"" + XmlUtilities.escapeElementEntities(value) + "\"");
    }

    public void addAttribute(String name, boolean value) {
        this.addAttribute(name, value ? "y" : "n");
    }

    public void addAttribute(String name, float value) {
        this.addAttribute(name, Float.toString(value));
    }

    public void addAttribute(String name, double value) {
        this.addAttribute(name, Double.toString(value));
    }

    public void addAttribute(String name, byte value) {
        this.addAttribute(name, value, false);
    }

    public void addAttribute(String name, byte value, boolean hex) {
        this.addAttribute(name, hex ? Conv.byteToInt((byte)value) : value, hex);
    }

    public void addAttribute(String name, short value) {
        this.addAttribute(name, value, false);
    }

    public void addAttribute(String name, short value, boolean hex) {
        this.addAttribute(name, hex ? Conv.shortToInt((short)value) : value, hex);
    }

    public void addAttribute(String name, int value) {
        this.addAttribute(name, value, false);
    }

    public void addAttribute(String name, int value, boolean hex) {
        this.buffer.append(" " + name + "=\"");
        String valueString = Integer.toString(value, hex ? 16 : 10);
        if (valueString.startsWith("-")) {
            this.buffer.append("-");
            valueString = valueString.substring(1);
        }
        if (hex) {
            this.buffer.append("0x");
        }
        this.buffer.append(valueString);
        this.buffer.append("\"");
    }

    public void addAttribute(String name, long value) {
        this.addAttribute(name, value, false);
    }

    public void addAttribute(String name, long value, boolean hex) {
        this.buffer.append(" " + name + "=\"");
        String valueString = Long.toString(value, hex ? 16 : 10);
        if (valueString.startsWith("-")) {
            this.buffer.append("-");
            valueString = valueString.substring(1);
        }
        if (hex) {
            this.buffer.append("0x");
        }
        this.buffer.append(valueString);
        this.buffer.append("\"");
    }

    public void addAttribute(String name, BigInteger value, boolean hex) {
        this.buffer.append(" " + name + "=\"");
        if (hex) {
            this.buffer.append("0x");
        }
        this.buffer.append(value.toString(hex ? 16 : 10));
        this.buffer.append("\"");
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }
}

