/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import docking.widgets.OptionDialog;
import docking.widgets.button.GButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathnameTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GIcon;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import resources.Icons;
import utility.function.Callback;

public class PathnameTablePanel
extends JPanel {
    private static final Icon RESET_ICON = new GIcon("icon.widget.pathmanager.reset");
    private JTable pathnameTable;
    private PathnameTableModel tableModel;
    private JButton upButton;
    private JButton downButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton resetButton;
    private String preferenceForLastSelectedDir = "LastPathDirectory";
    private String title = "Select File";
    private boolean allowMultiFileSelection;
    private GhidraFileFilter filter;
    private boolean addToTop;
    private boolean ordered;
    private boolean supportsDotPath;
    private Callback resetCallback;
    private GhidraFileChooserMode fileChooserMode = GhidraFileChooserMode.FILES_ONLY;

    public PathnameTablePanel(String[] paths, boolean enableEdits, boolean addToTop, boolean ordered) {
        super(new BorderLayout(5, 5));
        this.addToTop = addToTop;
        this.ordered = ordered;
        this.tableModel = new PathnameTableModel(paths, enableEdits);
        this.create();
    }

    public PathnameTablePanel(String[] paths, Callback resetCallback, boolean enableEdits, boolean addToTop, boolean ordered, boolean supportsDotPath) {
        super(new BorderLayout(5, 5));
        this.addToTop = addToTop;
        this.ordered = ordered;
        this.supportsDotPath = supportsDotPath;
        this.resetCallback = resetCallback;
        this.tableModel = new PathnameTableModel(paths, enableEdits);
        this.create();
    }

    public void setFileChooserProperties(String title, String preferenceForLastSelectedDir, GhidraFileChooserMode selectionMode, boolean allowMultiSelection, GhidraFileFilter filter) {
        this.title = Objects.requireNonNull(title);
        this.preferenceForLastSelectedDir = preferenceForLastSelectedDir;
        this.fileChooserMode = Objects.requireNonNull(selectionMode);
        this.allowMultiFileSelection = allowMultiSelection;
        this.filter = filter;
    }

    public void setEditingEnabled(boolean enableEdits) {
        this.tableModel.setEditingEnabled(enableEdits);
    }

    public void setAddToTop(boolean addToTop) {
        this.addToTop = addToTop;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.upButton.setVisible(ordered);
        this.downButton.setVisible(ordered);
        if (!ordered) {
            this.tableModel.sortPaths();
        }
    }

    public String[] getPaths() {
        String[] paths = new String[this.tableModel.getRowCount()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = (String)this.tableModel.getValueAt(i, 0);
        }
        return paths;
    }

    public void setPaths(String[] paths) {
        this.tableModel.setPaths(paths, !this.ordered);
    }

    public JTable getTable() {
        return this.pathnameTable;
    }

    public void clear() {
        this.setPaths(new String[0]);
    }

    private void create() {
        this.upButton = new GButton(Icons.UP_ICON);
        this.upButton.setName("UpArrow");
        this.upButton.setToolTipText("Move the selected path up in list");
        this.upButton.addActionListener(e -> this.up());
        this.upButton.setVisible(this.ordered);
        this.downButton = new GButton(Icons.DOWN_ICON);
        this.downButton.setName("DownArrow");
        this.downButton.setToolTipText("Move the selected path down in list");
        this.downButton.addActionListener(e -> this.down());
        this.downButton.setVisible(this.ordered);
        this.addButton = new GButton(Icons.ADD_ICON);
        this.addButton.setName("AddPath");
        this.addButton.setToolTipText("Display file chooser to select paths to add");
        this.addButton.addActionListener(e -> this.add());
        this.removeButton = new GButton(Icons.DELETE_ICON);
        this.removeButton.setName("RemovePath");
        this.removeButton.setToolTipText("Remove selected path(s) from list");
        this.removeButton.addActionListener(e -> this.remove());
        this.resetButton = new GButton(RESET_ICON);
        this.resetButton.setName("RefreshPaths");
        this.resetButton.setToolTipText("Resets path list to the default values");
        this.resetButton.addActionListener(e -> this.reset());
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(this.upButton);
        buttonBox.add(this.downButton);
        buttonBox.add(this.addButton);
        buttonBox.add(this.removeButton);
        if (this.resetCallback != null) {
            buttonBox.add(this.resetButton);
        }
        this.pathnameTable = new GTable(this.tableModel);
        this.pathnameTable.setShowGrid(false);
        this.pathnameTable.setPreferredScrollableViewportSize(new Dimension(330, 200));
        this.pathnameTable.setTableHeader(null);
        this.pathnameTable.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.pathnameTable);
        this.setDefaultCellRenderer();
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonBox, "East");
        ListSelectionModel selModel = this.pathnameTable.getSelectionModel();
        selModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateButtonsEnabled();
        });
        this.updateButtonsEnabled();
    }

    private void updateButtonsEnabled() {
        int[] rows = this.pathnameTable.getSelectedRows();
        if (this.tableModel.getRowCount() > 1 && rows.length == 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.removeButton.setEnabled(rows.length > 0);
    }

    private void setDefaultCellRenderer() {
        this.pathnameTable.setDefaultRenderer(String.class, new GTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                String pathName = (String)value;
                boolean fileExists = true;
                if (pathName == null) {
                    pathName = "";
                } else {
                    int colonSlashSlash = pathName.indexOf("://");
                    if (colonSlashSlash <= 0) {
                        fileExists = new File(pathName).exists();
                    }
                }
                label.setText(pathName.toString());
                if (!fileExists) {
                    label.setForeground(this.getErrorForegroundColor(data.isSelected()));
                }
                return label;
            }
        });
    }

    private void remove() {
        int[] selectedRows = this.pathnameTable.getSelectedRows();
        if (selectedRows == null) {
            return;
        }
        this.tableModel.remove(selectedRows);
        Arrays.sort(selectedRows);
        int row = selectedRows[selectedRows.length - 1] + 1 - selectedRows.length;
        int count = this.tableModel.getRowCount();
        if (row >= count) {
            row = count - 1;
        }
        if (row >= 0) {
            this.pathnameTable.setRowSelectionInterval(row, row);
        }
        this.updateButtonsEnabled();
    }

    private void add() {
        File dir;
        String dirPath;
        int selection;
        if (this.supportsDotPath && !Arrays.stream(this.getPaths()).anyMatch(p -> p.equals(".")) && (selection = OptionDialog.showOptionNoCancelDialog((Component)this, "Add Path", "Choose how to add a path:", "File Chooser", "Program's Import Location", 3)) == 2) {
            this.tableModel.addPaths(new String[]{"."}, this.addToTop, !this.ordered);
            return;
        }
        GhidraFileChooser fileChooser = new GhidraFileChooser(this);
        fileChooser.setMultiSelectionEnabled(this.allowMultiFileSelection);
        fileChooser.setFileSelectionMode(this.fileChooserMode);
        fileChooser.setTitle(this.title);
        fileChooser.setApproveButtonToolTipText(this.title);
        if (this.filter != null) {
            fileChooser.addFileFilter(this.filter);
        }
        if ((dirPath = Preferences.getProperty((String)this.preferenceForLastSelectedDir)) != null && (dir = new File(dirPath)).isDirectory()) {
            fileChooser.setCurrentDirectory(dir);
        }
        List<File> files = fileChooser.getSelectedFiles();
        String[] paths = (String[])files.stream().map(File::getAbsolutePath).toArray(String[]::new);
        if (!files.isEmpty()) {
            if (this.allowMultiFileSelection) {
                String parent = files.get(0).getParent();
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)parent);
            } else {
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)paths[0]);
            }
        }
        fileChooser.dispose();
        this.tableModel.addPaths(paths, this.addToTop, !this.ordered);
    }

    private void up() {
        int row = this.pathnameTable.getSelectedRow();
        this.tableModel.moveUp(this.pathnameTable, row);
    }

    private void down() {
        int row = this.pathnameTable.getSelectedRow();
        this.tableModel.moveDown(this.pathnameTable, row);
    }

    protected int promptConfirmReset() {
        String confirmation = "<html><body width=\"200px\">\n  Are you sure you would like to reset the paths to the default list?\n  This will remove all paths manually added and cannot be later cancelled.\n</html>";
        String header = "Reset Paths?";
        return OptionDialog.showYesNoDialog(this, header, confirmation);
    }

    private void reset() {
        int optionChosen = this.promptConfirmReset();
        if (this.resetCallback != null && optionChosen == 1) {
            this.resetCallback.call();
        }
    }
}

