/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.actions.KeyEntryDialog;
import docking.actions.ToolActions;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.KeyStroke;

public class SetKeyBindingAction
extends DockingAction {
    public static String NAME = "Set KeyBinding";
    private Tool tool;

    public SetKeyBindingAction(Tool tool, KeyStroke keyStroke) {
        super(NAME, "DockingWindows");
        this.tool = tool;
        this.setKeyBindingData(new KeyBindingData(keyStroke));
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
        if (windowManager == null) {
            return;
        }
        DockingActionIf action = DockingWindowManager.getMouseOverAction();
        if (action == null) {
            return;
        }
        if (!(action = this.maybeGetToolLevelAction(action)).getKeyBindingType().supportsKeyBindings()) {
            Component parent = windowManager.getActiveComponent();
            Msg.showInfo(this.getClass(), (Component)parent, (String)"Unable to Set Keybinding", (Object)("Action \"" + this.getActionName(action) + "\" does not support key bindings"));
            return;
        }
        KeyEntryDialog d = new KeyEntryDialog(this.tool, action);
        DockingWindowManager.showDialog(d);
    }

    private DockingActionIf maybeGetToolLevelAction(DockingActionIf dockingAction) {
        if (dockingAction.getKeyBindingType().isShared()) {
            String actionName = dockingAction.getName();
            ToolActions toolActions = (ToolActions)this.tool.getToolActions();
            DockingActionIf sharedAction = toolActions.getSharedStubKeyBindingAction(actionName);
            if (sharedAction != null) {
                return sharedAction;
            }
        }
        return dockingAction;
    }

    private String getActionName(DockingActionIf action) {
        MenuData popupMenuData = action.getPopupMenuData();
        if (popupMenuData != null) {
            return popupMenuData.getMenuItemName();
        }
        MenuData menuBarData = action.getMenuBarData();
        if (menuBarData != null) {
            return menuBarData.getMenuItemName();
        }
        return action.getName();
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }
}

