/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class CollisionDetector {
    private static final int MAXIMAL_RECTANGLE_SIZE_FOR_COLLISION_DETECTION = 16;

    public boolean detectCollision(Point p, Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform(), 4.0);
        double[] lastCoords = new double[6];
        pathIterator.currentSegment(lastCoords);
        double threshold = 8.0;
        while (true) {
            pathIterator.next();
            double[] nextCoords = new double[6];
            if (pathIterator.isDone() || 4 == pathIterator.currentSegment(nextCoords)) break;
            double distance = this.distanceToLineSegment(lastCoords[0], lastCoords[1], nextCoords[0], nextCoords[1], p.getX(), p.getY());
            if (distance <= threshold) {
                return true;
            }
            lastCoords = nextCoords;
        }
        return false;
    }

    private double distanceToLineSegment(double x1, double y1, double x2, double y2, double px, double py) {
        double yy;
        double xx;
        double A = px - x1;
        double B = py - y1;
        double C = x2 - x1;
        double D = y2 - y1;
        double dot = A * C + B * D;
        double len_sq = C * C + D * D;
        double param = -1.0;
        if (len_sq != 0.0) {
            param = dot / len_sq;
        }
        if (param < 0.0) {
            xx = x1;
            yy = y1;
        } else if (param > 1.0) {
            xx = x2;
            yy = y2;
        } else {
            xx = x1 + param * C;
            yy = y1 + param * D;
        }
        double dx = px - xx;
        double dy = py - yy;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

