/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.HighlightedElements;
import org.freeplane.core.util.Pair;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.plugin.script.FormulaThreadLocalStacks;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.dependencies.RelatedElements;

class DependencyHighlighter {
    private final LinkController linkController;
    private final Configurable configurable;

    DependencyHighlighter(LinkController linkController, Configurable configurable) {
        this.linkController = linkController;
        this.configurable = configurable;
    }

    void showCyclicDependency(NodeScript nodeScript) {
        Controller controller = Controller.getCurrentController();
        if (controller.getMap() != nodeScript.node.getMap()) {
            return;
        }
        List<NodeScript> cycle = FormulaThreadLocalStacks.INSTANCE.findCycle(nodeScript);
        if (cycle.isEmpty()) {
            return;
        }
        this.showCycle(cycle);
    }

    private void showCycle(List<NodeScript> cycle) {
        final HighlightedElements highlightedElements = HighlightedElements.of((Configurable)this.configurable);
        highlightedElements.clear();
        final Stream relatedElements = cycle.stream().map(NodeScript::containingElements).map(RelatedElements::getElements).flatMap(Collection::stream);
        final Connectors connectors = Connectors.of((Configurable)this.configurable);
        connectors.clear();
        final LinkedHashSet<Pair> connectedNodes = new LinkedHashSet<Pair>();
        for (int i = 0; i < cycle.size() - 1; ++i) {
            NodeModel first = cycle.get((int)i).node;
            NodeModel second = cycle.get((int)(i + 1)).node;
            connectedNodes.add(new Pair((Object)first, (Object)second));
        }
        SwingUtilities.invokeLater(new Runnable(){

            private ConnectorModel createConnector(Pair<NodeModel, NodeModel> connectedNodes2) {
                return this.createConnector((NodeModel)connectedNodes2.first, ((NodeModel)connectedNodes2.second).createID());
            }

            private ConnectorModel createConnector(NodeModel source, String targetId) {
                ConnectorModel connectorModel = new ConnectorModel(source, targetId);
                connectorModel.setColor(Optional.of(HighlightedTransformedObject.FAILURE_COLOR));
                connectorModel.setArrows(Optional.of(ConnectorArrows.FORWARD));
                return connectorModel;
            }

            @Override
            public void run() {
                relatedElements.forEach(arg_0 -> ((HighlightedElements)highlightedElements).add(arg_0));
                connectedNodes.stream().map(this::createConnector).forEach(arg_0 -> ((Connectors)connectors).add(arg_0));
                DependencyHighlighter.this.configurable.refresh();
            }
        });
    }

    public void clear() {
        this.configurable.removeExtension(HighlightedElements.class);
        this.configurable.removeExtension(Connectors.class);
    }
}

