define(["exports","./../../emby-apiclient/events.js","./../appsettings.js","./../datetime.js","./../../emby-apiclient/apiclient.js","./../pluginmanager.js","./playqueuemanager.js","./../usersettings/usersettings.js","./../globalize.js","./../../emby-apiclient/connectionmanager.js","./../servicelocator.js","./../../loading/loading.js","./../methodtimer.js","./../qualityoptions.js"],function(_exports,_events,_appsettings,_datetime,_apiclient,_pluginmanager,_playqueuemanager,_usersettings,_globalize,_connectionmanager,_servicelocator,_loading,_methodtimer,_qualityoptions){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var PlaybackItemFields="ProductionYear,PremiereDate,Container";function enableLocalPlaylistManagement(player){return!player.getPlaylist&&!!player.isLocalPlayer}function returnResolve(err){return console.error(err),Promise.resolve()}function addPlaylistItemsToPlaybackReport(info,playlist,serverId){for(var list=[],i=0,length=playlist.length;i<length;i++){var playlistItem=playlist[i],itemInfo={Id:playlistItem.Id,PlaylistItemId:playlistItem.PlaylistItemId};playlistItem.ServerId!==serverId&&(itemInfo.ServerId=playlistItem.ServerId),list.push(itemInfo)}info.NowPlayingQueue=list}function reportPlayback(playbackManagerInstance,state,player,reportPlaylist,serverId,method,progressEventName,additionalData,isAutomated){if(!serverId)return Promise.resolve();var info=Object.assign({},state.PlayState);if((info=additionalData?Object.assign(info,additionalData):info).ItemId=state.NowPlayingItem.Id,!info.ItemId)return Promise.resolve();progressEventName&&(info.EventName=progressEventName),info.PlaylistIndex=state.PlaylistIndex,info.PlaylistLength=state.PlaylistLength,info.NextMediaType=state.NextMediaType;var apiClient=_connectionmanager.default.getApiClient(serverId);return isAutomated&&info.IsPaused&&apiClient.isMinServerVersion("4.8.0.56")?Promise.resolve():reportPlaylist?"reportPlaybackStopped"===method?(addPlaylistItemsToPlaybackReport(info,playbackManagerInstance._playQueueManager.getPlaylistResult({}).Items,serverId),apiClient[method](info).catch(returnResolve)):function(playbackManagerInstance,info,serverId){return playbackManagerInstance.getPlaylist().then(function(playlistResult){addPlaylistItemsToPlaybackReport(info,playlistResult.Items,serverId)})}(playbackManagerInstance,info,serverId).then(function(){return apiClient[method](info).catch(returnResolve)}):apiClient[method](info).catch(returnResolve)}function normalizeName(t){return t.toLowerCase().replace(" ","")}function getItemsForPlayback(serverId,query,signal){var itemId,serverId=_connectionmanager.default.getApiClient(serverId);return query.Ids&&1===query.Ids.split(",").length?(itemId=query.Ids.split(","),serverId.getItem(serverId.getCurrentUserId(),itemId,{ExcludeFields:"VideoChapters,VideoMediaSources,MediaStreams,People,Overview"},signal).then(function(item){return{Items:[item],TotalRecordCount:1}})):(query.Fields=PlaybackItemFields,query.ExcludeLocationTypes="Virtual",query.EnableTotalRecordCount=!1,query.CollapseBoxSetItems=!1,serverId.getItems(serverId.getCurrentUserId(),query,signal))}function mergePlaybackQueries(obj1,obj2){obj1=Object.assign(obj1,obj2),obj2=obj1.Filters?obj1.Filters.split(","):[];return obj2.includes("IsNotFolder")||obj2.push("IsNotFolder"),obj1.Filters=obj2.join(","),obj1}function getMimeType(type,container){if(container=(container||"").toLowerCase(),"Audio"===type){if("opus"===container)return"audio/ogg";if("webma"===container)return"audio/webm";if("m4a"===container)return"audio/mp4"}else if("Video"===type){if("mkv"===container)return"video/x-matroska";if("m4v"===container)return"video/mp4";if("mov"===container)return"video/quicktime";if("mpg"===container)return"video/mpeg";if("flv"===container)return"video/x-flv"}else if("Photo"===type)return"image/"+container;return"application/"+container}function isAutomaticPlayer(player){return!!player.isLocalPlayer}function getAutomaticPlayers(instance,forceLocalPlayer){if(!forceLocalPlayer){forceLocalPlayer=instance._currentPlayer;if(forceLocalPlayer&&!forceLocalPlayer.isLocalPlayer)return[forceLocalPlayer]}return instance.getPlayers().filter(isAutomaticPlayer)}function getDefaultIntros(){return Promise.resolve({Items:[]})}function getAudioMaxValues(deviceProfile){var maxAudioSampleRate=null,maxAudioBitDepth=null,maxAudioBitrate=null;return deviceProfile.CodecProfiles.forEach(function(codecProfile){"Audio"===codecProfile.Type&&(codecProfile.Conditions||[]).forEach(function(condition){"LessThanEqual"===condition.Condition&&"AudioBitDepth"===condition.Property&&(maxAudioBitDepth=condition.Value),"LessThanEqual"===condition.Condition&&"AudioSampleRate"===condition.Property&&(maxAudioSampleRate=condition.Value),"LessThanEqual"===condition.Condition&&"AudioBitrate"===condition.Property&&(maxAudioBitrate=condition.Value)})}),{maxAudioSampleRate:maxAudioSampleRate,maxAudioBitDepth:maxAudioBitDepth,maxAudioBitrate:maxAudioBitrate}}function createAudioMediaSourceFromItem(item){return{Id:item.Id,MediaStreams:[],RunTimeTicks:item.RunTimeTicks,Container:item.Container,Bitrate:item.Bitrate}}function setStreamUrls(items,deviceProfile,maxBitrate,apiClient,startPosition){return function(items,deviceProfile,maxBitrate,apiClient,startPosition){var audioTranscodingProfile=deviceProfile.TranscodingProfiles.filter(function(p){return"Audio"===p.Type&&"Streaming"===p.Context})[0],audioDirectPlayContainers="",deviceProfile=(deviceProfile.DirectPlayProfiles.forEach(function(p){"Audio"===p.Type&&(audioDirectPlayContainers?audioDirectPlayContainers+=","+p.Container:audioDirectPlayContainers=p.Container,p.AudioCodec)&&(audioDirectPlayContainers+="|"+p.AudioCodec)}),getAudioMaxValues(deviceProfile));return apiClient.getAudioStreamUrls(items,audioTranscodingProfile,audioDirectPlayContainers,deviceProfile.maxAudioBitrate||maxBitrate,deviceProfile.maxAudioSampleRate,deviceProfile.maxAudioBitDepth,startPosition,!1)}(items,deviceProfile,maxBitrate,apiClient,startPosition).then(function(streamUrls){for(var i=0,length=items.length;i<length;i++){var item=items[i],streamUrl=streamUrls[i];streamUrl&&(item.MediaSources||(item.MediaSources=[]),item.MediaSources.length||item.MediaSources.push(createAudioMediaSourceFromItem(item)),function(mediaSources,streamUrl){for(var i=0,length=mediaSources.length;i<length;i++)mediaSources[i].StreamUrl=streamUrl}(item.MediaSources,streamUrl))}})}function getParam(name,url){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");name=new RegExp("[\\?&]"+name+"=([^&#]*)","i").exec(url);return null==name?"":decodeURIComponent(name[1].replace(/\+/g," "))}function addResolutionCondition(conditions,name,value){for(var i=0,length=conditions.length;i<length;i++){var currentValue,condition=conditions[i];if(condition.Property===name)return currentValue=parseInt(condition.Value),void(condition.Value=Math.min(currentValue,value).toString())}conditions.push({Condition:"LessThanEqual",Property:name,Value:value.toString(),IsRequired:!1})}function getPlaybackInfo(player,apiClient,item,deviceProfile,maxBitrate,enableAutomaticQuality,startPosition,isPlayback,mediaSourceId,audioStreamIndex,subtitleStreamIndex,currentPlaySessionId,liveStreamId,enableDirectPlay,enableDirectStream,allowVideoStreamCopy,allowAudioStreamCopy,signal){if("Audio"===item.MediaType)return(mediaSource=createAudioMediaSourceFromItem(item)).StreamUrl=function(item,deviceProfile,maxBitrate,apiClient,startPosition){for(var transcodingProfile=deviceProfile.TranscodingProfiles.filter(function(p){return"Audio"===p.Type&&"Streaming"===p.Context})[0],directPlayContainers=[],directPlayProfileIndex=0,directPlayProfilesLength=deviceProfile.DirectPlayProfiles.length;directPlayProfileIndex<directPlayProfilesLength;directPlayProfileIndex++){var p=deviceProfile.DirectPlayProfiles[directPlayProfileIndex];if("Audio"===p.Type){var audioCodecs=p.AudioCodec?p.AudioCodec.split(","):[];if(audioCodecs.length)for(var j=0,length2=audioCodecs.length;j<length2;j++)directPlayContainers.push(p.Container+"|"+audioCodecs[j]);else directPlayContainers.push(p.Container)}}var directPlayContainers=directPlayContainers.join(","),maxValues=getAudioMaxValues(deviceProfile);return apiClient.getAudioStreamUrl(item,transcodingProfile,directPlayContainers,maxValues.maxAudioBitrate||maxBitrate,maxValues.maxAudioSampleRate,maxValues.maxAudioBitDepth,startPosition,!1)}(item,deviceProfile,maxBitrate,apiClient,startPosition),Promise.resolve({MediaSources:[mediaSource],PlaySessionId:getParam("playSessionId",mediaSource.StreamUrl)});if(item.MediaSources&&item.MediaSources.length&&item.MediaSources[0].StreamUrl)return Promise.resolve({MediaSources:item.MediaSources,PlaySessionId:getParam("playSessionId",item.MediaSources[0].StreamUrl)});var mediaSource=item.Id,item={UserId:apiClient.getCurrentUserId(),StartTimeTicks:startPosition||0};if(isPlayback?(item.IsPlayback=!0,item.AutoOpenLiveStream=!0):(item.IsPlayback=!1,item.AutoOpenLiveStream=!1),null!=audioStreamIndex&&(item.AudioStreamIndex=audioStreamIndex),null!=subtitleStreamIndex&&(item.SubtitleStreamIndex=subtitleStreamIndex),null!=enableDirectPlay&&(item.EnableDirectPlay=enableDirectPlay),null!=enableDirectStream&&(item.EnableDirectStream=enableDirectStream),null!=allowVideoStreamCopy&&(item.AllowVideoStreamCopy=allowVideoStreamCopy),null!=allowAudioStreamCopy&&(item.AllowAudioStreamCopy=allowAudioStreamCopy),mediaSourceId&&(item.MediaSourceId=mediaSourceId),liveStreamId&&(item.LiveStreamId=liveStreamId),maxBitrate&&(item.MaxStreamingBitrate=maxBitrate),currentPlaySessionId&&(item.CurrentPlaySessionId=currentPlaySessionId),maxBitrate&&!enableAutomaticQuality){for(var maxWidth,foundGlobalCodecProfile,qualities=_qualityoptions.default.getVideoQualityOptions({currentMaxBitrate:maxBitrate,isAutomaticBitrateEnabled:!0,enableAuto:!1}),i=0,length=qualities.length;i<length;i++)if(qualities[i].bitrate===maxBitrate){maxWidth=qualities[i].maxWidth;break}if(maxWidth){deviceProfile.CodecProfiles=deviceProfile.CodecProfiles||[];for(var _i=0,_length=deviceProfile.CodecProfiles.length;_i<_length;_i++){var codecProfile=deviceProfile.CodecProfiles[_i];"Video"===codecProfile.Type&&(codecProfile.Conditions=codecProfile.Conditions||[],addResolutionCondition(codecProfile.Conditions,"Width",maxWidth),codecProfile.Codec||(foundGlobalCodecProfile=!0))}foundGlobalCodecProfile||(addResolutionCondition((startPosition={Type:"Video",Conditions:[]}).Conditions,"Width",maxWidth),deviceProfile.CodecProfiles.push(startPosition))}}isPlayback=apiClient.getPlaybackInfo(mediaSource,item,deviceProfile,signal);return player.isLocalPlayer?isPlayback:isPlayback.then(sortMediaSourcesForRemotePlayer)}function sortByIsServerContent(a,b){a=_apiclient.default.isLocalItem(a);return a===_apiclient.default.isLocalItem(b)?0:a?1:-1}function sortMediaSourcesForRemotePlayer(playbackInfoResult){return playbackInfoResult.MediaSources.sort(sortByIsServerContent),playbackInfoResult}function supportsDirectPlay(apiClient,item,mediaSource,signal){if(_apiclient.default.isLocalItem(mediaSource))return Promise.resolve(!0);var isFolderRip="bluray"===mediaSource.Container||"dvd"===mediaSource.Container;if(mediaSource.SupportsDirectPlay||isFolderRip){if(mediaSource.IsRemote)return Promise.resolve(!1);if("Http"===mediaSource.Protocol&&!mediaSource.RequiredHttpHeaders.length)return mediaSource.SupportsDirectStream||mediaSource.SupportsTranscoding?function(mediaSource,apiClient,signal){return mediaSource.IsRemote?Promise.resolve(!0):apiClient.getEndpointInfo(signal).then(function(endpointInfo){if(endpointInfo.IsInNetwork){if(!endpointInfo.IsLocal){endpointInfo=(mediaSource.Path||"").toLowerCase();if(endpointInfo.includes("localhost")||endpointInfo.includes("127.0.0.1"))return Promise.resolve(!1)}return Promise.resolve(!0)}return Promise.resolve(!1)})}(mediaSource,apiClient,signal):Promise.resolve(!0);if("File"===mediaSource.Protocol)return new Promise(function(resolve,reject){require(["filesystem"],resolve)}).then(function(filesystem){return filesystem[isFolderRip?"directoryExists":"fileExists"](mediaSource.Path).then(function(){return!0},function(){return!1})})}return Promise.resolve(!1)}function afterPlaybackErrorMessage(instance,errorCode,playNextTrack){"RateLimitExceeded"===errorCode?instance.stop():playNextTrack&&instance.nextTrack()}function showPlaybackErrorMessage(instance,errorResponse,errorCode,fullscreen,playNextTrack){if(!1===fullscreen||"Aborted"===errorCode)return afterPlaybackErrorMessage(instance,errorCode,playNextTrack);function onAlertDismissed(){return afterPlaybackErrorMessage(instance,errorCode,playNextTrack)}var response;_loading.default.hide(),console.error("Playback error: ",errorResponse),(errorResponse="string"==typeof(errorResponse=errorResponse||{errorCode:errorCode})?{errorCode:errorResponse}:errorResponse).errorTitle=_globalize.default.translate("HeaderPlaybackError"),response=errorResponse,Emby.importModule("./modules/common/responsehelper.js").then(function(responseHelper){return responseHelper.handleErrorResponse(response)}).then(onAlertDismissed,onAlertDismissed)}function normalizePlayOptions(playOptions){playOptions.fullscreen=!1!==playOptions.fullscreen}function displayPlayerIndividually(player){return!player.isLocalPlayer}function createTarget(instance,player){for(var allMediaTypes=["Audio","Video","Game","Photo","Book"],mediaTypes=[],i=0,length=allMediaTypes.length;i<length;i++){var mediaType=allMediaTypes[i];canPlayerPlayMediaType(player,mediaType)&&mediaTypes.push(mediaType)}return{name:player.name,id:player.id,playerName:player.name,playableMediaTypes:mediaTypes,isLocalPlayer:player.isLocalPlayer,supportedCommands:instance.getSupportedCommands(player)}}function getPlayerTargets(player){return player.getTargets?player.getTargets():Promise.resolve([createTarget(player)])}function sortPlayerTargets(a,b){var aVal=a.isLocalPlayer?0:1,bVal=b.isLocalPlayer?0:1,aVal=aVal.toString()+a.name,bVal=bVal.toString()+b.name;return aVal.localeCompare(bVal)}var playerStates={};function getPlayerData(player){if(!player)throw new Error("player cannot be null");if(player.name)return playerStates[player.name]||(playerStates[player.name]={},playerStates[player.name]),player;throw new Error("player name cannot be null")}function canPlayerPlayMediaType(player,mediaType){return!!mediaType&&(!(!player.mediaType||player.mediaType!==mediaType)||(player.mediaTypes?player.mediaTypes.includes(mediaType):player.canPlayMediaType(mediaType)))}function setNextEpisodeAutoPlayOnItemsResult(result,options,signal){var firstItem=result.Items[0];return firstItem&&"Episode"===firstItem.Type?options.shuffle?(result.AutoPlay=!0,Promise.resolve(result)):_connectionmanager.default.getApiClient(firstItem).getCurrentUser({signal:signal}).then(function(user){return result.AutoPlay=user.Configuration.EnableNextEpisodeAutoPlay,result}):Promise.resolve(result)}function getSubtitleStream(instance,player,index){return instance.subtitleTracks(player).filter(function(s){return"Subtitle"===s.Type&&s.Index===index})[0]}function formatIncludesValue(format,value){if(format.startsWith("-")){if((format=format.substring(1)).toLowerCase().split(",").includes(value))return}else if(!format.toLowerCase().split(",").includes(value))return;return 1}function getSavedMaxStreamingBitrate(apiClient,mediaType){apiClient=(apiClient=apiClient||_connectionmanager.default.currentApiClient()).getSavedEndpointInfo()||{};return _appsettings.default.maxStreamingBitrate(apiClient.NetworkType,mediaType)}function getDeliveryMethod(subtitleStream){return subtitleStream.DeliveryMethod||(subtitleStream.IsExternal?"External":"Embed")}function canPlayerSeek(instance,player){if(!player)throw new Error("player cannot be null");var streamInfo=getPlayerData(player).streamInfo;if(streamInfo&&(streamInfo.url||"").toLowerCase().includes(".m3u8"))return!0;return player.seekable?player.seekable():!("Transcode"===instance.playMethod(player))&&player.duration()}function onUnhandledPlaybackFailure(instance,err,fullscreen,signal){err=err||{},_loading.default.hide();var errorCode=err.errorCode||(err&&"string"==typeof err?err:"NoCompatibleStream");"intercept-cancel"===errorCode||signal.aborted||showPlaybackErrorMessage(instance,err,errorCode,fullscreen,err.skipToNextItem),_events.default.trigger(instance,"playbackcancelled"),Promise.reject(err)}function onInterceptorRejection(){return Promise.reject({errorCode:"intercept-cancel"})}function stopPlaybackProgressTimer(player){player._progressInterval&&(player._progressInterval.destroy(),player._progressInterval=null)}function runInterceptors(item,playOptions){return new Promise(function(resolve,reject){var options,interceptors=_pluginmanager.default.ofType("preplayintercept");interceptors.sort(function(a,b){return(a.order||0)-(b.order||0)}),interceptors.length?(_loading.default.hide(),(options=Object.assign({},playOptions)).mediaType=item.MediaType,options.item=item,function runNextPrePlay(interceptors,index,options,resolve,reject){if(index>=interceptors.length)return void resolve();var interceptor=interceptors[index];interceptor.intercept(options).then(function(){runNextPrePlay(interceptors,index+1,options,resolve,reject)},reject)}(interceptors,0,options,resolve,reject)):resolve()})}function updateResultSetStartingPoint(result,firstItem,options,isQueueing){for(var startIndex=-1,i=0,length=result.Items.length;i<length;i++){var currentItem=result.Items[i];if(currentItem.Id===firstItem.Id){startIndex=i;break}if(firstItem.PresentationUniqueKey&&currentItem.PresentationUniqueKey===firstItem.PresentationUniqueKey){startIndex=i;break}}return-1!==startIndex?isQueueing?(result.Items=result.Items.slice(startIndex),result.TotalRecordCount=result.Items.length):options.startIndex=startIndex:result={TotalRecordCount:1,Items:[firstItem]},result}function mapToId(i){return i.Id}function getAudioOrMusicVideosForPlayback(firstItem,query,signal){var serverId=firstItem.ServerId,originalRequestedMediaTypes=query.MediaTypes;return originalRequestedMediaTypes||(query.MediaTypes="Audio"),getItemsForPlayback(serverId,query,signal).then(function(result){return result.TotalRecordCount||result.Items.length||originalRequestedMediaTypes?result:(query.MediaTypes="Video",getItemsForPlayback(serverId,query,signal))})}function areAllItemsOfType(items,types){for(var i=0,length=items.length;i<length;i++)if(!types.includes(items[i].Type))return;return 1}function mapProperty(items,prop){return items.map(function(i){return i[prop]})}function translateItemsForPlayback(items,options,showLoading,isQueueing,signal){var promise,firstItem=items[options.startIndex||0],serverId=firstItem.ServerId,queryOptions=options.queryOptions||{};return"Program"===firstItem.Type?promise=getItemsForPlayback(serverId,{Ids:firstItem.ChannelId},signal):"Chapter"===firstItem.Type?(options.mediaSourceId=firstItem.MediaSourceId,options.serverId=firstItem.ServerId,promise=getItemsForPlayback(serverId,{Ids:firstItem.ItemId},signal)):areAllItemsOfType(items,["MusicArtist"])?promise=getAudioOrMusicVideosForPlayback(firstItem,{ArtistIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,ParentId:options.parentId,SortBy:"Album,ParentIndexNumber,IndexNumber"},signal):areAllItemsOfType(items,["MusicGenre"])?promise=getAudioOrMusicVideosForPlayback(firstItem,{GenreIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"Album,ParentIndexNumber,IndexNumber",ParentId:options.parentId,ProjectToMedia:!0},signal):areAllItemsOfType(items,["Genre"])?promise=getItemsForPlayback(serverId,{GenreIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",MediaTypes:"Video",ParentId:options.parentId,ProjectToMedia:!0},signal):areAllItemsOfType(items,["Tag"])?promise=getItemsForPlayback(serverId,{TagIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",ParentId:options.parentId,ProjectToMedia:!0},signal):areAllItemsOfType(items,["Studio"])?promise=getItemsForPlayback(serverId,{StudioIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",ParentId:options.parentId,ProjectToMedia:!0},signal):areAllItemsOfType(items,["GameGenre"])?promise=getItemsForPlayback(serverId,{GenreIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",MediaTypes:"Game",ParentId:options.parentId,ProjectToMedia:!0},signal):areAllItemsOfType(items,["Person"])?promise=getItemsForPlayback(serverId,{PersonIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",ParentId:options.parentId,ProjectToMedia:!0},signal):1<items.length&&areAllItemsOfType(items,["MusicAlbum"])?promise=getItemsForPlayback(serverId,{AlbumIds:mapProperty(items,"Id"),Filters:"IsNotFolder",Recursive:!0,SortBy:"SortName",IsFolder:!1,ParentId:options.parentId},signal):1<items.length&&function(items){for(var i=0,length=items.length;i<length;i++){var item=items[i];if(item.PlaylistItemId)return;if(item.IsFolder)return 1;switch(item.Type){case"MusicAlbum":case"MusicArtist":case"Genre":case"MusicGenre":case"GameGenre":case"Studio":case"Person":return 1}}}(items)&&_connectionmanager.default.getApiClient(firstItem).isMinServerVersion("4.8.0.30")?promise=getItemsForPlayback(serverId,{Ids:items.map(mapToId).join(","),ProjectToMedia:!0},signal):"Playlist"===firstItem.Type?promise=function(item,signal){var serverId=item.ServerId,item=item.Id,sortBy=_usersettings.default.itemSortBy(item)||"default",sortOrder=(sortBy="default"===sortBy?"ListItemOrder":sortBy)?_usersettings.default.itemSortOrder(item):null;return getItemsForPlayback(serverId,{ParentId:item,SortBy:sortBy,SortOrder:sortOrder},signal)}(firstItem,signal):"BoxSet"===firstItem.Type?promise=function(item,signal){var serverId=item.ServerId,itemId=item.Id,sortBy=_usersettings.default.itemSortBy(itemId)||"default",item=("default"===sortBy&&(sortBy="DisplayOrder"),(sortBy=_connectionmanager.default.getApiClient(item).isMinServerVersion("4.8.0.16")?sortBy:null)?_usersettings.default.itemSortOrder(itemId):null);return getItemsForPlayback(serverId,{ParentId:itemId,SortBy:sortBy,SortOrder:item,ProjectToMedia:!0},signal)}(firstItem,signal):"Photo"===firstItem.MediaType&&1===items.length&&firstItem.ParentId?promise=getItemsForPlayback(serverId,{ParentId:firstItem.ParentId,Filters:"IsNotFolder",Recursive:!1,SortBy:"SortName",MediaTypes:"Photo,Video"},signal).then(function(result){var index=result.Items.map(function(i){return i.Id}).indexOf(firstItem.Id);return options.startIndex=index=-1===index?0:index,Promise.resolve(result)}):"PhotoAlbum"===firstItem.Type?(promise=getItemsForPlayback(serverId,{ParentId:firstItem.Id,Filters:"IsNotFolder",Recursive:!1,SortBy:"SortName",MediaTypes:"Photo,Video"},signal),options.autoplay=!0):"MusicAlbum"!==firstItem.Type||!firstItem.SupportsResume||options.shuffle||0===options.startPositionTicks||null!=queryOptions&&queryOptions.Filters?"MusicAlbum"===firstItem.Type?promise=getItemsForPlayback(serverId,mergePlaybackQueries({ParentId:firstItem.Id,Filters:"IsNotFolder",Recursive:!0},queryOptions),signal):"Series"!==firstItem.Type||options.shuffle||0===options.startPositionTicks||null!=queryOptions&&queryOptions.Filters?firstItem.IsFolder?promise=getItemsForPlayback(serverId,mergePlaybackQueries({ParentId:firstItem.Id,Filters:"IsNotFolder",Recursive:!0,IsStandaloneSpecial:"Series"!==firstItem.Type&&("Season"!==firstItem.Type||0===firstItem.IndexNumber)&&null},queryOptions),signal).then(function(result){return"Series"===firstItem.Type?setNextEpisodeAutoPlayOnItemsResult(result,options,signal):result}):"Audio"===firstItem.Type&&firstItem.AlbumId&&firstItem.SupportsResume&&1===items.length&&!isQueueing?promise=(serverId=_connectionmanager.default.getApiClient(firstItem.ServerId)).getItems(serverId.getCurrentUserId(),{Fields:PlaybackItemFields,ParentId:firstItem.AlbumId,Recursive:!0,IncludeItemTypes:"Audio"},signal).then(function(episodesResult){return updateResultSetStartingPoint(episodesResult,firstItem,options,isQueueing)}):"Episode"===firstItem.Type&&firstItem.SeriesId&&1===items.length&&!isQueueing&&(promise=(queryOptions=_connectionmanager.default.getApiClient(firstItem)).getEpisodes(firstItem.SeriesId,{IsVirtualUnaired:!1,IsMissing:!1,UserId:queryOptions.getCurrentUserId(),Fields:PlaybackItemFields+",PresentationUniqueKey"},signal).then(function(episodesResult){return setNextEpisodeAutoPlayOnItemsResult(episodesResult=updateResultSetStartingPoint(episodesResult,firstItem,options,isQueueing),options,signal)})):promise=function(item,signal){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getResumableItemsFromSeries({SeriesId:item.Id,UserId:apiClient.getCurrentUserId(),EnableTotalRecordCount:!1,ExcludeLocationTypes:"Virtual",Fields:PlaybackItemFields},signal).then(function(result){return result.Items.length?result:getItemsForPlayback(item.ServerId,{ParentId:item.Id,Filters:"IsNotFolder",Recursive:!0,IsStandaloneSpecial:!1},signal)})}(firstItem,signal).then(function(result){return setNextEpisodeAutoPlayOnItemsResult(result,options,signal)}):promise=function(item,signal){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getResumableItemsFromAudioBook({AlbumId:item.Id,UserId:apiClient.getCurrentUserId(),EnableTotalRecordCount:!1,ExcludeLocationTypes:"Virtual",Fields:PlaybackItemFields},signal).then(function(result){return result.Items.length?result:getItemsForPlayback(item.ServerId,{ParentId:item.Id,Filters:"IsNotFolder",Recursive:!0},signal)})}(firstItem,signal),promise?(options.fullscreen&&showLoading&&_loading.default.show(),promise.then(function(result){return result&&result.Items?result:{Items:items}})):Promise.resolve({Items:items})}function setPlaylistState(instance,playlistItemId,index){isNaN(index)||instance._playQueueManager.setPlaylistState(playlistItemId,index)}function createStreamInfo(apiClient,type,item,mediaSource,playSessionId,startPosition){var transcodingOffsetTicks,playerStartPositionTicks,originalMediaSource,liveStreamId,playMethod,directOptions,prefix,mediaSourceContainer,mediaUrl,contentType;return item&&!item.Id?function(item){return{url:item.Url||item.Path,playMethod:"DirectPlay",item:item,textTracks:[],mediaType:item.MediaType}}(item):(transcodingOffsetTicks=0,playerStartPositionTicks=startPosition,liveStreamId=(mediaSource=(originalMediaSource=mediaSource)||{MediaStreams:[]}).LiveStreamId,playMethod="Transcode",mediaSourceContainer=(mediaSource.Container||"").toLowerCase(),"Video"!==type&&"Audio"!==type||(contentType=getMimeType(type,mediaSourceContainer),mediaSource.enableDirectPlay)?(mediaUrl=mediaSource.Path,playMethod="DirectPlay"):mediaSource.StreamUrl?(playMethod="Transcode",mediaUrl=mediaSource.StreamUrl):mediaSource.SupportsDirectStream?(mediaUrl=mediaSource.DirectStreamUrl?apiClient.getUrl(mediaSource.DirectStreamUrl):(directOptions={Static:!0,mediaSourceId:mediaSource.Id,deviceId:apiClient.deviceId(),api_key:apiClient.accessToken()},mediaSource.ETag&&(directOptions.Tag=mediaSource.ETag),mediaSource.LiveStreamId&&(directOptions.LiveStreamId=mediaSource.LiveStreamId),prefix="Video"===type?"Videos":"Audio",mediaSourceContainer=mediaSourceContainer.toLowerCase().replace("m4v","mp4"),apiClient.getUrl(prefix+"/"+item.Id+"/stream."+mediaSourceContainer,directOptions)),playMethod="DirectStream"):mediaSource.SupportsTranscoding&&(mediaUrl=apiClient.getUrl(mediaSource.TranscodingUrl),"hls"===mediaSource.TranscodingSubProtocol?contentType="application/x-mpegURL":(playerStartPositionTicks=null,contentType=getMimeType(type,mediaSource.TranscodingContainer),mediaUrl.toLowerCase().includes("copytimestamps=true")||(transcodingOffsetTicks=startPosition||0))),!mediaUrl&&mediaSource.SupportsDirectPlay&&(mediaUrl=mediaSource.Path,playMethod="DirectPlay"),{url:mediaUrl,mimeType:contentType,transcodingOffsetTicks:transcodingOffsetTicks,playMethod:playMethod,playerStartPositionTicks:playerStartPositionTicks,item:item,mediaSource:originalMediaSource,textTracks:getTextTracks(apiClient,item,mediaSource),tracks:getTextTracks(apiClient,item,mediaSource),mediaType:type,liveStreamId:liveStreamId,playSessionId:playSessionId})}function getTextTracks(apiClient,item,mediaSource){for(var textStreams=mediaSource.MediaStreams.filter(function(s){return"Subtitle"===s.Type}).filter(function(s){return"External"===s.DeliveryMethod}),tracks=[],i=0,length=textStreams.length;i<length;i++){var textStream=textStreams[i],textStreamUrl=void 0,textStreamUrl=_apiclient.default.isLocalItem(item)||mediaSource.IsLocal?textStream.Path:textStream.IsExternalUrl?textStream.DeliveryUrl:apiClient.getUrl(textStream.DeliveryUrl);tracks.push({url:textStreamUrl,language:textStream.Language,isDefault:textStream.Index===mediaSource.DefaultSubtitleStreamIndex,index:textStream.Index,format:textStream.Codec})}return tracks}function getPlayer(instance,item,playOptions,forceLocalPlayers){var serverItem=!!item.Id;return getAutomaticPlayers(instance,forceLocalPlayers).filter(function(p){if(canPlayerPlayMediaType(p,item.MediaType)){if(serverItem)return!p.canPlayItem||p.canPlayItem(item,playOptions);if(item.Url&&p.canPlayUrl)return p.canPlayUrl(item.Url)}return!1})[0]}function getPlaybackMediaSource(player,apiClient,deviceProfile,maxBitrate,enableAutomaticQuality,item,startPosition,mediaSourceId,audioStreamIndex,subtitleStreamIndex,signal){return getPlaybackInfo(player,apiClient,item,deviceProfile,maxBitrate,enableAutomaticQuality,startPosition,!0,mediaSourceId,audioStreamIndex,subtitleStreamIndex,null,null,null,null,null,null,signal).then(function(playbackInfoResult){return playbackInfoResult.ErrorCode?Promise.reject({errorCode:playbackInfoResult.ErrorCode}):function(apiClient,item,versions,signal){var promises=versions.map(function(v){return supportsDirectPlay(apiClient,0,v,signal)});return promises.length?Promise.all(promises).then(function(results){for(var i=0,length=versions.length;i<length;i++)versions[i].enableDirectPlay=results[i]||!1;var optimalVersion=versions.filter(function(v){return v.enableDirectPlay})[0];return(optimalVersion=(optimalVersion=optimalVersion||versions.filter(function(v){return v.SupportsDirectStream})[0])||versions.filter(function(s){return s.SupportsTranscoding})[0])||versions[0]}):Promise.reject()}(apiClient,item,playbackInfoResult.MediaSources,signal).then(function(mediaSource){return mediaSource?mediaSource.RequiresOpening&&!mediaSource.LiveStreamId?function(apiClient,item,playSessionId,deviceProfile,maxBitrate,startPosition,mediaSource,audioStreamIndex,subtitleStreamIndex,signal){return deviceProfile={DeviceProfile:deviceProfile,OpenToken:mediaSource.OpenToken},mediaSource={UserId:apiClient.getCurrentUserId(),StartTimeTicks:startPosition||0,ItemId:item.Id,PlaySessionId:playSessionId},maxBitrate&&(mediaSource.MaxStreamingBitrate=maxBitrate),null!=audioStreamIndex&&(mediaSource.AudioStreamIndex=audioStreamIndex),null!=subtitleStreamIndex&&(mediaSource.SubtitleStreamIndex=subtitleStreamIndex),apiClient.ajax({url:apiClient.getUrl("LiveStreams/Open",mediaSource),type:"POST",data:JSON.stringify(deviceProfile),contentType:"application/json",dataType:"json",signal:signal})}(apiClient,item,playbackInfoResult.PlaySessionId,deviceProfile,maxBitrate,startPosition,mediaSource,null,null,signal).then(function(openLiveStreamResult){return supportsDirectPlay(apiClient,0,openLiveStreamResult.MediaSource,signal).then(function(result){return openLiveStreamResult.MediaSource.enableDirectPlay=result,{mediaSource:openLiveStreamResult.MediaSource,playSessionId:playbackInfoResult.PlaySessionId}})}):{mediaSource:mediaSource,playSessionId:playbackInfoResult.PlaySessionId}:Promise.reject({errorCode:"NoCompatibleStream"})})})}function queue(instance,options,mode,player){if(!(player=player||instance._currentPlayer))return instance.play(options);var signal=(new AbortController).signal;if(options.items)return translateItemsForPlayback(options.items,options,null,!0,signal).then(function(translatedResult){return queueAll(instance,translatedResult.Items,mode,player)});if(options.serverId)return getItemsForPlayback(options.serverId,{Ids:options.ids.join(","),ProjectToMedia:!0},signal).then(function(result){return translateItemsForPlayback(result.Items,options,null,!0,signal).then(function(translatedResult){return queueAll(instance,translatedResult.Items,mode,player)})});throw new Error("serverId required!")}function getDeviceProfile(player,item,options){return player.getDeviceProfile(item,options).then(function(profile){var runtimeTicks=null==item?void 0:item.RunTimeTicks;return _appsettings.default.allowDirectStreamLiveTV()||runtimeTicks||"TvChannel"!==(null==item?void 0:item.Type)&&"Recording"!==(null==item?void 0:item.Type)||(profile.DirectPlayProfiles=[]),profile})}function queueAll(instance,items,mode,player){if(items.length){if(!player.isLocalPlayer)return"next"===mode?player.queueNext({items:items}):player.queue({items:items});var apiClient;if(player&&!enableLocalPlaylistManagement(player))return apiClient=_connectionmanager.default.getApiClient(items[0]),getDeviceProfile(player,items[0]).then(function(profile){return setStreamUrls(items,profile,instance.getMaxStreamingBitrate(player),apiClient,0).then(function(){return"next"===mode?player.queueNext(items):player.queue(items)})});"next"===mode?(instance._playQueueManager.autoplay=!0,instance._playQueueManager.queueNext(items)):instance._playQueueManager.queue(items),_events.default.trigger(player,"playlistitemadd")}return Promise.resolve()}function getCurrentTicks(player){var playerTime;if(player)return playerTime=player.isLocalPlayer?Math.floor(1e4*(player.currentTime()||0)):Math.floor(player.currentTime()||0),(player=getPlayerData(player).streamInfo)&&(playerTime+=player.transcodingOffsetTicks||0),playerTime;throw new Error("player cannot be null")}function sendProgressUpdate(instance,player,progressEventName,reportPlaylist,additionalData,isAutomated){if(!player)throw new Error("player cannot be null");var playerData=getPlayerData(player);if("timeupdate"===progressEventName&&(null!=(item=instance.currentItem(player))&&item.ServerId)){var apiClient=_connectionmanager.default.getApiClient(item);if(apiClient){var ticks=getCurrentTicks(player);if(apiClient.shouldSkipProgressReport(progressEventName,ticks))return}}var item,apiClient=instance.getPlayerState(player,item);apiClient.NowPlayingItem&&(ticks=apiClient.NowPlayingItem.ServerId,((item=playerData.streamInfo)&&item.started||!enableLocalPlaylistManagement(player))&&reportPlayback(instance,apiClient,0,reportPlaylist,ticks,"reportPlaybackProgress",progressEventName,additionalData,isAutomated),"AtTime"===(null==(playerData=apiClient.PlayState)?void 0:playerData.SleepTimerMode))&&(reportPlaylist=null==(item=apiClient.PlayState)?void 0:item.SleepTimerEndTime)&&Date.now()>=reportPlaylist.getTime()&&instance.onSleepTimerFired(player)}function PlaybackManager(){var currentTargetInfo,self=this,players=[],currentPairingId=null;function removeCurrentPlayer(player){var previousPlayer=self._currentPlayer;previousPlayer&&player.id!==previousPlayer.id||setCurrentPlayerInternal(null)}function setCurrentPlayerInternal(player,targetInfo){var previousPlayer=self._currentPlayer,previousTargetInfo=currentTargetInfo;if(player&&!targetInfo&&player.isLocalPlayer&&(targetInfo=createTarget(self,player)),player&&!targetInfo)throw new Error("targetInfo cannot be null");currentPairingId=null,self._currentPlayer=player,(currentTargetInfo=targetInfo)&&targetInfo.Id!==(null==previousTargetInfo?void 0:previousTargetInfo.Id)&&console.log("Active player: "+JSON.stringify(targetInfo)),previousPlayer&&self.endPlayerUpdates(previousPlayer),player&&self.beginPlayerUpdates(player),function(playbackManagerInstance,newPlayer,newTarget,previousPlayer,previousTargetInfo){!newPlayer&&!previousPlayer||newTarget&&previousTargetInfo&&newTarget.id===previousTargetInfo.id||_events.default.trigger(playbackManagerInstance,"playerchange",[newPlayer,newTarget,previousPlayer])}(self,player,targetInfo,previousPlayer,previousTargetInfo)}function changeStream(player,ticks,params,progressEventName){var signal,liveStreamId,lastMediaInfoQuery,playSessionId,currentItem;return canPlayerSeek(self,player)&&null==params?(player.currentTime(parseInt(ticks/1e4)),Promise.resolve()):(signal=(new AbortController).signal,params=params||{},liveStreamId=getPlayerData(player).streamInfo.liveStreamId,lastMediaInfoQuery=getPlayerData(player).streamInfo.lastMediaInfoQuery,playSessionId=self.playSessionId(player),currentItem=self.currentItem(player),getDeviceProfile(player,currentItem,{isRetry:!1===params.EnableDirectPlay}).then(function(deviceProfile){var audioStreamIndex=null==params.AudioStreamIndex?getPlayerData(player).audioStreamIndex:params.AudioStreamIndex,subtitleStreamIndex=null==params.SubtitleStreamIndex?getPlayerData(player).subtitleStreamIndex:params.SubtitleStreamIndex,currentMediaSource=self.currentMediaSource(player),apiClient=_connectionmanager.default.getApiClient(currentItem),maxBitrate=(ticks=ticks&&parseInt(ticks),params.MaxStreamingBitrate||self.getMaxStreamingBitrate(player)),currentPlayOptions=currentItem.playOptions||{},enableAutomaticQuality=self.enableAutomaticBitrateDetection(player);return getPlaybackInfo(player,apiClient,currentItem,deviceProfile,maxBitrate,enableAutomaticQuality,ticks,!0,currentMediaSource.Id,audioStreamIndex,subtitleStreamIndex,playSessionId,liveStreamId,params.EnableDirectPlay,params.EnableDirectStream,params.AllowVideoStreamCopy,params.AllowAudioStreamCopy,signal).then(function(result){if(result.ErrorCode)return Promise.reject({errorCode:result.ErrorCode});currentMediaSource=result.MediaSources[0];result=createStreamInfo(apiClient,currentItem.MediaType,currentItem,currentMediaSource,result.PlaySessionId,ticks);return result.fullscreen=currentPlayOptions.fullscreen,result.lastMediaInfoQuery=lastMediaInfoQuery,result.url?(getPlayerData(player).subtitleStreamIndex=subtitleStreamIndex,getPlayerData(player).audioStreamIndex=audioStreamIndex,getPlayerData(player).maxStreamingBitrate=maxBitrate,function(apiClient,player,playSessionId,streamInfo,progressEventName,signal){return getPlayerData(player).streamInfo&&playSessionId?apiClient.stopActiveEncodings(playSessionId).then(function(){return setSrcIntoPlayer(apiClient,player,streamInfo,progressEventName,playSessionId,signal)}):setSrcIntoPlayer(apiClient,player,streamInfo,progressEventName,null,signal)}(apiClient,player,playSessionId,result,progressEventName,signal)):Promise.reject({errorCode:"NoCompatibleStream",skipToNextItem:!0})})}))}function setSrcIntoPlayer(apiClient,player,streamInfo,progressEventName,previousPlaySessionId,signal){return normalizePlayOptions(streamInfo),getPlayerData(player).streamInfo=streamInfo,player.play(streamInfo,signal).then(function(){streamInfo.started=!0,"subtitletrackchange"===progressEventName||"audiotrackchange"===progressEventName?_events.default.trigger(player,progressEventName):sendProgressUpdate(self,player,progressEventName||"timeupdate"),previousPlaySessionId&&apiClient.stopActiveEncodings(previousPlaySessionId)},function(err){return console.error("player.play error: "+err),previousPlaySessionId&&apiClient.stopActiveEncodings(previousPlaySessionId),streamInfo.started=!1,onPlaybackError.call(player,err,{type:err&&err.name?err.name:"mediadecodeerror",streamInfo:streamInfo,returnPromise:!0})})}function playFromFetchedItems(options,items,showLoading,signal){return translateItemsForPlayback(items,options,showLoading,null,signal).then(function(translatedResult){return function(items,options,autoplay,signal){var playStartIndex=options.startIndex;null==playStartIndex&&(playStartIndex=options.shuffle&&items.length?function(min,max){return Math.floor(Math.random()*(max-min+1)+min)}(0,items.length):0);var firstItemApiClient,firstItem=items[playStartIndex];firstItem=firstItem||items[playStartIndex=0];return firstItem?(firstItemApiClient=_connectionmanager.default.getApiClient(firstItem)).getCurrentUser({signal:signal}).then(function(user){return null==options.startPositionTicks&&(options.startPositionTicks=firstItem.UserData&&firstItem.UserData.PlaybackPositionTicks||0,options.startPositionTicks)&&(user=1e7*(user.Configuration.ResumeRewindSeconds||0),options.startPositionTicks=Math.max(0,options.startPositionTicks-user)),function(items,firstItem,firstItemApiClient,playStartIndex,options,autoplay,signal){return function(firstItem,apiClient,options,signal){return options.shuffle||options.startPositionTicks||!1===options.fullscreen||"Video"!==(options=firstItem).MediaType||"TvChannel"===options.Type||"InProgress"===options.Status||!options.Id||!_appsettings.default.enableCinemaMode()?getDefaultIntros():(_loading.default.show(),options={},_servicelocator.appHost.supports("youtube_embedded")||(options.ExcludeSources=["youtube"]),apiClient.getIntros(firstItem.Id,options,signal).catch(getDefaultIntros))}(firstItem,firstItemApiClient,options,signal).then(function(introsResult){var introPlayOptions,introsResult=introsResult.Items;introsResult.length&&playStartIndex&&(items=items.slice(playStartIndex),playStartIndex=0),firstItem.playOptions={autoplay:options.autoplay,fullscreen:options.fullscreen,mediaSourceId:options.mediaSourceId,audioStreamIndex:options.audioStreamIndex,subtitleStreamIndex:options.subtitleStreamIndex,startPositionTicks:options.startPositionTicks,shuffle:options.shuffle},introPlayOptions=introsResult.length?{fullscreen:firstItem.playOptions.fullscreen}:firstItem.playOptions,self._isBackgroundPlaybackHack=!1===introPlayOptions.fullscreen;for(var i=0,length=(items=introsResult.concat(items)).length;i<length;i++)items[i].playOptions||(items[i].playOptions={fullscreen:options.fullscreen});introPlayOptions.items=items,introPlayOptions.startIndex=playStartIndex,introPlayOptions.command="play";var itemToPlay=items[playStartIndex];return playInternal(itemToPlay,introPlayOptions,function(){self._playQueueManager.setPlaylist(items),self._playQueueManager.autoplay=!1!==autoplay,setPlaylistState(self,itemToPlay.PlaylistItemId,playStartIndex),options.shuffle&&self._playQueueManager.setShuffle(!0)},signal)})}(items,firstItem,firstItemApiClient,playStartIndex,options,autoplay,signal)}):Promise.reject("NoPlayableItems")}(translatedResult.Items,options,translatedResult.AutoPlay,signal).catch(function(err){onUnhandledPlaybackFailure(self,err,options.fullscreen,signal)})})}function playPhotos(options,setAsCurrentPlayer,signal){var playStartIndex=options.startIndex||0,startItem=options.items[playStartIndex],player=getPlayer(self,startItem,options);return _loading.default.hide(),player.play(options,signal).then(function(){onPlaybackStarted(player,options,{item:startItem},null,!1,setAsCurrentPlayer)})}function getGenericPlayOptions(item){return{item:item,mediaType:item.MediaType,mimeType:getMimeType(item.Type,item.Container),url:_connectionmanager.default.getApiClient(item).getItemOriginalFileUrl(item.Id)}}function playBooks(options,setAsCurrentPlayer,signal){var playStartIndex=options.startIndex||0,playStartIndex=options.items[playStartIndex],player=getPlayer(self,playStartIndex,options),playOptions=(_loading.default.hide(),getGenericPlayOptions(playStartIndex));return player.play(playOptions,signal).then(function(){onPlaybackStarted(player,options,playOptions,null,!1,setAsCurrentPlayer)})}function playInternal(item,playOptions,onPlaybackStartedFn,signal){return normalizePlayOptions(playOptions),runInterceptors(item,playOptions).then(function(){playOptions.fullscreen&&_loading.default.show();var mediaType=item.MediaType;return!item.Id||_apiclient.default.isLocalItem(item)?playAfterBitrateDetect(getSavedMaxStreamingBitrate(_connectionmanager.default.getApiClient(item),mediaType),!0,item,playOptions,onPlaybackStartedFn,signal):function(apiClient,mediaType,signal){return["Video","Audio"].includes(mediaType||"")?apiClient.getEndpointInfo(signal).then(function(endpointInfo){return _appsettings.default.enableAutomaticBitrateDetection(endpointInfo.NetworkType,mediaType)?apiClient.detectBitrate(signal).then(function(bitrate){return _appsettings.default.maxStreamingBitrate(endpointInfo.NetworkType,mediaType,bitrate),Promise.resolve({bitrate:bitrate,enableAutomaticQuality:!0})}):Promise.resolve({bitrate:getSavedMaxStreamingBitrate(apiClient,mediaType),enableAutomaticQuality:!1})},function(){return Promise.resolve({bitrate:getSavedMaxStreamingBitrate(apiClient,mediaType),enableAutomaticQuality:!1})}):Promise.resolve({bitrate:getSavedMaxStreamingBitrate(apiClient,mediaType),enableAutomaticQuality:!0})}(_connectionmanager.default.getApiClient(item),mediaType,signal).then(function(qualityDetectionResult){return playAfterBitrateDetect(qualityDetectionResult.bitrate,qualityDetectionResult.enableAutomaticQuality,item,playOptions,onPlaybackStartedFn,signal)})},onInterceptorRejection)}function playAfterBitrateDetect(maxBitrate,enableAutomaticQuality,item,playOptions,onPlaybackStartedFn,signal){var startPosition,player,apiClient,streamInfo,promise,activePlayer=self._currentPlayer;return"Photo"===item.MediaType&&activePlayer?playPhotos(playOptions,!1,signal):"Book"===item.MediaType&&activePlayer?playBooks(playOptions,!1,signal):(startPosition=playOptions.startPositionTicks,player=getPlayer(self,item,playOptions),apiClient=item.Id?_connectionmanager.default.getApiClient(item):null,(streamInfo=createStreamInfo(apiClient,item.MediaType,item,null,null,startPosition)).fullscreen=playOptions.fullscreen,promise=activePlayer?function(activePlayer,newPlayer,newItem){var state=self.getPlayerState(activePlayer);stopPlaybackProgressTimer(activePlayer),function(player){_events.default.off(player,"stopped",onPlaybackStopped)}(activePlayer),newPlayer=activePlayer===newPlayer?activePlayer.stop(!1):activePlayer.stop(!0);return console.log("onPlaybackChanging"),newPlayer.then(function(){var streamInfo=getPlayerData(activePlayer).streamInfo,nextMediaType=(getPlayerData(activePlayer).streamInfo=null,bindStopped(activePlayer),newItem.MediaType);return state.NextMediaType=nextMediaType,onPlaybackStopped.call(activePlayer,{},{errorCode:"Aborted",playNext:!1,reportNext:!0,resetPlayQueue:!1,playerState:state,streamInfo:streamInfo})})}(activePlayer,player,item):Promise.resolve(),item.Id?"Photo"===item.MediaType?playPhotos(playOptions,null==activePlayer,signal):"Book"===item.MediaType?playBooks(playOptions,null==activePlayer,signal):"Game"===item.MediaType?function(options,signal){var playStartIndex=options.startIndex||0,playStartIndex=options.items[playStartIndex],player=getPlayer(self,playStartIndex,options),playOptions=(_loading.default.hide(),getGenericPlayOptions(playStartIndex));return player.play(playOptions,signal).then(function(){onPlaybackStarted(player,options,playOptions,null,!1)})}(playOptions,signal):Promise.all([promise,getDeviceProfile(player,item)]).then(function(responses){player&&player.isLocalPlayer&&enableLocalPlaylistManagement(player)&&onPlaybackRequested(player,playOptions,streamInfo);var fullscreen,responses=responses[1],mediaSourceId=playOptions.mediaSourceId,audioStreamIndex=playOptions.audioStreamIndex,subtitleStreamIndex=playOptions.subtitleStreamIndex;return player&&!enableLocalPlaylistManagement(player)?(fullscreen=streamInfo.fullscreen,function(player,items,deviceProfile,maxBitrate,apiClient,startPositionTicks,mediaSourceId,audioStreamIndex,subtitleStreamIndex,startIndex,shuffle,fullscreen){return shuffle&&(startIndex=0,subtitleStreamIndex=audioStreamIndex=mediaSourceId=startPositionTicks=null),setStreamUrls(items,deviceProfile,maxBitrate,apiClient,startPositionTicks).then(function(){return _loading.default.hide(),player.play({items:items,startPositionTicks:startPositionTicks||0,mediaSourceId:mediaSourceId,audioStreamIndex:audioStreamIndex,subtitleStreamIndex:subtitleStreamIndex,startIndex:startIndex,fullscreen:fullscreen,shuffle:shuffle}).then(function(){onPlayQueueStartedFromSelfManagingPlayer.call(player,{})})})}(player,playOptions.items,responses,maxBitrate,apiClient,startPosition,mediaSourceId,audioStreamIndex,subtitleStreamIndex,playOptions.startIndex,playOptions.shuffle,fullscreen)):(playOptions.items=null,getPlaybackMediaSource(player,apiClient,responses,maxBitrate,enableAutomaticQuality,item,startPosition,mediaSourceId,audioStreamIndex,subtitleStreamIndex,signal).then(function(mediaSourceInfo){var mediaSource=mediaSourceInfo.mediaSource;return player=function(instance,mediaSource,existingPlayer){var _mediaSource$Path;if(null!=existingPlayer&&existingPlayer.isLocalPlayer&&null!=(_mediaSource$Path=mediaSource.Path)&&_mediaSource$Path.toLowerCase().includes("youtube.com")&&"http"===(null==(_mediaSource$Path=mediaSource.Protocol)?void 0:_mediaSource$Path.toLowerCase()))for(var _players=getAutomaticPlayers(instance,!0),i=0,length=_players.length;i<length;i++){var player=_players[i];if(player.canPlayUrl&&player.canPlayUrl(mediaSource.Path))return player}return existingPlayer}(self,mediaSource,player),"disc"===mediaSource.Container?(_loading.default.hide(),Promise.reject({errorCode:"PlaceHolder",skipToNextItem:!0})):(Object.assign(streamInfo,createStreamInfo(apiClient,item.MediaType,item,mediaSource,mediaSourceInfo.playSessionId,startPosition)),getPlayerData(player).maxStreamingBitrate=maxBitrate,onPlaybackStartedFn(),console.log("playing with "+player.id),player.play(streamInfo,signal).then(function(){"Audio"!==item.MediaType&&playOptions.fullscreen&&!player.isExternalPlayer||_loading.default.hide(),onPlaybackStarted(player,playOptions,streamInfo,mediaSource)},function(err){return console.log("player.play error: "+err),onPlaybackStarted(player,playOptions,streamInfo,mediaSource).finally(function(){return signal.aborted?onPlaybackStopped.call(player,err,{errorCode:"Aborted",playNext:!1,reportNext:!0,resetPlayQueue:!1}):onPlaybackError.call(player,err,{type:err&&err.name?err.name:"mediadecodeerror",streamInfo:streamInfo,returnPromise:!0,resetPlayQueue:!1})})}))}))}):promise.then(function(){return function(player,playOptions,streamInfo,onPlaybackStartedFn,signal){return onPlaybackRequested(player,playOptions,streamInfo),onPlaybackStartedFn(),player.play(streamInfo,signal).then(function(){_loading.default.hide(),onPlaybackStarted(player,playOptions,streamInfo)},function(err){throw _loading.default.hide(),self.stop(player),err})}(player,playOptions,streamInfo,onPlaybackStartedFn,signal)}))}function startPlaybackProgressTimer(player){stopPlaybackProgressTimer(player),player._progressInterval=new _methodtimer.default({onInterval:function(){sendProgressUpdate(self,this,"timeupdate",null,null,!0)}.bind(player),timeoutMs:1e4,type:"interval"})}function onPlaybackRequested(player,playOptions,streamInfo,mediaSource,setCurrentPlayer){if(!player)throw new Error("player cannot be null");!1!==setCurrentPlayer&&setCurrentPlayerInternal(player);setCurrentPlayer=getPlayerData(player),streamInfo.isInitialRequest=!0,streamInfo.playbackStartTimeTicks=1e4*Date.now(),setCurrentPlayer.streamInfo=streamInfo,mediaSource?(setCurrentPlayer.audioStreamIndex=mediaSource.DefaultAudioStreamIndex,setCurrentPlayer.subtitleStreamIndex=mediaSource.DefaultSubtitleStreamIndex,null==setCurrentPlayer.subtitleStreamIndex&&(setCurrentPlayer.subtitleStreamIndex=-1)):(setCurrentPlayer.audioStreamIndex=null,setCurrentPlayer.subtitleStreamIndex=null),playOptions.command,mediaSource=self.getPlayerState(player,streamInfo.item,streamInfo.mediaSource);_events.default.trigger(player,"playbackrequest",[mediaSource]),_events.default.trigger(self,"playbackrequest",[player,mediaSource])}function onPlaybackStarted(player,playOptions,streamInfo,mediaSource,enableProgressTimer,setCurrentPlayer){if(!player)throw new Error("player cannot be null");!1!==setCurrentPlayer&&setCurrentPlayerInternal(player);var promise,setCurrentPlayer=getPlayerData(player),mediaSource=(streamInfo.isInitialRequest=null,(setCurrentPlayer.streamInfo=streamInfo).playbackStartTimeTicks=1e4*Date.now(),mediaSource?(setCurrentPlayer.audioStreamIndex=mediaSource.DefaultAudioStreamIndex,setCurrentPlayer.subtitleStreamIndex=mediaSource.DefaultSubtitleStreamIndex,null==setCurrentPlayer.subtitleStreamIndex&&(setCurrentPlayer.subtitleStreamIndex=-1)):(setCurrentPlayer.audioStreamIndex=null,setCurrentPlayer.subtitleStreamIndex=null),"play"===playOptions.command),setCurrentPlayer=self.getPlayerState(player,streamInfo.item,streamInfo.mediaSource);return!1!==enableProgressTimer&&(promise=reportPlayback(self,setCurrentPlayer,0,mediaSource,setCurrentPlayer.NowPlayingItem.ServerId,"reportPlaybackStart")),mediaSource&&_events.default.trigger(self,"playqueuestart",[player,setCurrentPlayer]),_events.default.trigger(player,"playbackstart",[setCurrentPlayer]),_events.default.trigger(self,"playbackstart",[player,setCurrentPlayer]),!(streamInfo.started=!0)!==enableProgressTimer&&startPlaybackProgressTimer(player),"AfterItem"===(null==(playOptions=setCurrentPlayer.PlayState)?void 0:playOptions.SleepTimerMode)&&self.onSleepTimerFired(player),promise||Promise.resolve()}function onPlayQueueStartedFromSelfManagingPlayer(e,item,mediaSource){item=self.getPlayerState(this,item,mediaSource);_events.default.trigger(self,"playqueuestart",[this,item])}function onSleepTimerFiredFromSelfManagingPlayer(e){self.onSleepTimerFired(this)}function onPlaybackStartedFromSelfManagingPlayer(e,item,mediaSource){setCurrentPlayerInternal(this);item=self.getPlayerState(this,item,mediaSource);_events.default.trigger(this,"playbackstart",[item]),_events.default.trigger(self,"playbackstart",[this,item])}function onPlaybackStoppedFromSelfManagingPlayer(e,playerStopInfo){stopPlaybackProgressTimer(this);var state=self.getPlayerState(this,playerStopInfo.item,playerStopInfo.mediaSource),nextMediaType=playerStopInfo.nextMediaType,playbackStopInfo={player:this,state:state,nextMediaType:nextMediaType};state.NextMediaType=nextMediaType,getPlayerData(this).streamInfo=null,playerStopInfo.item.Id&&(state.PlayState.PositionTicks=1e4*(playerStopInfo.positionMs||0)),_events.default.trigger(this,"playbackstop",[state]),_events.default.trigger(self,"playbackstop",[playbackStopInfo]),nextMediaType||(this.destroy(),removeCurrentPlayer(this))}function onPlaybackError(e,error){var errorType=error.type,errorType=(console.log("playbackmanager playback error type: "+(errorType||"")),error.streamInfo||getPlayerData(this).streamInfo);if(errorType){var transcodingFallbackOptions=self.getTranscodingFallbackOptions(this,error);if(transcodingFallbackOptions.canTrigger)return changeStream(this,getCurrentTicks(this)||errorType.playerStartPositionTicks,{EnableDirectPlay:!1,EnableDirectStream:!1,AllowVideoStreamCopy:"Transcode"!==errorType.playMethod&&null,AllowAudioStreamCopy:!transcodingFallbackOptions.currentlyPreventsAudioStreamCopy&&!transcodingFallbackOptions.currentlyPreventsVideoStreamCopy&&null})}return onPlaybackStopped.call(this,e,{errorCode:"NoCompatibleStream",returnPromise:error.returnPromise})}function onPlaybackStopped(e,playerStopInfo){console.log("onPlaybackStopped");var reportPlaybackPromise,playerData=getPlayerData(this),state=(stopPlaybackProgressTimer(this),(playerStopInfo=playerStopInfo||{}).playerState||self.getPlayerState(this)),streamInfo=playerStopInfo.streamInfo||playerData.streamInfo,isCurrentPlayer=(playerData.streamInfo=null,this===self.getCurrentPlayer()),playerData=isCurrentPlayer&&(!1!==playerStopInfo.playNext||playerStopInfo.reportNext)?self._playQueueManager.getNextItemInfo():null,nextItem=isCurrentPlayer&&!1!==playerStopInfo.playNext?self._playQueueManager.getNextItemInfo():null,playNextItem=!0,currentItem=null==streamInfo?void 0:streamInfo.item,nextMediaType=(currentItem&&currentItem.Id&&!1===this.supportsProgress&&state.PlayState&&!state.PlayState.PositionTicks&&(state.PlayState.PositionTicks=currentItem.RunTimeTicks,nextItem=playerData=null),!1!==this.supportsProgress&&!this.isExternalPlayer||(nextItem=playerData=null),!1===self._playQueueManager.autoplay&&"Episode"===(null==currentItem?void 0:currentItem.Type)&&(playNextItem=!1,_usersettings.default.enableNextVideoInfoOverlay()||(nextItem=playerData=null)),playerData?playerData.item.MediaType:null),playbackStopInfo={player:this,state:state,nextMediaType:nextMediaType},nextMediaType=(state.NextMediaType=nextMediaType,console.log("nextMediaType: "+nextMediaType),!1!==playerStopInfo.resetPlayQueue&&!nextItem&&isCurrentPlayer&&self._playQueueManager.reset(),currentItem&&currentItem.Id&&(reportPlaybackPromise=reportPlayback(self,state,0,!playerData,currentItem.ServerId,"reportPlaybackStopped")),_events.default.trigger(this,"playbackstop",[state]),_events.default.trigger(self,"playbackstop",[playbackStopInfo]),playerData&&playerData.item.playOptions||{fullscreen:!0});return(playerData?getPlayer(self,playerData.item,nextMediaType):null)!==this&&(this.destroy(),removeCurrentPlayer(this)),(reportPlaybackPromise||Promise.resolve()).finally(function(){if(isCurrentPlayer){if(playNextItem||(nextItem=null),playerStopInfo.errorCode)return playerStopInfo.returnPromise?Promise.reject(playerStopInfo):void showPlaybackErrorMessage(self,null,playerStopInfo.errorCode,!streamInfo||streamInfo.fullscreen,nextItem);var runtimeTicks,_state$PlayState4;nextItem?self.nextTrack():streamInfo&&currentItem.Id&&"TvChannel"===currentItem.Type&&(runtimeTicks=(streamInfo.mediaSource||{}).RunTimeTicks,console.log("channel runtimeTicks: "+runtimeTicks),runtimeTicks)&&(_state$PlayState4=null==(_state$PlayState4=state.PlayState)?void 0:_state$PlayState4.PositionTicks,console.log("channel positionTicks: "+_state$PlayState4),Math.ceil(_state$PlayState4||0)/1e4+5e3>=Math.floor(runtimeTicks/1e4))&&(console.log("restarting live channel"),self.play({items:[currentItem]}))}})}function bindStopped(player){enableLocalPlaylistManagement(player)&&(_events.default.off(player,"stopped",onPlaybackStopped),_events.default.on(player,"stopped",onPlaybackStopped))}function onPlaybackTimeUpdate(e){sendProgressUpdate(self,this,"timeupdate")}function onAudioTrackChange(e){sendProgressUpdate(self,this,"audiotrackchange")}function onSubtitleTrackChange(e){sendProgressUpdate(self,this,"subtitletrackchange")}function onPlaybackPause(e){enableLocalPlaylistManagement(this)&&sendProgressUpdate(self,this,"pause"),_events.default.trigger(self,"pause",[this])}function onPlaybackUnpause(e){enableLocalPlaylistManagement(this)&&sendProgressUpdate(self,this,"unpause"),_events.default.trigger(self,"unpause",[this])}function onPlaybackVolumeChange(e){sendProgressUpdate(self,this,"volumechange")}function onRepeatModeChange(e){sendProgressUpdate(self,this,"repeatmodechange")}function onSleepTimerChange(e){sendProgressUpdate(self,this,"sleeptimerchange")}function onShuffleChange(e){sendProgressUpdate(self,this,"shufflechange"),_events.default.trigger(this,"playlistitemmove",[])}function onSubtitleOffsetChange(e){sendProgressUpdate(self,this,"subtitleoffsetchange")}function onPlaybackRateChange(e){sendProgressUpdate(self,this,"playbackratechange")}function onPlaylistItemMove(e){sendProgressUpdate(self,this,"playlistitemmove",!0)}function onPlaylistItemRemove(e,info){sendProgressUpdate(self,this,"playlistitemremove",!0,{PlaylistItemIds:info?info.PlaylistItemIds:null})}function onPlaylistItemAdd(e){sendProgressUpdate(self,this,"playlistitemadd",!0)}function onPlayerShutdown(e){removeCurrentPlayer(this)}function initMediaPlayer(player){players.push(player),players.sort(function(a,b){return(a.priority||0)-(b.priority||0)}),!1!==player.isLocalPlayer&&(player.isLocalPlayer=!0),player.currentState={},player.getVolume&&player.setVolume||function(player){player.getVolume=function(){return player.volume()},player.setVolume=function(val){return player.volume(val)}}(player),enableLocalPlaylistManagement(player)?(_events.default.on(player,"error",onPlaybackError),_events.default.on(player,"timeupdate",onPlaybackTimeUpdate),_events.default.on(player,"audiotrackchange",onAudioTrackChange),_events.default.on(player,"subtitletrackchange",onSubtitleTrackChange),_events.default.on(player,"pause",onPlaybackPause),_events.default.on(player,"unpause",onPlaybackUnpause),_events.default.on(player,"volumechange",onPlaybackVolumeChange),_events.default.on(player,"repeatmodechange",onRepeatModeChange),_events.default.on(player,"sleeptimerchange",onSleepTimerChange),_events.default.on(player,"shufflechange",onShuffleChange),_events.default.on(player,"subtitleoffsetchange",onSubtitleOffsetChange),_events.default.on(player,"playbackratechange",onPlaybackRateChange),_events.default.on(player,"playlistitemmove",onPlaylistItemMove),_events.default.on(player,"playlistitemremove",onPlaylistItemRemove),_events.default.on(player,"playlistitemadd",onPlaylistItemAdd)):player.isLocalPlayer&&(_events.default.on(player,"pause",onPlaybackPause),_events.default.on(player,"unpause",onPlaybackUnpause),_events.default.on(player,"itemstarted",onPlaybackStartedFromSelfManagingPlayer),_events.default.on(player,"itemstopped",onPlaybackStoppedFromSelfManagingPlayer),_events.default.on(player,"playqueuestarted",onPlayQueueStartedFromSelfManagingPlayer),_events.default.on(player,"sleeptimerfired",onSleepTimerFiredFromSelfManagingPlayer),_events.default.on(player,"audiotrackchange",onAudioTrackChange),_events.default.on(player,"subtitletrackchange",onSubtitleTrackChange),_events.default.on(player,"subtitleoffsetchange",onSubtitleOffsetChange),_events.default.on(player,"playbackratechange",onPlaybackRateChange),_events.default.on(player,"playlistitemmove",onPlaylistItemMove),_events.default.on(player,"playlistitemremove",onPlaylistItemRemove),_events.default.on(player,"playlistitemadd",onPlaylistItemAdd),_events.default.on(player,"shutdown",onPlayerShutdown)),player.isLocalPlayer&&function(player){_events.default.on(_servicelocator.fullscreenManager,"fullscreenchange",function(){_events.default.trigger(player,"fullscreenchange")})}(player),bindStopped(player)}this._playQueueManager=new _playqueuemanager.default,self.getPlayerInfo=function(player){var target;return(player=player||self._currentPlayer)?(target=currentTargetInfo||{},{name:player.name,isLocalPlayer:player.isLocalPlayer,id:target.id,playerName:target.playerName,deviceName:target.deviceName,playableMediaTypes:target.playableMediaTypes,supportedCommands:target.supportedCommands}):null},self.setActivePlayer=function(player,targetInfo){if("localplayer"===player||"localplayer"===player.name)return self._currentPlayer&&self._currentPlayer.isLocalPlayer?void 0:void setCurrentPlayerInternal(null,null);if(!(player="string"==typeof player?players.filter(function(p){return p.name===player})[0]:player))throw new Error("null player");setCurrentPlayerInternal(player,targetInfo)},self.trySetActivePlayer=function(player,targetInfo){if("localplayer"===player||"localplayer"===player.name)self._currentPlayer&&self._currentPlayer.isLocalPlayer,self._isPairing=!1;else{if(!(player="string"==typeof player?players.filter(function(p){return p.name===player})[0]:player))throw new Error("null player");var promise;currentPairingId===targetInfo.id?self._isPairing=!1:(currentPairingId=targetInfo.id,promise=player.tryPair?player.tryPair(targetInfo):Promise.resolve(),self._isPairing=!0,_events.default.trigger(self,"pairing"),promise.then(function(){self._isPairing=!1,_events.default.trigger(self,"paired"),setCurrentPlayerInternal(player,targetInfo)},function(){self._isPairing=!1,_events.default.trigger(self,"pairerror"),currentPairingId===targetInfo.id&&(currentPairingId=null)}))}},self.getTargets=function(){var promises=players.filter(displayPlayerIndividually).map(getPlayerTargets);return Promise.all(promises).then(function(responses){for(var targets=[],i=0;i<responses.length;i++)for(var subTargets=responses[i],j=0;j<subTargets.length;j++)targets.push(subTargets[j]);return targets=targets.sort(sortPlayerTargets)})},self.getPlayers=function(){return players},self.setAudioStreamIndex=function(index,player){return(player=player||self._currentPlayer)&&!player.isLocalPlayer?player.setAudioStreamIndex(index):"Transcode"!==self.playMethod(player)&&player.canSetAudioStreamIndex()?getDeviceProfile(player,self.currentItem(player)).then(function(profile){if(!function(instance,mediaSource,index,deviceProfile){for(var mediaStream,mediaStreams=mediaSource.MediaStreams,i=0,length=mediaStreams.length;i<length;i++)if("Audio"===mediaStreams[i].Type&&mediaStreams[i].Index===index){mediaStream=mediaStreams[i];break}return mediaStream&&instance.isAudioStreamSupported(mediaStream,mediaSource,deviceProfile)}(self,self.currentMediaSource(player),index,profile))return changeStream(player,getCurrentTicks(player),{AudioStreamIndex:index},"audiotrackchange");player.setAudioStreamIndex(index),getPlayerData(player).audioStreamIndex=index,_events.default.trigger(player,"audiotrackchange")}):changeStream(player,getCurrentTicks(player),{AudioStreamIndex:index},"audiotrackchange")},self.setMaxStreamingBitrate=function(options,player){var apiClient;return(player=player||self._currentPlayer)&&player.setMaxStreamingBitrate?player.setMaxStreamingBitrate(options):(apiClient=_connectionmanager.default.getApiClient(self.currentItem(player))).getEndpointInfo().then(function(endpointInfo){var playerData=getPlayerData(player),mediaType=playerData.streamInfo?playerData.streamInfo.mediaType:null,playerData=options.enableAutomaticBitrateDetection?(_appsettings.default.enableAutomaticBitrateDetection(endpointInfo.NetworkType,mediaType,!0),apiClient.detectBitrate()):(_appsettings.default.enableAutomaticBitrateDetection(endpointInfo.NetworkType,mediaType,!1),Promise.resolve(options.maxBitrate));return playerData.then(function(bitrate){return _appsettings.default.maxStreamingBitrate(endpointInfo.NetworkType,mediaType,bitrate),changeStream(player,getCurrentTicks(player),{MaxStreamingBitrate:bitrate},"qualitychange")})})},self.setSubtitleStreamIndex=function(index,player,refreshMediaSource){if((player=player||self._currentPlayer)&&!player.isLocalPlayer)return player.setSubtitleStreamIndex(index,refreshMediaSource);var currentStream=self.getSubtitleStream(player),newStream=getSubtitleStream(self,player,index);if(currentStream||newStream||refreshMediaSource){var selectedTrackElementIndex=-1,currentPlayMethod=self.playMethod(player);if(refreshMediaSource)return changeStream(player,getCurrentTicks(player),{SubtitleStreamIndex:index},"subtitletrackchange");if(currentStream&&!newStream){if("Encode"===getDeliveryMethod(currentStream)||"Embed"===getDeliveryMethod(currentStream)&&"Transcode"===currentPlayMethod)return changeStream(player,getCurrentTicks(player),{SubtitleStreamIndex:-1},"subtitletrackchange")}else if(!currentStream&&newStream){if("External"!==getDeliveryMethod(newStream)&&"Hls"!==getDeliveryMethod(newStream)&&"VideoSideData"!==getDeliveryMethod(newStream)&&("Embed"!==getDeliveryMethod(newStream)||"Transcode"===currentPlayMethod))return changeStream(player,getCurrentTicks(player),{SubtitleStreamIndex:index},"subtitletrackchange");selectedTrackElementIndex=index}else if(currentStream&&newStream){if("External"!==getDeliveryMethod(newStream)&&"Hls"!==getDeliveryMethod(newStream)&&"VideoSideData"!==getDeliveryMethod(newStream)&&("Embed"!==getDeliveryMethod(newStream)||"Transcode"===currentPlayMethod))return changeStream(player,getCurrentTicks(player),{SubtitleStreamIndex:index},"subtitletrackchange");if(selectedTrackElementIndex=index,"External"!==getDeliveryMethod(currentStream)&&"Hls"!==getDeliveryMethod(currentStream)&&"Embed"!==getDeliveryMethod(currentStream)&&"VideoSideData"!==getDeliveryMethod(currentStream))return changeStream(player,getCurrentTicks(player),{SubtitleStreamIndex:-1},"subtitletrackchange")}refreshMediaSource=player.setSubtitleStreamIndex(selectedTrackElementIndex);return getPlayerData(player).subtitleStreamIndex=index,_events.default.trigger(player,"subtitletrackchange"),refreshMediaSource}},self.seek=function(ticks,player){return ticks=Math.max(0,ticks),(player=player||self._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.isLocalPlayer?player.seek((ticks||0)/1e4):player.seek(ticks):changeStream(player,ticks)},self.play=function(options){if(normalizePlayOptions(options),self._currentPlayer){if(!1===options.enableRemotePlayers&&!self._currentPlayer.isLocalPlayer)return Promise.reject();if(!self._currentPlayer.isLocalPlayer)return null!=(_options$items=options.items)&&_options$items.length&&"Chapter"===options.items[0].Type&&(_options$items=options.items[0],options.mediaSourceId=_options$items.MediaSourceId,options.serverId=_options$items.ServerId,options.ids=[_options$items.ItemId],options.items=null),_options$items=this.newAbortSignal(),self._currentPlayer.play(options,_options$items)}var _options$items,_signal2;if(options.items)return _options$items=this.newAbortSignal(),playFromFetchedItems(options,options.items,!0,_options$items);if(options.serverId)return _signal2=this.newAbortSignal(),options.fullscreen&&_loading.default.show(),getItemsForPlayback(options.serverId,{Ids:options.ids.join(","),ProjectToMedia:!0},_signal2).then(function(result){return playFromFetchedItems(options,result.Items,!1,_signal2)});throw new Error("serverId required!")},self.setCurrentPlaylistItemAndIndex=function(newItem,newItemIndex,player){var newItemPlayOptions,signal;return newItem?((newItemPlayOptions=newItem.playOptions||{}).startPositionTicks=0,newItemPlayOptions.command="setCurrentPlaylistItem",signal=this.newAbortSignal(),playInternal(newItem,newItemPlayOptions,function(){setPlaylistState(self,newItem.PlaylistItemId,newItemIndex)},signal).catch(function(err){onUnhandledPlaybackFailure(self,err,!0,signal)})):Promise.reject()},_events.default.on(_pluginmanager.default,"registered",function(e,plugin){"mediaplayer"===plugin.type&&initMediaPlayer(plugin)}),_pluginmanager.default.ofType("mediaplayer").map(initMediaPlayer),self.onAppClose=function(){var player=this._currentPlayer;player&&player.isLocalPlayer&&enableLocalPlaylistManagement(player)&&this.isPlaying(player)&&(this._playQueueManager.reset(),onPlaybackStopped.call(player))},self.triggerTranscodingFallback=function(player){var err;return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.triggerTranscodingFallback():(err=new Error("Playback Correction"),onPlaybackError.call(player,err,{type:"mediadecodeerror",returnPromise:!0,resetPlayQueue:!1}))}}function getFrameTicks(streamInfo){streamInfo=null==streamInfo||null==(streamInfo=streamInfo.mediaSource)?void 0:streamInfo.MediaStreams;if(streamInfo){streamInfo=streamInfo.find(function(e){return"Video"===e.Type}),streamInfo=(null==streamInfo?void 0:streamInfo.RealFrameRate)||(null==streamInfo?void 0:streamInfo.AverageFrameRate);if(streamInfo)return 1/streamInfo*1e3*1e4}return null}PlaybackManager.prototype.getTranscodingFallbackOptions=function(player,error){player=player||this._currentPlayer;error.type;error=error.streamInfo||getPlayerData(player).streamInfo;if(error){var player=error.url.toLowerCase().includes("allowvideostreamcopy=false"),currentlyPreventsAudioStreamCopy=error.url.toLowerCase().includes("allowaudiostreamcopy=false"),item=error.item;if(item&&!_apiclient.default.isLocalItem(item)&&function(streamInfo,currentlyPreventsVideoStreamCopy,currentlyPreventsAudioStreamCopy){return!(!streamInfo.mediaSource.SupportsTranscoding||currentlyPreventsVideoStreamCopy&&currentlyPreventsAudioStreamCopy)}(error,player,currentlyPreventsAudioStreamCopy)){error=_connectionmanager.default.getApiClient(item).getCurrentUserCached();if(null!=error&&error.Policy.EnablePlaybackRemuxing)return{canTrigger:!0,currentlyPreventsVideoStreamCopy:player,currentlyPreventsAudioStreamCopy:currentlyPreventsAudioStreamCopy}}}return{canTrigger:!1}},PlaybackManager.prototype.canTriggerTranscodingFallback=function(player){return this.getTranscodingFallbackOptions(player,{type:"transcodingfallback"}).canTrigger},PlaybackManager.prototype.currentItem=function(player){return(player=player||this._currentPlayer)?player.currentItem?player.currentItem():(player=getPlayerData(player)).streamInfo?player.streamInfo.item:null:null},PlaybackManager.prototype.currentMediaSource=function(player){if(player)return player.currentMediaSource?player.currentMediaSource():(player=getPlayerData(player)).streamInfo?player.streamInfo.mediaSource:null;throw new Error("player cannot be null")},PlaybackManager.prototype.playMethod=function(player){if(player)return player.playMethod?player.playMethod():(player=getPlayerData(player)).streamInfo?player.streamInfo.playMethod:null;throw new Error("player cannot be null")},PlaybackManager.prototype.playSessionId=function(player){if(player)return player.playSessionId?player.playSessionId():(player=getPlayerData(player)).streamInfo?player.streamInfo.playSessionId:null;throw new Error("player cannot be null")},PlaybackManager.prototype.isPairing=function(){return this._isPairing},PlaybackManager.prototype.getPlaylist=function(options,player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.getPlaylist(options):Promise.resolve(this._playQueueManager.getPlaylistResult(options))},PlaybackManager.prototype.isPlaying=function(player){return(player=player||this._currentPlayer)&&player.isPlaying?player.isPlaying():player&&enableLocalPlaylistManagement(player)?null!=getPlayerData(player).streamInfo:null!=player&&null!=player.currentSrc()},PlaybackManager.prototype.isPlayingMediaType=function(mediaTypes,player){var streamInfo;return player=player||this._currentPlayer,Array.isArray(mediaTypes)||(mediaTypes=[mediaTypes]),player&&player.isPlaying?0<mediaTypes.filter(function(mediaType){return player.isPlaying(mediaType)}).length:!!this.isPlaying(player)&&(streamInfo=(streamInfo=getPlayerData(player).streamInfo)?streamInfo.mediaType:null)&&mediaTypes.includes(streamInfo)},PlaybackManager.prototype.isPlayingLocally=function(mediaTypes,player){return!(!(player=player||this._currentPlayer)||!player.isLocalPlayer)&&this.isPlayingMediaType(mediaTypes,player)},PlaybackManager.prototype.isPlayingVideo=function(player){return this.isPlayingMediaType(["Video"],player)},PlaybackManager.prototype.isPlayingAudio=function(player){return this.isPlayingMediaType(["Audio"],player)},PlaybackManager.prototype.canPlay=function(item){switch(item.Type){case"PhotoAlbum":case"MusicGenre":case"Genre":case"Season":case"Series":case"BoxSet":case"MusicAlbum":case"MusicArtist":case"Playlist":case"CollectionFolder":case"Movie":case"MusicVideo":case"Trailer":case"Video":case"TvChannel":case"Audio":case"Tag":case"Studio":case"Folder":case"Photo":return!0;case"Episode":return"Virtual"!==item.LocationType;case"GameSystem":case"Person":case"GameGenre":return!1;case"Program":return item.EndDate&&item.StartDate?!(Date.now()>Date.parse(item.EndDate)||Date.now()<Date.parse(item.StartDate)):!1;default:if("playlists"===item.CollectionType)return!0;if("Virtual"===item.LocationType)return!1}return null!=getPlayer(this,item,{fullscreen:!0})},PlaybackManager.prototype.changeAudioStream=function(player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.changeAudioStream();if(!player)return Promise.resolve();for(var currentMediaSource=this.currentMediaSource(player),mediaStreams=[],i=0,length=currentMediaSource.MediaStreams.length;i<length;i++)"Audio"===currentMediaSource.MediaStreams[i].Type&&mediaStreams.push(currentMediaSource.MediaStreams[i]);if(mediaStreams.length<=1)return Promise.resolve();var currentStreamIndex=this.getAudioStreamIndex(player),indexInList=-1;for(i=0,length=mediaStreams.length;i<length;i++)if(mediaStreams[i].Index===currentStreamIndex){indexInList=i;break}var nextIndex=indexInList+1,nextIndex=-1===(nextIndex=mediaStreams.length<=nextIndex?0:nextIndex)?-1:mediaStreams[nextIndex].Index;return this.setAudioStreamIndex(nextIndex,player)},PlaybackManager.prototype.changeSubtitleStream=function(player){if(!(player=player||this._currentPlayer))return Promise.resolve();for(var currentMediaSource=this.currentMediaSource(player),mediaStreams=[],i=0,length=currentMediaSource.MediaStreams.length;i<length;i++)"Subtitle"===currentMediaSource.MediaStreams[i].Type&&mediaStreams.push(currentMediaSource.MediaStreams[i]);if(!mediaStreams.length)return Promise.resolve();var currentStreamIndex=this.getSubtitleStreamIndex(player),indexInList=-1;for(i=0,length=mediaStreams.length;i<length;i++)if(mediaStreams[i].Index===currentStreamIndex){indexInList=i;break}var nextIndex=indexInList+1,nextIndex=-1===(nextIndex=mediaStreams.length<=nextIndex?-1:nextIndex)?-1:mediaStreams[nextIndex].Index;return this.setSubtitleStreamIndex(nextIndex,player)},PlaybackManager.prototype.getAudioStreamIndex=function(player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.getAudioStreamIndex():getPlayerData(player).audioStreamIndex},PlaybackManager.prototype.isAudioStreamSupported=function(stream,mediaSource,deviceProfile){var audioCodec=(stream.Codec||"").toLowerCase(),container=(mediaSource.Container||"").toLowerCase();return!deviceProfile||0<(deviceProfile.DirectPlayProfiles||[]).filter(function(p){return"Video"===p.Type&&!(p.Container&&!formatIncludesValue(p.Container,container)||p.AudioCodec&&!formatIncludesValue(p.AudioCodec,audioCodec))}).length},PlaybackManager.prototype.getMaxStreamingBitrate=function(player){var playerData;return(player=player||this._currentPlayer)&&player.getMaxStreamingBitrate?player.getMaxStreamingBitrate():(playerData=getPlayerData(player)).maxStreamingBitrate||(playerData=playerData.streamInfo?playerData.streamInfo.mediaType:null,getSavedMaxStreamingBitrate((player=this.currentItem(player))?_connectionmanager.default.getApiClient(player):_connectionmanager.default.currentApiClient(),playerData))},PlaybackManager.prototype.enableAutomaticBitrateDetection=function(player){var playerData;return(player=player||this._currentPlayer)&&player.enableAutomaticBitrateDetection?player.enableAutomaticBitrateDetection():(playerData=(playerData=getPlayerData(player)).streamInfo?playerData.streamInfo.mediaType:null,player=((player=this.currentItem(player))?_connectionmanager.default.getApiClient(player):_connectionmanager.default.currentApiClient()).getSavedEndpointInfo()||{},_appsettings.default.enableAutomaticBitrateDetection(player.NetworkType,playerData))},PlaybackManager.prototype.isFullscreen=function(player){return!(player=player||this._currentPlayer).isLocalPlayer||player.isFullscreen?player.isFullscreen():_servicelocator.fullscreenManager.isFullScreen()},PlaybackManager.prototype.toggleFullscreen=function(player){return!(player=player||this._currentPlayer)||player.isLocalPlayer&&!player.toggleFullscreen?_servicelocator.fullscreenManager.isFullScreen()?_servicelocator.fullscreenManager.exitFullscreen():_servicelocator.fullscreenManager.requestFullscreen():player.toggleFullscreen()},PlaybackManager.prototype.togglePictureInPicture=function(player){return(player=player||this._currentPlayer).togglePictureInPicture()},PlaybackManager.prototype.isPictureInPictureEnabled=function(player){return!!(player=player||this._currentPlayer).isPictureInPictureEnabled&&player.isPictureInPictureEnabled()},PlaybackManager.prototype.getSubtitleStreamIndex=function(player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.getSubtitleStreamIndex();if(player)return getPlayerData(player).subtitleStreamIndex;throw new Error("player cannot be null")},PlaybackManager.prototype.getSubtitleStream=function(player){player=player||this._currentPlayer;var index=this.getSubtitleStreamIndex(player);return null==index||-1===index?null:getSubtitleStream(this,player,index)},PlaybackManager.prototype.seekRelative=function(offsetTicks,player){return(player=player||this._currentPlayer)&&player.seekRelative&&(!enableLocalPlaylistManagement(player)||player.isLocalPlayer&&canPlayerSeek(this,player))?player.isLocalPlayer?player.seekRelative((offsetTicks||0)/1e4):player.seekRelative(offsetTicks):(offsetTicks=getCurrentTicks(player)+offsetTicks,this.seek(offsetTicks,player))},PlaybackManager.prototype.isBackgroundPlayback=function(player){return(player=player||this._currentPlayer).isLocalPlayer&&this._isBackgroundPlaybackHack},PlaybackManager.prototype.getPlayerState=function(player,item,mediaSource){if(!(player=player||this._currentPlayer))throw new Error("player cannot be null");if(!enableLocalPlaylistManagement(player)&&player.getPlayerState)return player.getPlayerState();item=item||this.currentItem(player),mediaSource=mediaSource||this.currentMediaSource(player);var state={PlayState:{}},currentPlayOptions=item?item.playOptions:null;return state.IsBackgroundPlayback=currentPlayOptions?!1===currentPlayOptions.fullscreen:this._isBackgroundPlaybackHack,player.isLocalPlayer&&(currentPlayOptions=getPlayerData(player).streamInfo)&&(state.IsInitialRequest=currentPlayOptions.isInitialRequest),player&&(state.PlayState.VolumeLevel=player.getVolume(),state.PlayState.IsMuted=player.isMuted(),state.PlayState.IsBackgroundPlayback=state.IsBackgroundPlayback,state.PlayState.IsPaused=player.paused(),state.PlayState.RepeatMode=this.getRepeatMode(player),state.PlayState.SleepTimerMode=this.getSleepTimerMode(player),state.PlayState.SleepTimerEndTime=this.getSleepTimerEndTime(player),state.PlayState.Shuffle=this.getShuffle(player),state.PlayState.SubtitleOffset=this.getSubtitleOffset(player),state.PlayState.PlaybackRate=this.getPlaybackRate(player),state.PlayState.MaxStreamingBitrate=this.getMaxStreamingBitrate(player),state.PlayState.PositionTicks=getCurrentTicks(player),state.PlayState.PlaybackStartTimeTicks=this.playbackStartTime(player),state.PlayState.SubtitleStreamIndex=this.getSubtitleStreamIndex(player),state.PlayState.AudioStreamIndex=this.getAudioStreamIndex(player),state.PlayState.BufferedRanges=this.getBufferedRanges(player),state.PlayState.SeekableRanges=this.getSeekableRanges(player),state.PlayState.PlayMethod=this.playMethod(player),mediaSource&&(state.PlayState.LiveStreamId=mediaSource.LiveStreamId),state.PlayState.PlaySessionId=this.playSessionId(player),state.PlaylistItemId=this.getCurrentPlaylistItemId(player),state.PlaylistIndex=this.getCurrentPlaylistIndex(player),state.PlaylistLength=this.getCurrentPlaylistLength(player)),mediaSource&&(state.PlayState.MediaSourceId=mediaSource.Id,state.NowPlayingItem={RunTimeTicks:mediaSource.RunTimeTicks,Container:mediaSource.Container,Bitrate:mediaSource.Bitrate}),state.PlayState.CanSeek=0<((null==mediaSource?void 0:mediaSource.RunTimeTicks)||0)||canPlayerSeek(this,player),item&&(state.NowPlayingItem=function(player,item,mediaSource){var nowPlayingItem=Object.assign({},item);return nowPlayingItem.playOptions=null,delete nowPlayingItem.playOptions,mediaSource&&(nowPlayingItem.RunTimeTicks=mediaSource.RunTimeTicks,nowPlayingItem.MediaStreams=mediaSource.MediaStreams,nowPlayingItem.Chapters=mediaSource.Chapters||item.Chapters,nowPlayingItem.Container=mediaSource.Container,nowPlayingItem.Bitrate=mediaSource.Bitrate,nowPlayingItem.MediaSources=null,delete nowPlayingItem.MediaSources),nowPlayingItem.RunTimeTicks||(item=player.duration())&&(nowPlayingItem.RunTimeTicks=1e4*item),nowPlayingItem}(player,item,mediaSource)),state.MediaSource=mediaSource,state},PlaybackManager.prototype.duration=function(player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)&&!player.isLocalPlayer)return player.duration();var mediaSource;if(player)return(mediaSource=this.currentMediaSource(player))&&mediaSource.RunTimeTicks?mediaSource.RunTimeTicks:((mediaSource=player.duration())&&(mediaSource*=1e4),mediaSource);throw new Error("player cannot be null")},PlaybackManager.prototype.getCurrentTicks=getCurrentTicks,PlaybackManager.prototype.setCurrentPlaylistItem=function(playlistItemId,player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.setCurrentPlaylistItem(playlistItemId);for(var newItem,newItemIndex,playlist=this._playQueueManager.getPlaylist(),i=0,length=playlist.length;i<length;i++)if(playlist[i].PlaylistItemId===playlistItemId){newItem=playlist[i],newItemIndex=i;break}return newItem?this.setCurrentPlaylistItemAndIndex(newItem,newItemIndex,player):Promise.reject()},PlaybackManager.prototype.removeFromPlaylist=function(playlistItemIds,player){var removeResult;if(playlistItemIds)return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.removeFromPlaylist(playlistItemIds):"empty"===(removeResult=this._playQueueManager.removeFromPlaylist(playlistItemIds)).result?this.stop(player):(removeResult=removeResult.isCurrentIndex,_events.default.trigger(player,"playlistitemremove",[{PlaylistItemIds:playlistItemIds}]),removeResult?this.setCurrentPlaylistItem(this._playQueueManager.getPlaylist()[0].PlaylistItemId,player):Promise.resolve());throw new Error("Invalid playlistItemIds")},PlaybackManager.prototype.movePlaylistItem=function(playlistItemId,newIndex,player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.movePlaylistItem(playlistItemId,newIndex):("noop"!==(playlistItemId=this._playQueueManager.movePlaylistItem(playlistItemId,newIndex)).result&&_events.default.trigger(player,"playlistitemmove",[{playlistItemId:playlistItemId.playlistItemId,newIndex:playlistItemId.newIndex}]),Promise.resolve())},PlaybackManager.prototype.getCurrentPlaylistIndex=function(player){return((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player:this._playQueueManager).getCurrentPlaylistIndex()},PlaybackManager.prototype.getCurrentPlaylistLength=function(player){return((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player:this._playQueueManager).getCurrentPlaylistLength()},PlaybackManager.prototype.getCurrentPlaylistItemId=function(player){return((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player:this._playQueueManager).getCurrentPlaylistItemId()},PlaybackManager.prototype.channelUp=function(player){return player=player||this._currentPlayer,this.nextTrack(player)},PlaybackManager.prototype.channelDown=function(player){return player=player||this._currentPlayer,this.previousTrack(player)},PlaybackManager.prototype.nextTrack=function(player){var newItemInfo;return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.nextTrack():(newItemInfo=this._playQueueManager.getNextItemInfo())?(console.log("playing next track"),this.setCurrentPlaylistItemAndIndex(newItemInfo.item,newItemInfo.index,player)):Promise.resolve()},PlaybackManager.prototype.previousTrack=function(player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.previousTrack();var newIndex=this.getCurrentPlaylistIndex(player)-1;if(0<=newIndex){var newItem=this._playQueueManager.getPlaylist()[newIndex];if(newItem)return this.setCurrentPlaylistItemAndIndex(newItem,newIndex,player)}return Promise.resolve()},PlaybackManager.prototype.queue=function(options,player){return queue(this,options,"",player)},PlaybackManager.prototype.queueNext=function(options,player){return queue(this,options,"next",player)},PlaybackManager.prototype.onControllingAppConnected=function(){var player=this._currentPlayer;player&&this.isPlaying(player)&&sendProgressUpdate(this,player,"controllerconnected",!0)},PlaybackManager.prototype.getPlaybackMediaSources=function(item,options){var startPosition=(options=options||{}).startPositionTicks||0,mediaType=options.mediaType||item.MediaType,player=getPlayer(this,item,options,!0),apiClient=_connectionmanager.default.getApiClient(item),options=_apiclient.default.isLocalItem(item)?Promise.resolve({NetworkType:"lan"}):apiClient.getEndpointInfo();return Promise.all([options,getDeviceProfile(player,item)]).then(function(responses){var endpointInfo=responses[0],responses=responses[1],maxBitrate=getSavedMaxStreamingBitrate(_connectionmanager.default.getApiClient(item),mediaType),endpointInfo=_appsettings.default.enableAutomaticBitrateDetection(endpointInfo.NetworkType,mediaType);return getPlaybackInfo(player,apiClient,item,responses,maxBitrate,endpointInfo,startPosition,!1,null,null,null,null,null).then(function(playbackInfoResult){return playbackInfoResult.MediaSources})})},PlaybackManager.prototype.playbackStartTime=function(player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.playbackStartTime?player.playbackStartTime():null:(player=getPlayerData(player).streamInfo)?player.playbackStartTimeTicks:null},PlaybackManager.prototype.toggleAspectRatio=function(player){if(player=player||this._currentPlayer){for(var current=this.getAspectRatio(player),supported=this.getSupportedAspectRatios(player),index=-1,i=0,length=supported.length;i<length;i++)if(supported[i].id===current){index=i;break}++index>=supported.length&&(index=0),this.setAspectRatio(supported[index].id,player)}},PlaybackManager.prototype.setAspectRatio=function(val,player){(player=player||this._currentPlayer)&&player.setAspectRatio&&player.setAspectRatio(val)},PlaybackManager.prototype.getSupportedAspectRatios=function(player){return(player=player||this._currentPlayer)&&player.getSupportedAspectRatios?player.getSupportedAspectRatios():[]},PlaybackManager.prototype.getAspectRatio=function(player){if((player=player||this._currentPlayer)&&player.getAspectRatio)return player.getAspectRatio()},PlaybackManager.prototype.setBrightness=function(val,player){(player=player||this._currentPlayer)&&player.setBrightness(val)},PlaybackManager.prototype.getBrightness=function(player){if(player=player||this._currentPlayer)return player.getBrightness()},PlaybackManager.prototype.setVolume=function(val,player){(player=player||this._currentPlayer)&&player.setVolume(val)},PlaybackManager.prototype.getVolume=function(player){if(player=player||this._currentPlayer)return player.getVolume()},PlaybackManager.prototype.volumeUp=function(player){(player=player||this._currentPlayer)&&player.volumeUp()},PlaybackManager.prototype.volumeDown=function(player){(player=player||this._currentPlayer)&&player.volumeDown()},PlaybackManager.prototype.sendAbortSignal=function(){var controller=this._abortController;controller&&(this._abortController=null,controller.abort())},PlaybackManager.prototype.newAbortSignal=function(){this.sendAbortSignal();var controller=new AbortController;return(this._abortController=controller).signal},PlaybackManager.prototype.getCurrentPlayer=function(){return this._currentPlayer},PlaybackManager.prototype.currentTime=function(player){return!(player=player||this._currentPlayer)||enableLocalPlaylistManagement(player)||player.isLocalPlayer?this.getCurrentTicks(player):player.currentTime()},PlaybackManager.prototype.nextItem=function(player){var apiClient;return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.nextItem():(player=this._playQueueManager.getNextItemInfo())&&player.item?(apiClient=_connectionmanager.default.getApiClient(player.item)).getItem(apiClient.getCurrentUserId(),player.item.Id,{ExcludeFields:"VideoChapters,VideoMediaSources,MediaStreams,People,Overview"}):Promise.reject()},PlaybackManager.prototype.canQueue=function(item){if(this._currentPlayer)switch(item.Type){case"Program":case"TvChannel":return!1;case"MusicAlbum":case"MusicArtist":return this.canPlay(item)&&this.canQueueMediaType("Audio");default:return this.canPlay(item)&&canPlayerPlayMediaType(this._currentPlayer,item.MediaType)}return!1},PlaybackManager.prototype.canQueueMediaType=function(mediaType){return!!this._currentPlayer&&canPlayerPlayMediaType(this._currentPlayer,mediaType)},PlaybackManager.prototype.isMuted=function(player){return!!(player=player||this._currentPlayer)&&player.isMuted()},PlaybackManager.prototype.setMute=function(mute,player){(player=player||this._currentPlayer)&&player.setMute(mute)},PlaybackManager.prototype.toggleMute=function(mute,player){(player=player||this._currentPlayer)&&(player.toggleMute?player.toggleMute():player.setMute(!player.isMuted()))},PlaybackManager.prototype.nextChapter=function(player){player=player||this._currentPlayer;var ticks=this.getCurrentTicks(player),nextChapter=(this.currentMediaSource(player).Chapters||this.currentItem(player).Chapters||[]).filter(function(i){return i.StartPositionTicks>ticks})[0];nextChapter?this.seek(nextChapter.StartPositionTicks,player):this.nextTrack(player)},PlaybackManager.prototype.previousChapter=function(player){player=player||this._currentPlayer;var ticks=this.getCurrentTicks(player);ticks-=1e8,0===this.getCurrentPlaylistIndex(player)&&(ticks=Math.max(ticks,0));var previousChapters=(this.currentMediaSource(player).Chapters||this.currentItem(player).Chapters||[]).filter(function(i){return i.StartPositionTicks<=ticks});previousChapters.length?this.seek(previousChapters[previousChapters.length-1].StartPositionTicks,player):this.previousTrack(player)},PlaybackManager.prototype.fastForward=function(player){player=player||this._currentPlayer;var offsetTicks=1e4*_usersettings.default.skipForwardLength();this.seekRelative(offsetTicks,player)},PlaybackManager.prototype.rewind=function(player){player=player||this._currentPlayer;var offsetTicks=0-1e4*_usersettings.default.skipBackLength();this.seekRelative(offsetTicks,player)},PlaybackManager.prototype.frameStepForward=function(player){var offsetTicks=getFrameTicks((player=player||this._currentPlayer).streamInfo);offsetTicks&&this.seekRelative(offsetTicks+=1e4,player)},PlaybackManager.prototype.frameStepBack=function(player){var offsetTicks=getFrameTicks((player=player||this._currentPlayer).streamInfo);offsetTicks&&this.seekRelative(-1*(offsetTicks+=1e4),player)},PlaybackManager.prototype.seekPercent=function(percent,player){player=player||this._currentPlayer,console.log("seeking to "+percent+"%");var ticks=this.duration(player)||0;ticks*=percent/=100,ticks=parseInt(ticks),console.log("seeking to "+ticks+" ticks"),this.seek(ticks,player)},PlaybackManager.prototype.playTrailers=function(item){var instance,player=this._currentPlayer;return player&&player.playTrailers?player.playTrailers(item):(player=_connectionmanager.default.getApiClient(item),instance=this,player.getAllTrailers({LocalTrailers:0<(item.LocalTrailerCount||0),RemoteTrailers:0===(item.LocalTrailerCount||0)},item).then(function(result){return instance.play({items:result.Items})}))},PlaybackManager.prototype.getSubtitleUrl=function(textStream,serverId){serverId=_connectionmanager.default.getApiClient(serverId);return textStream.IsExternalUrl?textStream.DeliveryUrl:serverId.getUrl(textStream.DeliveryUrl)},PlaybackManager.prototype.stop=function(player){return player=player||this._currentPlayer,this.sendAbortSignal(),player?(enableLocalPlaylistManagement(player)&&this._playQueueManager.reset(),player.stop(!0)):Promise.resolve()},PlaybackManager.prototype.getBufferedRanges=function(player){return(player=player||this._currentPlayer)&&player.getBufferedRanges?player.getBufferedRanges():[]},PlaybackManager.prototype.getSeekableRanges=function(player){return(player=player||this._currentPlayer)&&player.getSeekableRanges?player.getSeekableRanges():[]},PlaybackManager.prototype.playPause=function(player){if(player=player||this._currentPlayer)return player.playPause?player.playPause():player.paused()?this.unpause(player):this.pause(player)},PlaybackManager.prototype.paused=function(player){if(player=player||this._currentPlayer)return player.paused()},PlaybackManager.prototype.pause=function(player){(player=player||this._currentPlayer)&&player.pause()},PlaybackManager.prototype.unpause=function(player){(player=player||this._currentPlayer)&&player.unpause()},PlaybackManager.prototype.instantMix=function(item,player){var options,instance;return(player=player||this._currentPlayer)&&player.instantMix?player.instantMix(item):(player=_connectionmanager.default.getApiClient(item),(options={}).UserId=player.getCurrentUserId(),options.Limit=5e3,instance=this,player.getInstantMixFromItem(item.Id,options).then(function(result){return instance.play({items:result.Items})}))},PlaybackManager.prototype.shuffle=function(shuffleItem,player,queryOptions){return(player=player||this._currentPlayer)&&player.shuffle?player.shuffle(shuffleItem):((queryOptions=queryOptions||{}).items=[shuffleItem],queryOptions.shuffle=!0,this.play(queryOptions))},PlaybackManager.prototype.audioTracks=function(player){if((player=player||this._currentPlayer).audioTracks){var result=player.audioTracks();if(result)return result}result=this.currentMediaSource(player);return((null==result?void 0:result.MediaStreams)||[]).filter(function(s){return"Audio"===s.Type})},PlaybackManager.prototype.subtitleTracks=function(player){if((player=player||this._currentPlayer).subtitleTracks){var result=player.subtitleTracks();if(result)return result}result=this.currentMediaSource(player);return((null==result?void 0:result.MediaStreams)||[]).filter(function(s){return"Subtitle"===s.Type})},PlaybackManager.prototype.getSupportedCommands=function(player){var list,forceSupportVolume;return!(player=player||this._currentPlayer)||player.isLocalPlayer?(list=["GoHome","GoToSettings","SetAudioStreamIndex","SetSubtitleStreamIndex","RefreshMediaSource","SetMaxStreamingBitrate","DisplayContent","GoToSearch","DisplayMessage","TriggerTranscodingFallback","SetRepeatMode","SetShuffle","PlayMediaSource","PlayTrailers"],_servicelocator.appHost.supports("fullscreenchange")&&list.push("ToggleFullscreen"),_servicelocator.appHost.supports("sleeptimer")&&list.push("SetSleepTimer"),null!=player&&player.supports&&(forceSupportVolume="libmpvmediaplayer"===(null==player?void 0:player.id),(player.supports("VolumeUp")||forceSupportVolume)&&list.push("VolumeUp"),(player.supports("VolumeDown")||forceSupportVolume)&&list.push("VolumeDown"),(player.supports("Mute")||forceSupportVolume)&&list.push("Mute"),(player.supports("Unmute")||forceSupportVolume)&&list.push("Unmute"),(player.supports("ToggleMute")||forceSupportVolume)&&list.push("ToggleMute"),(player.supports("SetVolume")||forceSupportVolume)&&list.push("SetVolume"),player.supports("PictureInPicture")&&list.push("PictureInPicture"),player.supports("AutoPictureInPicture")&&list.push("AutoPictureInPicture"),player.supports("SetBrightness")&&list.push("SetBrightness"),player.supports("SetAspectRatio")&&list.push("SetAspectRatio"),player.supports("SetSubtitleOffset")&&list.push("SetSubtitleOffset"),player.supports("SetSubtitleAppearance")&&list.push("SetSubtitleAppearance"),player.supports("SetPlaybackRate"))&&list.push("SetPlaybackRate"),list):(forceSupportVolume=this.getPlayerInfo(player))?forceSupportVolume.supportedCommands:[]},PlaybackManager.prototype.toggleRepeatMode=function(player){switch(player=player||this._currentPlayer,this.getRepeatMode(player)){case"RepeatNone":this.setRepeatMode("RepeatAll",player);break;case"RepeatAll":this.setRepeatMode("RepeatOne",player);break;case"RepeatOne":this.setRepeatMode("RepeatNone",player)}},PlaybackManager.prototype.setRepeatMode=function(value,player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.setRepeatMode(value);this._playQueueManager.setRepeatMode(value),_events.default.trigger(player,"repeatmodechange")},PlaybackManager.prototype.getRepeatMode=function(player){return((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player:this._playQueueManager).getRepeatMode()},PlaybackManager.prototype.setSleepTimer=function(options,player){var playerData;return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.setSleepTimer(options):((playerData=getPlayerData(player)).sleepTimerMode=options.sleepTimerMode||"None",(options=options.sleepTimerEndTime)&&"string"==typeof options&&(options=_datetime.default.parseISO8601Date(options)),playerData.sleepTimerEndTime=options,_events.default.trigger(player,"sleeptimerchange"),Promise.resolve())},PlaybackManager.prototype.onSleepTimerFired=function(player){player=player||this._currentPlayer,this.setSleepTimer({sleepTimerMode:"None"},player),this.pause(player)},PlaybackManager.prototype.getSleepTimerMode=function(player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.getSleepTimerMode():getPlayerData(player).sleepTimerMode||"None"},PlaybackManager.prototype.getSleepTimerEndTime=function(player){return(player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player.getSleepTimerEndTime():getPlayerData(player).sleepTimerEndTime},PlaybackManager.prototype.toggleShuffle=function(player){player=player||this._currentPlayer,this.setShuffle(!this.getShuffle(player),player)},PlaybackManager.prototype.setShuffle=function(value,player){if((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player))return player.setShuffle(value);this._playQueueManager.setShuffle(value),_events.default.trigger(player,"shufflechange")},PlaybackManager.prototype.getShuffle=function(player){return((player=player||this._currentPlayer)&&!enableLocalPlaylistManagement(player)?player:this._playQueueManager).getShuffle()},PlaybackManager.prototype.setSubtitleOffset=function(value,player){(player=player||this._currentPlayer).setSubtitleOffset&&(player.setSubtitleOffset(value),_events.default.trigger(player,"subtitleoffsetchange"))},PlaybackManager.prototype.incrementSubtitleOffset=function(value,player){(player=player||this._currentPlayer).incrementSubtitleOffset&&(player.incrementSubtitleOffset(value),_events.default.trigger(player,"subtitleoffsetchange"))},PlaybackManager.prototype.getSubtitleOffset=function(player){return(player=player||this._currentPlayer).getSubtitleOffset?player.getSubtitleOffset():0},PlaybackManager.prototype.getPlaybackRate=function(player){return(player=player||this._currentPlayer).getPlaybackRate?player.getPlaybackRate():1},PlaybackManager.prototype.setPlaybackRate=function(value,player){(player=player||this._currentPlayer).setPlaybackRate&&player.setPlaybackRate(value)},PlaybackManager.prototype.trySetActiveDeviceName=function(name){name=normalizeName(name);var instance=this;instance.getTargets().then(function(result){result=result.filter(function(p){return normalizeName(p.name)===name})[0];result&&instance.trySetActivePlayer(result.playerName,result)})},PlaybackManager.prototype.displayContent=function(options,player){(player=player||this._currentPlayer)&&player.displayContent&&player.displayContent(options)},PlaybackManager.prototype.beginPlayerUpdates=function(player){player.beginPlayerUpdates&&player.beginPlayerUpdates()},PlaybackManager.prototype.endPlayerUpdates=function(player){player.endPlayerUpdates&&player.endPlayerUpdates()},PlaybackManager.prototype.setDefaultPlayerActive=function(){this.setActivePlayer("localplayer")},PlaybackManager.prototype.removeActivePlayer=function(name){var playerInfo=this.getPlayerInfo();playerInfo&&playerInfo.playerName===name&&this.setDefaultPlayerActive()},PlaybackManager.prototype.removeActiveTarget=function(id){var playerInfo=this.getPlayerInfo();playerInfo&&playerInfo.id===id&&this.setDefaultPlayerActive()},PlaybackManager.prototype.sendCommand=function(cmd,player){switch(console.log("MediaController received command: "+cmd.Name),cmd.Name){case"SetPlaybackRate":this.setPlaybackRate(parseFloat(cmd.Arguments.PlaybackRate),player);break;case"SetSubtitleOffset":this.setSubtitleOffset(parseFloat(cmd.Arguments.SubtitleOffset),player);break;case"IncrementSubtitleOffset":this.incrementSubtitleOffset(parseFloat(cmd.Arguments.Increment),player);break;case"TriggerTranscodingFallback":this.triggerTranscodingFallback(player);break;case"SetRepeatMode":this.setRepeatMode(cmd.Arguments.RepeatMode,player);break;case"SetSleepTimer":this.setSleepTimer(cmd.Arguments||{},player);break;case"SetShuffle":var shuffle=cmd.Arguments.Shuffle;this.setShuffle(!0===shuffle||"true"===(shuffle||"").toString().toLowerCase(),player);break;case"VolumeUp":this.volumeUp(player);break;case"VolumeDown":this.volumeDown(player);break;case"Mute":this.setMute(!0,player);break;case"Unmute":this.setMute(!1,player);break;case"ToggleMute":this.toggleMute(player);break;case"SetVolume":this.setVolume(cmd.Arguments.Volume,player);break;case"SetAspectRatio":this.setAspectRatio(cmd.Arguments.AspectRatio,player);break;case"SetBrightness":this.setBrightness(cmd.Arguments.Brightness,player);break;case"SetAudioStreamIndex":this.setAudioStreamIndex(parseInt(cmd.Arguments.Index),player);break;case"SetSubtitleStreamIndex":this.setSubtitleStreamIndex(parseInt(cmd.Arguments.Index),player,cmd.Arguments.RefreshMediaSource);break;case"SetMaxStreamingBitrate":break;case"ToggleFullscreen":this.toggleFullscreen(player);break;default:player.sendCommand&&player.sendCommand(cmd)}};_exports.default=new PlaybackManager});