﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentityRequest.h>
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/chime-sdk-identity/model/Configuration.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKIdentity {
namespace Model {

/**
 */
class UpdateAppInstanceBotRequest : public ChimeSDKIdentityRequest {
 public:
  AWS_CHIMESDKIDENTITY_API UpdateAppInstanceBotRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateAppInstanceBot"; }

  AWS_CHIMESDKIDENTITY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the <code>AppInstanceBot</code>.</p>
   */
  inline const Aws::String& GetAppInstanceBotArn() const { return m_appInstanceBotArn; }
  inline bool AppInstanceBotArnHasBeenSet() const { return m_appInstanceBotArnHasBeenSet; }
  template <typename AppInstanceBotArnT = Aws::String>
  void SetAppInstanceBotArn(AppInstanceBotArnT&& value) {
    m_appInstanceBotArnHasBeenSet = true;
    m_appInstanceBotArn = std::forward<AppInstanceBotArnT>(value);
  }
  template <typename AppInstanceBotArnT = Aws::String>
  UpdateAppInstanceBotRequest& WithAppInstanceBotArn(AppInstanceBotArnT&& value) {
    SetAppInstanceBotArn(std::forward<AppInstanceBotArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the <code>AppInstanceBot</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateAppInstanceBotRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata of the <code>AppInstanceBot</code>.</p>
   */
  inline const Aws::String& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Aws::String>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::String>
  UpdateAppInstanceBotRequest& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration for the bot update.</p>
   */
  inline const Configuration& GetConfiguration() const { return m_configuration; }
  inline bool ConfigurationHasBeenSet() const { return m_configurationHasBeenSet; }
  template <typename ConfigurationT = Configuration>
  void SetConfiguration(ConfigurationT&& value) {
    m_configurationHasBeenSet = true;
    m_configuration = std::forward<ConfigurationT>(value);
  }
  template <typename ConfigurationT = Configuration>
  UpdateAppInstanceBotRequest& WithConfiguration(ConfigurationT&& value) {
    SetConfiguration(std::forward<ConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceBotArn;

  Aws::String m_name;

  Aws::String m_metadata;

  Configuration m_configuration;
  bool m_appInstanceBotArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_metadataHasBeenSet = false;
  bool m_configurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
