﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>
#include <aws/redshift/model/UsageLimit.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DescribeUsageLimitsResult {
 public:
  AWS_REDSHIFT_API DescribeUsageLimitsResult() = default;
  AWS_REDSHIFT_API DescribeUsageLimitsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DescribeUsageLimitsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Contains the output from the <a>DescribeUsageLimits</a> action. </p>
   */
  inline const Aws::Vector<UsageLimit>& GetUsageLimits() const { return m_usageLimits; }
  template <typename UsageLimitsT = Aws::Vector<UsageLimit>>
  void SetUsageLimits(UsageLimitsT&& value) {
    m_usageLimitsHasBeenSet = true;
    m_usageLimits = std::forward<UsageLimitsT>(value);
  }
  template <typename UsageLimitsT = Aws::Vector<UsageLimit>>
  DescribeUsageLimitsResult& WithUsageLimits(UsageLimitsT&& value) {
    SetUsageLimits(std::forward<UsageLimitsT>(value));
    return *this;
  }
  template <typename UsageLimitsT = UsageLimit>
  DescribeUsageLimitsResult& AddUsageLimits(UsageLimitsT&& value) {
    m_usageLimitsHasBeenSet = true;
    m_usageLimits.emplace_back(std::forward<UsageLimitsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value that indicates the starting point for the next set of response
   * records in a subsequent request. If a value is returned in a response, you can
   * retrieve the next set of records by providing this returned marker value in the
   * <code>Marker</code> parameter and retrying the command. If the
   * <code>Marker</code> field is empty, all response records have been retrieved for
   * the request. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeUsageLimitsResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeUsageLimitsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<UsageLimit> m_usageLimits;

  Aws::String m_marker;

  ResponseMetadata m_responseMetadata;
  bool m_usageLimitsHasBeenSet = false;
  bool m_markerHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
