﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medical-imaging/MedicalImaging_EXPORTS.h>
#include <aws/medical-imaging/model/ImageSetState.h>
#include <aws/medical-imaging/model/ImageSetWorkflowStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MedicalImaging {
namespace Model {
class UpdateImageSetMetadataResult {
 public:
  AWS_MEDICALIMAGING_API UpdateImageSetMetadataResult() = default;
  AWS_MEDICALIMAGING_API UpdateImageSetMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDICALIMAGING_API UpdateImageSetMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The data store identifier.</p>
   */
  inline const Aws::String& GetDatastoreId() const { return m_datastoreId; }
  template <typename DatastoreIdT = Aws::String>
  void SetDatastoreId(DatastoreIdT&& value) {
    m_datastoreIdHasBeenSet = true;
    m_datastoreId = std::forward<DatastoreIdT>(value);
  }
  template <typename DatastoreIdT = Aws::String>
  UpdateImageSetMetadataResult& WithDatastoreId(DatastoreIdT&& value) {
    SetDatastoreId(std::forward<DatastoreIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The image set identifier.</p>
   */
  inline const Aws::String& GetImageSetId() const { return m_imageSetId; }
  template <typename ImageSetIdT = Aws::String>
  void SetImageSetId(ImageSetIdT&& value) {
    m_imageSetIdHasBeenSet = true;
    m_imageSetId = std::forward<ImageSetIdT>(value);
  }
  template <typename ImageSetIdT = Aws::String>
  UpdateImageSetMetadataResult& WithImageSetId(ImageSetIdT&& value) {
    SetImageSetId(std::forward<ImageSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest image set version identifier.</p>
   */
  inline const Aws::String& GetLatestVersionId() const { return m_latestVersionId; }
  template <typename LatestVersionIdT = Aws::String>
  void SetLatestVersionId(LatestVersionIdT&& value) {
    m_latestVersionIdHasBeenSet = true;
    m_latestVersionId = std::forward<LatestVersionIdT>(value);
  }
  template <typename LatestVersionIdT = Aws::String>
  UpdateImageSetMetadataResult& WithLatestVersionId(LatestVersionIdT&& value) {
    SetLatestVersionId(std::forward<LatestVersionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The image set state.</p>
   */
  inline ImageSetState GetImageSetState() const { return m_imageSetState; }
  inline void SetImageSetState(ImageSetState value) {
    m_imageSetStateHasBeenSet = true;
    m_imageSetState = value;
  }
  inline UpdateImageSetMetadataResult& WithImageSetState(ImageSetState value) {
    SetImageSetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The image set workflow status.</p>
   */
  inline ImageSetWorkflowStatus GetImageSetWorkflowStatus() const { return m_imageSetWorkflowStatus; }
  inline void SetImageSetWorkflowStatus(ImageSetWorkflowStatus value) {
    m_imageSetWorkflowStatusHasBeenSet = true;
    m_imageSetWorkflowStatus = value;
  }
  inline UpdateImageSetMetadataResult& WithImageSetWorkflowStatus(ImageSetWorkflowStatus value) {
    SetImageSetWorkflowStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when image set metadata was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  UpdateImageSetMetadataResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when image set metadata was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  UpdateImageSetMetadataResult& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message thrown if an update image set metadata action fails.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  UpdateImageSetMetadataResult& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateImageSetMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_datastoreId;

  Aws::String m_imageSetId;

  Aws::String m_latestVersionId;

  ImageSetState m_imageSetState{ImageSetState::NOT_SET};

  ImageSetWorkflowStatus m_imageSetWorkflowStatus{ImageSetWorkflowStatus::NOT_SET};

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_updatedAt{};

  Aws::String m_message;

  Aws::String m_requestId;
  bool m_datastoreIdHasBeenSet = false;
  bool m_imageSetIdHasBeenSet = false;
  bool m_latestVersionIdHasBeenSet = false;
  bool m_imageSetStateHasBeenSet = false;
  bool m_imageSetWorkflowStatusHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_updatedAtHasBeenSet = false;
  bool m_messageHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MedicalImaging
}  // namespace Aws
