/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.generator.PatternContainer;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PatternProcessor {
    public DocumentBuilderFactory documentBuilderFactory_;

    public PatternContainer processPattern(String string, MethodInfo methodInfo) {
        PatternContainer patternContainer = new PatternContainer();
        if (string.startsWith("tableAlias")) {
            string = string.substring(11);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",()");
            while (stringTokenizer.hasMoreTokens()) {
                PatternProcessor.processTableAliasPattern(stringTokenizer.nextToken(), patternContainer);
            }
        } else if (string.startsWith("<rsm>")) {
            this.getDocumentBuilderFactoryInstance();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                DocumentBuilder documentBuilder = this.documentBuilderFactory_.newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                PatternProcessor.processRSMPattern(string, patternContainer, document, methodInfo);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PATTERN", string), parserConfigurationException, 10193, null, methodInfo);
            }
            catch (IOException iOException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PATTERN", string), iOException, 10194, null, methodInfo);
            }
            catch (SAXException sAXException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PATTERN", string), sAXException, 10195, null, methodInfo);
            }
        }
        return patternContainer;
    }

    private void getDocumentBuilderFactoryInstance() {
        if (this.documentBuilderFactory_ == null) {
            this.documentBuilderFactory_ = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory_.setIgnoringElementContentWhitespace(true);
            this.documentBuilderFactory_.setIgnoringComments(true);
        }
    }

    private static PatternContainer processRSMPattern(String string, PatternContainer patternContainer, Document document, MethodInfo methodInfo) {
        Node node = document.getChildNodes().item(0);
        int n2 = node.getChildNodes().getLength();
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        for (int i10 = 0; i10 < n2; ++i10) {
            n3 = 0;
            Node node2 = node.getChildNodes().item(i10);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("col")) continue;
            ++n4;
            if (!node2.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem("bean");
            Node node4 = namedNodeMap.getNamedItem("property");
            Node node5 = namedNodeMap.getNamedItem("number");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (node4 != null) {
                string2 = node4.getNodeValue().toLowerCase().trim();
            }
            if (node3 != null) {
                string3 = node3.getNodeValue().trim();
            }
            if (node5 != null) {
                string4 = node5.getNodeValue().trim();
            }
            if (string4 != null) {
                n3 = Integer.parseInt(string4);
                bl2 = true;
            } else if (string4 == null && bl2) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RSM_PATTERN", new Object[0]), null, 10196, null, methodInfo);
            }
            PatternProcessor.populatePatternContainer(patternContainer, bl2, n4, n3, string2, string3);
        }
        return patternContainer;
    }

    private static void populatePatternContainer(PatternContainer patternContainer, boolean bl2, int n2, int n3, String string, String string2) {
        if (bl2) {
            if (string2 != null) {
                patternContainer.addBeanMappingForRSM(n3, string2);
            }
            if (string != null) {
                patternContainer.addPropertyMappingForRSM(n3, string);
            }
        } else {
            if (string2 != null) {
                patternContainer.addBeanMappingForRSM(n2, string2);
            }
            if (string != null) {
                patternContainer.addPropertyMappingForRSM(n2, string);
            }
        }
    }

    private static void processTableAliasPattern(String string, PatternContainer patternContainer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=>");
            String string2 = stringTokenizer.nextToken().trim().toLowerCase();
            String string3 = stringTokenizer.nextToken().trim().toLowerCase();
            String string4 = string2 + "=>" + string3;
            patternContainer.addTablePattern(string4, string2);
        }
    }
}

