/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNodeGen;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline(value=false)
@GenerateCached
public abstract class CastToListExpressionNode
extends UnaryOpNode {
    @Specialization
    static PList doObject(VirtualFrame frame, Object value, @Cached CastToListNode castToListNode) {
        return castToListNode.execute(frame, value);
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class CastToListNode
    extends Node {
        public abstract PList execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isBuiltinTuple(v)", "cachedLength == getLength(v)", "cachedLength < 32"}, limit="2")
        @ExplodeLoop
        static PList starredTupleCachedLength(PTuple v, @Bind PythonLanguage language, @Cached(value="getLength(v)") int cachedLength, @Cached SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage s = v.getSequenceStorage();
            Object[] array = new Object[cachedLength];
            for (int i = 0; i < cachedLength; ++i) {
                array[i] = getItemNode.execute(s, i);
            }
            return PFactory.createList(language, array);
        }

        @Specialization(replaces={"starredTupleCachedLength"}, guards={"isBuiltinTuple(v)"})
        static PList starredTuple(PTuple v, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            return PFactory.createList(language, (Object[])getObjectArrayNode.execute(inliningTarget, v).clone());
        }

        @Specialization(guards={"isBuiltinList(v)"})
        protected static PList starredList(PList v) {
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(rewriteOn={PException.class})
        static PList starredIterable(VirtualFrame frame, PythonObject value, @Bind Node inliningTarget, @Cached.Shared @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached.Shared @Cached ListNodes.ConstructListNode constructListNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                PList pList = constructListNode.execute((Frame)frame, value);
                return pList;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Specialization
        static PList starredGeneric(VirtualFrame frame, Object v, @Bind Node inliningTarget, @Cached.Shared @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached.Shared @Cached ListNodes.ConstructListNode constructListNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrProfile, @Cached PRaiseNode raise) {
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                PList pList = constructListNode.execute((Frame)frame, v);
                return pList;
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, attrProfile);
                throw raise.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, v);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        protected int getLength(PTuple t) {
            return t.getSequenceStorage().length();
        }

        @NeverDefault
        public static CastToListNode create() {
            return CastToListExpressionNodeGen.CastToListNodeGen.create();
        }
    }

    private static final class CastToListUncachedNode
    extends CastToListInteropNode {
        private static final CastToListUncachedNode UNCACHED = new CastToListUncachedNode();

        private CastToListUncachedNode() {
        }

        @Override
        public PList executeWithGlobalState(Object list) {
            return (PList)CallNode.executeUncached((Object)PythonBuiltinClassType.PList, list);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    private static final class CastToListCachedNode
    extends CastToListInteropNode {
        @Node.Child
        private CastToListNode castToListNode = CastToListNode.create();

        private CastToListCachedNode() {
        }

        @Override
        public PList executeWithGlobalState(Object list) {
            return this.castToListNode.execute(null, list);
        }
    }

    public static abstract class CastToListInteropNode
    extends PNodeWithContext {
        public abstract PList executeWithGlobalState(Object var1);

        @NeverDefault
        public static CastToListInteropNode create() {
            return new CastToListCachedNode();
        }

        public static CastToListInteropNode getUncached() {
            return CastToListUncachedNode.UNCACHED;
        }
    }
}

