/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.Utils;
import com.amazon.redshift.jdbc.MetadataAPIHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.RedshiftException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MetadataServerProxy
extends MetadataAPIHelper {
    public MetadataServerProxy(RedshiftConnectionImpl connection) throws SQLException {
        super(connection);
    }

    protected List<String> getCatalogs() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling SHOW DATABASES", new Object[0]);
        }
        ArrayList<String> intermediateResults = new ArrayList<String>();
        try (PreparedStatement stmt = this.createMetaDataPreparedStatement("SHOW DATABASES;");){
            stmt.execute();
            try (ResultSet rs = stmt.getResultSet();){
                while (rs.next()) {
                    intermediateResults.add(rs.getString("database_name"));
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getCatalogs: " + e.getMessage());
        }
        return intermediateResults;
    }

    protected List<MetadataAPIHelper.ShowSchemasInfo> getSchemas(String catalog, String schemaPattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowSchemasInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowSchemasInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                intermediateRs.addAll(this.callShowSchemas(curCatalog, schemaPattern, true));
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getSchemas: " + e.getMessage());
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog: {0}, schemaPattern: {1}", catalog, schemaPattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ShowTablesInfo> getTables(String catalog, String schemaPattern, String tableNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowTablesInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowTablesInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCat : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCat, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    intermediateRs.addAll(this.callShowTables(curCat, curSchema.getSchemaName(), tableNamePattern, true));
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getTables: " + e.getMessage());
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}", catalog, schemaPattern, tableNamePattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ShowColumnsInfo> getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowColumnsInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowColumnsInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCat : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCat, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    List<MetadataAPIHelper.ShowTablesInfo> tableList = this.callShowTables(curCat, curSchema.getSchemaName(), tableNamePattern, false);
                    for (MetadataAPIHelper.ShowTablesInfo curTable : tableList) {
                        intermediateRs.addAll(this.callShowColumns(curCat, curSchema.getSchemaName(), curTable.getTableName(), columnNamePattern));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getColumns: " + e.getMessage());
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Return intermediate result set for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}, columnNamePattern = {3}", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ShowPrimaryKeysInfo> getPrimaryKeys(String catalog, String schema, String table, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowPrimaryKeysInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowPrimaryKeysInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<Object> schemaList = new ArrayList<MetadataAPIHelper.ShowSchemasInfo>();
                if (Utils.isNullOrEmpty(schema)) {
                    schemaList = this.callShowSchemas(curCatalog, schema, false);
                } else {
                    schemaList.add(new MetadataAPIHelper.ShowSchemasInfo(schema));
                }
                for (MetadataAPIHelper.ShowSchemasInfo showSchemasInfo : schemaList) {
                    List<Object> tableList = new ArrayList<MetadataAPIHelper.ShowTablesInfo>();
                    if (Utils.isNullOrEmpty(table)) {
                        tableList = this.callShowTables(curCatalog, showSchemasInfo.getSchemaName(), table, false);
                    } else {
                        tableList.add(new MetadataAPIHelper.ShowTablesInfo(table));
                    }
                    for (MetadataAPIHelper.ShowTablesInfo showTablesInfo : tableList) {
                        intermediateRs.addAll(this.callShowConstraintsPrimaryKey(curCatalog, showSchemasInfo.getSchemaName(), showTablesInfo.getTableName()));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getPrimaryKeys: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW CONSTRAINTS PRIMARY KEYS for catalog = {0}, schema = {1}, table = {2}", catalog, schema, table);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ShowForeignKeysInfo> getForeignKeys(String catalog, String schema, String table, boolean isSingleDatabaseMetaData, boolean isImported) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowForeignKeysInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowForeignKeysInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<Object> schemaList = new ArrayList<MetadataAPIHelper.ShowSchemasInfo>();
                if (Utils.isNullOrEmpty(schema)) {
                    schemaList = this.callShowSchemas(curCatalog, schema, false);
                } else {
                    schemaList.add(new MetadataAPIHelper.ShowSchemasInfo(schema));
                }
                for (MetadataAPIHelper.ShowSchemasInfo showSchemasInfo : schemaList) {
                    List<Object> tableList = new ArrayList<MetadataAPIHelper.ShowTablesInfo>();
                    if (Utils.isNullOrEmpty(table)) {
                        tableList = this.callShowTables(curCatalog, showSchemasInfo.getSchemaName(), table, false);
                    } else {
                        tableList.add(new MetadataAPIHelper.ShowTablesInfo(table));
                    }
                    for (MetadataAPIHelper.ShowTablesInfo showTablesInfo : tableList) {
                        String sql = isImported ? "SHOW CONSTRAINTS FOREIGN KEYS FROM TABLE ?.?.?;" : "SHOW CONSTRAINTS FOREIGN KEYS EXPORTED FROM TABLE ?.?.?;";
                        intermediateRs.addAll(this.callShowConstraintsForeignKey(curCatalog, showSchemasInfo.getSchemaName(), showTablesInfo.getTableName(), sql));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getForeignKeys: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW CONSTRAINTS FOREIGN KEYS for catalog = {0}, schema = {1}, table = {2}", catalog, schema, table);
        }
        return intermediateRs;
    }

    public List<MetadataAPIHelper.BestRowIdenData> getBestRowIdentifier(String catalog, String schema, String table, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.BestRowIdenData> intermediateRs = new ArrayList<MetadataAPIHelper.BestRowIdenData>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<Object> schemaList = new ArrayList<MetadataAPIHelper.ShowSchemasInfo>();
                if (Utils.isNullOrEmpty(schema)) {
                    schemaList = this.callShowSchemas(curCatalog, schema, false);
                } else {
                    schemaList.add(new MetadataAPIHelper.ShowSchemasInfo(schema));
                }
                for (MetadataAPIHelper.ShowSchemasInfo showSchemasInfo : schemaList) {
                    List<Object> tableList = new ArrayList<MetadataAPIHelper.ShowTablesInfo>();
                    if (Utils.isNullOrEmpty(table)) {
                        tableList = this.callShowTables(curCatalog, showSchemasInfo.getSchemaName(), table, false);
                    } else {
                        tableList.add(new MetadataAPIHelper.ShowTablesInfo(table));
                    }
                    for (MetadataAPIHelper.ShowTablesInfo showTablesInfo : tableList) {
                        List<MetadataAPIHelper.ShowPrimaryKeysInfo> showConstraintRs = this.callShowConstraintsPrimaryKey(curCatalog, showSchemasInfo.getSchemaName(), showTablesInfo.getTableName());
                        HashSet<String> pkColumnSet = new HashSet<String>();
                        for (MetadataAPIHelper.ShowPrimaryKeysInfo curPrimaryKey : showConstraintRs) {
                            pkColumnSet.add(curPrimaryKey.getColumnName());
                        }
                        if (pkColumnSet.isEmpty()) continue;
                        intermediateRs.add(new MetadataAPIHelper.BestRowIdenData(this.callShowColumns(curCatalog, showSchemasInfo.getSchemaName(), showTablesInfo.getTableName(), null), pkColumnSet));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getBestRowIdentifier: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed Best Row Identifier for catalog = {0}, schema = {1}, table = {2}", catalog, schema, table);
        }
        return intermediateRs;
    }

    public List<MetadataAPIHelper.ShowGrantsInfo> getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowGrantsInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowGrantsInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<Object> schemaList = new ArrayList<MetadataAPIHelper.ShowSchemasInfo>();
                if (Utils.isNullOrEmpty(schema)) {
                    schemaList = this.callShowSchemas(curCatalog, schema, false);
                } else {
                    schemaList.add(new MetadataAPIHelper.ShowSchemasInfo(schema));
                }
                for (MetadataAPIHelper.ShowSchemasInfo showSchemasInfo : schemaList) {
                    PreparedStatement stmt = this.createMetaDataPreparedStatement("SHOW COLUMN GRANTS ON TABLE ?.?.?;");
                    Throwable throwable = null;
                    try {
                        stmt.setString(1, curCatalog);
                        stmt.setString(2, showSchemasInfo.getSchemaName());
                        stmt.setString(3, table);
                        stmt.execute();
                        try {
                            ResultSet rs = stmt.getResultSet();
                            Throwable throwable2 = null;
                            try {
                                while (rs.next()) {
                                    intermediateRs.add(new MetadataAPIHelper.ShowGrantsInfo(rs.getString("database_name"), rs.getString("schema_name"), null, rs.getString("table_name"), rs.getString("column_name"), rs.getString("grantor_name"), rs.getString("identity_name"), rs.getString("privilege_type"), rs.getBoolean("admin_option")));
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (rs == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                rs.close();
                            }
                        }
                        catch (SQLException e) {
                            throw new RedshiftException("MetadataServerProxy.getColumnPrivileges: " + e.getMessage(), e);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getColumnPrivileges: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW GRANTS ON COLUMN for catalog = {0}, schema = {1}, table = {2}, columnNamePattern = {3}", catalog, schema, table, columnNamePattern);
        }
        return intermediateRs;
    }

    public List<MetadataAPIHelper.ShowGrantsInfo> getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowGrantsInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowGrantsInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCatalog, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    List<MetadataAPIHelper.ShowTablesInfo> tableList = this.callShowTables(curCatalog, curSchema.getSchemaName(), tableNamePattern, false);
                    for (MetadataAPIHelper.ShowTablesInfo curTable : tableList) {
                        PreparedStatement stmt = this.createMetaDataPreparedStatement("SHOW GRANTS ON TABLE ?.?.?;");
                        Throwable throwable = null;
                        try {
                            stmt.setString(1, curCatalog);
                            stmt.setString(2, curSchema.getSchemaName());
                            stmt.setString(3, curTable.getTableName());
                            stmt.execute();
                            try {
                                ResultSet rs = stmt.getResultSet();
                                Throwable throwable2 = null;
                                try {
                                    while (rs.next()) {
                                        intermediateRs.add(new MetadataAPIHelper.ShowGrantsInfo(rs.getString("database_name"), rs.getString("schema_name"), rs.getString("object_name"), null, null, rs.getString("grantor_name"), rs.getString("identity_name"), rs.getString("privilege_type"), rs.getBoolean("admin_option")));
                                    }
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (rs == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    rs.close();
                                }
                            }
                            catch (SQLException e) {
                                throw new RedshiftException("MetadataServerProxy.getTablePrivileges: " + e.getMessage(), e);
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getTablePrivileges: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW GRANTS ON TABLE for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}", catalog, schemaPattern, tableNamePattern);
        }
        return intermediateRs;
    }

    public List<MetadataAPIHelper.ShowProceduresInfo> getProcedures(String catalog, String schemaPattern, String procedureNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowProceduresInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowProceduresInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCatalog, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    intermediateRs.addAll(this.callShowProcedures(curCatalog, curSchema.getSchemaName(), procedureNamePattern, true));
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getProcedures: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW PROCEDURES for catalog = {0}, schemaPattern = {1}, procedureNamePattern = {2}", catalog, schemaPattern, procedureNamePattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ProcedureFunctionColumnData> getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ProcedureFunctionColumnData> intermediateRs = new ArrayList<MetadataAPIHelper.ProcedureFunctionColumnData>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCatalog, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    List<MetadataAPIHelper.ShowProceduresInfo> procedureList = this.callShowProcedures(curCatalog, curSchema.getSchemaName(), procedureNamePattern, false);
                    for (MetadataAPIHelper.ShowProceduresInfo curProcedurePair : procedureList) {
                        if (curProcedurePair == null) continue;
                        String procedureName = curProcedurePair.getProcedureName();
                        String argumentList = curProcedurePair.getArgumentList();
                        Map.Entry<String, List<String>> queryData = this.createParameterizedQueryString(argumentList, "SHOW PARAMETERS OF PROCEDURE ?.?.?", columnNamePattern);
                        PreparedStatement stmt = this.createMetaDataPreparedStatement(queryData.getKey());
                        Throwable throwable = null;
                        try {
                            stmt.setString(1, curCatalog);
                            stmt.setString(2, curSchema.getSchemaName());
                            stmt.setString(3, procedureName);
                            int paramIndex = 4;
                            for (String argument : queryData.getValue()) {
                                stmt.setString(paramIndex++, argument);
                            }
                            if (!Utils.isNullOrEmpty(columnNamePattern)) {
                                stmt.setString(paramIndex, columnNamePattern);
                            }
                            stmt.execute();
                            String specificName = this.getSpecificName(procedureName, argumentList);
                            ArrayList<MetadataAPIHelper.ShowParametersInfo> showParamResult = new ArrayList<MetadataAPIHelper.ShowParametersInfo>();
                            try (ResultSet rs = stmt.getResultSet();){
                                while (rs.next()) {
                                    showParamResult.add(new MetadataAPIHelper.ShowParametersInfo(rs.getString("database_name"), rs.getString("schema_name"), rs.getString("procedure_name"), null, rs.getString("parameter_name"), rs.getString("ordinal_position"), rs.getString("parameter_type"), rs.getString("data_type"), rs.getString("character_maximum_length"), rs.getString("numeric_precision"), rs.getString("numeric_scale")));
                                }
                            }
                            intermediateRs.add(new MetadataAPIHelper.ProcedureFunctionColumnData(specificName, showParamResult));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getProcedureColumns: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW COLUMNS FROM PROCEDURE for catalog = {0}, schemaPattern = {1}, procedureNamePattern = {2}, columnNamePattern = {3}", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ShowFunctionsInfo> getFunctions(String catalog, String schemaPattern, String functionNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ShowFunctionsInfo> intermediateRs = new ArrayList<MetadataAPIHelper.ShowFunctionsInfo>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCatalog, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    intermediateRs.addAll(this.callShowFunctions(curCatalog, curSchema.getSchemaName(), functionNamePattern, true));
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getFunctions: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW FUNCTIONS for catalog = {0}, schemaPattern = {1}, functionNamePattern = {2}", catalog, schemaPattern, functionNamePattern);
        }
        return intermediateRs;
    }

    protected List<MetadataAPIHelper.ProcedureFunctionColumnData> getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern, boolean isSingleDatabaseMetaData) throws SQLException {
        ArrayList<MetadataAPIHelper.ProcedureFunctionColumnData> intermediateRs = new ArrayList<MetadataAPIHelper.ProcedureFunctionColumnData>();
        try {
            List<String> catalogList = this.fetchCatalogNames(catalog, isSingleDatabaseMetaData);
            for (String curCatalog : catalogList) {
                List<MetadataAPIHelper.ShowSchemasInfo> schemaList = this.callShowSchemas(curCatalog, schemaPattern, false);
                for (MetadataAPIHelper.ShowSchemasInfo curSchema : schemaList) {
                    List<MetadataAPIHelper.ShowFunctionsInfo> functionsList = this.callShowFunctions(curCatalog, curSchema.getSchemaName(), functionNamePattern, false);
                    for (MetadataAPIHelper.ShowFunctionsInfo curFunctionPair : functionsList) {
                        if (curFunctionPair == null) continue;
                        String functionName = curFunctionPair.getFunctionName();
                        String argumentList = curFunctionPair.getArgumentList();
                        Map.Entry<String, List<String>> queryData = this.createParameterizedQueryString(argumentList, "SHOW PARAMETERS OF FUNCTION ?.?.?", columnNamePattern);
                        PreparedStatement stmt = this.createMetaDataPreparedStatement(queryData.getKey());
                        Throwable throwable = null;
                        try {
                            stmt.setString(1, curCatalog);
                            stmt.setString(2, curSchema.getSchemaName());
                            stmt.setString(3, functionName);
                            int paramIndex = 4;
                            for (String argument : queryData.getValue()) {
                                stmt.setString(paramIndex++, argument);
                            }
                            if (!Utils.isNullOrEmpty(columnNamePattern)) {
                                stmt.setString(paramIndex, columnNamePattern);
                            }
                            stmt.execute();
                            String specificName = this.getSpecificName(functionName, argumentList);
                            ArrayList<MetadataAPIHelper.ShowParametersInfo> showParamResult = new ArrayList<MetadataAPIHelper.ShowParametersInfo>();
                            try (ResultSet rs = stmt.getResultSet();){
                                while (rs.next()) {
                                    showParamResult.add(new MetadataAPIHelper.ShowParametersInfo(rs.getString("database_name"), rs.getString("schema_name"), null, rs.getString("function_name"), rs.getString("parameter_name"), rs.getString("ordinal_position"), rs.getString("parameter_type"), rs.getString("data_type"), rs.getString("character_maximum_length"), rs.getString("numeric_precision"), rs.getString("numeric_scale")));
                                }
                            }
                            intermediateRs.add(new MetadataAPIHelper.ProcedureFunctionColumnData(specificName, showParamResult));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RedshiftException("MetadataServerProxy.getFunctionColumns: " + e.getMessage(), e);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW COLUMNS FROM FUNCTION LIKE for catalog = {0}, schemaPattern = {1}, functionNamePattern = {2}, columnNamePattern = {3}", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        return intermediateRs;
    }

    /*
     * Exception decompiling
     */
    protected List<String> fetchCatalogNames(String catalog, boolean isSingleDatabaseMetaData) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowSchemasInfo> callShowSchemas(String catalog, String schemaPattern, boolean fullResult) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowTablesInfo> callShowTables(String catalog, String schema, String tableNamePattern, boolean fullResult) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowColumnsInfo> callShowColumns(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowPrimaryKeysInfo> callShowConstraintsPrimaryKey(String catalog, String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowForeignKeysInfo> callShowConstraintsForeignKey(String catalog, String schema, String table, String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowProceduresInfo> callShowProcedures(String catalog, String schema, String procedureNamePattern, boolean fullResult) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<MetadataAPIHelper.ShowFunctionsInfo> callShowFunctions(String catalog, String schema, String functionNamePattern, boolean fullResult) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

