/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class DFABQTrackingTransitionConstraintsNode
extends DFAAbstractStateNode {
    @CompilerDirectives.CompilationFinal(dimensions=2)
    public final long[][] constraints;

    public DFABQTrackingTransitionConstraintsNode(short id, short[] successors, long[][] constraints) {
        super(id, successors);
        this.constraints = constraints;
    }

    @ExplodeLoop
    public static boolean constraintsAreSatisfied(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, long[] constraints) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)executor));
        CompilerAsserts.partialEvaluationConstant((Object)constraints);
        for (long constraint : constraints) {
            int qId = TransitionConstraint.getQuantifierID(constraint);
            CompilerAsserts.partialEvaluationConstant((long)constraint);
            CompilerAsserts.partialEvaluationConstant((int)qId);
            CounterTracker counterTracker = executor.getCounterTrackers()[qId];
            CompilerAsserts.partialEvaluationConstant((Object)counterTracker);
            if (counterTracker.canExecute(constraint, locals.getFixedData(), locals.getIntArrays())) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonValue toJson() {
        return null;
    }
}

