\name{IsolatedConnectedImageFilter}
\alias{IsolatedConnectedImageFilter}
\title{IsolatedConnectedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Label pixels that are connected to one set of seeds but not another.
IsolatedConnectedImageFilter}
\details{
IsolatedConnectedImageFilter finds the optimal threshold to separate two regions. It has two
modes, one to separate dark regions surrounded by bright regions by
automatically finding a minimum isolating upper threshold, and another
to separate bright regions surrounded by dark regions by automatically
finding a maximum lower isolating threshold. The mode can be chosen by
setting FindUpperThresholdOn() /Off(). In both cases, the isolating threshold is retrieved with GetIsolatedValue() .
The algorithm labels pixels with ReplaceValue that are connected to
Seeds1 AND NOT connected to Seeds2. When finding the threshold to
separate two dark regions surrounded by bright regions, given a fixed
lower threshold, the filter adjusts the upper threshold until the two
sets of seeds are not connected. The algorithm uses a binary search to
adjust the upper threshold, starting at Upper. The reverse is true for
finding the threshold to separate two bright regions. Lower defaults
to the smallest possible value for the InputImagePixelType, and Upper
defaults to the largest possible value for the InputImagePixelType.
The user can also supply the Lower and Upper values to restrict the
search. However, if the range is too restrictive, it could happen that
no isolating threshold can be found between the user specified Lower
and Upper values. Therefore, unless the user is sure of the bounds to
set, it is recommended that the user set these values to the lowest
and highest intensity values in the image, respectively.
The user can specify more than one seed for both regions to separate.
The algorithm will try find the threshold that ensures that all of the
first seeds are contained in the resulting segmentation and all of the
second seeds are not contained in the segmentation.
It is possible that the algorithm may not be able to find the
isolating threshold because no such threshold exists. The user can
check for this by querying the GetThresholdingFailed() flag.
See:
IsolatedConnected for the procedural interface
itk::IsolatedConnectedImageFilter for the Doxygen on the original ITK class.
IsolatedConnectedImageFilter}
%C++ includes: sitkIsolatedConnectedImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FindUpperThresholdOff():}{}
\item{Self FindUpperThresholdOn():}{
Set the value of FindUpperThreshold to true or false respectfully.
}
\item{bool GetFindUpperThreshold() const:}{
Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).
}
\item{double GetIsolatedValue() const:}{
Get value that isolates the two seeds.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetIsolatedValueTolerance() const:}{
Set/Get the precision required for the intensity threshold value. The
default is 1.
}
\item{double GetLower() const:}{
Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetReplaceValue() const:}{
Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.
}
\item{std::vector< unsigned int > GetSeed1() const:}{}
\item{std::vector< unsigned int > GetSeed2() const:}{}
\item{bool GetThresholdingFailed() const:}{
Get the flag that tells whether the algorithm failed to find a
threshold.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetUpper() const:}{
Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.
}
\item{ IsolatedConnectedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFindUpperThreshold(bool FindUpperThreshold):}{
Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).
}
\item{Self SetIsolatedValueTolerance(double IsolatedValueTolerance):}{
Set/Get the precision required for the intensity threshold value. The
default is 1.
}
\item{Self SetLower(double Lower):}{
Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.
}
\item{Self SetReplaceValue(uint8_t ReplaceValue):}{
Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.
}
\item{Self SetSeed1(std::vector< unsigned int > Seed1):}{
     Set a single seed point 1.
This seed will be isolated from Seed2 (if possible). All pixels
connected to this seed will be replaced with ReplaceValue.
}
\item{Self SetSeed2(std::vector< unsigned int > Seed2):}{
     Set a single seed point 2.
This seed will be isolated from Seed1 (if possible).
}
\item{Self SetUpper(double Upper):}{
Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~IsolatedConnectedImageFilter():}{
Destructor
}
}
}
